<?php
namespace addons\coupon;


use think\addons\Addons;
use addons\coupon\model\Coupons as DM;

/**
 * WSTStore 优惠券
 * @author WSTMart
 */
class Coupon extends Addons{
    // 该插件的基础信息
    public $info = [
        'name' => 'Coupon',   // 插件标识
        'title' => '优惠券',  // 插件名称
        'description' => '营销插件-优惠券',    // 插件简介
        'status' => 0,  // 状态
        'author' => 'WSTStore',
        'version' => '1.0.0'
    ];

	
    /**
     * 插件安装方法
     * @return bool
     */
    public function install(){
        $m = new DM();
        $flag = $m->installMenu();
        WSTClearHookCache();
        return $flag;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall(){
        $m = new DM();
        $flag = $m->uninstallMenu();
        WSTClearHookCache();
        return $flag;
    }
    
	/**
     * 插件启用方法
     * @return bool
     */
    public function enable(){
        $m = new DM();
        $flag = $m->toggleShow(1);
        WSTClearHookCache();
        return true;
    }
    
    /**
     * 插件禁用方法
     * @return bool
     */
    public function disable(){
        $m = new DM();
        $flag = $m->toggleShow(0);
        WSTClearHookCache();
    	return true;
    }
    
    /**
     * 插件设置方法
     * @return bool
     */
    public function saveConfig(){
    	WSTClearHookCache();
    	return true;
    }
     /**
     * 手机端
     * 
     */
    // 商品详情页优惠券
    public function mobileDocumentGoodsDetail(){
        return $this->fetch('view/mobile/index/goods_detail_coupon');
    }
    // 用户优惠总数
    public function mobileDocumentUserIndexTerm(){
        return $this->fetch('view/mobile/users/term');
    }
    // 用户优惠券列表
    public function mobileDocumentUserIndexTools(){
        return $this->fetch('view/mobile/users/index');
    }
    //确认订单结算页
    public function mobileDocumentCartShopPromotion($params){
        $m=new DM();
        $coupons= $m->getAvailableCoupons($params);
        $this->assign('coupons',$coupons);
        return $this->fetch('view/mobile/users/coupon');
    }
    //订单详情
    public function mobileDocumentOrderSummaryView($params){
        $hook = '';
        if($params['rs']['userCouponId']>0){
            // 获取优惠券信息
            $money = json_decode($params['rs']['userCouponJson'],true)['money']; // 优惠券优惠金额
            $hook = "<div class='cost'>优惠券优惠<span >￥-". number_format($money,2)."</span></div>";
        }
        $params['rs']['hook'] = $hook;
    }
    /**
     * 微信端
     * 
     */
    // 商品详情页优惠券
    public function wechatDocumentGoodsDetail(){
        return $this->fetch('view/wechat/index/goods_detail_coupon');
    }
    // 用户优惠总数
    public function wechatDocumentUserIndexTerm(){
        return $this->fetch('view/wechat/users/term');
    }
    // 用户优惠券列表
    public function wechatDocumentUserIndexTools(){
        return $this->fetch('view/wechat/users/index');
    }
    //确认订单结算页
    public function wechatDocumentCartShopPromotion($params){
        $m=new DM();
        $coupons= $m->getAvailableCoupons($params);
        $this->assign('coupons',$coupons);
        return $this->fetch('view/wechat/users/coupon');
    }
    /**
     * 查询购物车之后执行代码
     */
    public function afterQueryCarts($params){
        if($params['isSettlement']){
            $m = new DM();
            $params['carts']['coupons'] = $m->getAvailableCoupons(['cartGoods'=>$params['carts']['carts']],$params['uId']);
        }
    }
    //订单详情
    public function wechatDocumentOrderSummaryView($params){
        $hook = '';
        if($params['rs']['userCouponId']>0){
            // 获取优惠券信息
            $money = json_decode($params['rs']['userCouponJson'],true)['money']; // 优惠券优惠金额
            $hook = "<div class='cost'>优惠券优惠<span >￥-". number_format($money,2)."</span></div>";
        }
        $params['rs']['hook'] = $hook;
    }
    //计算购物金额
    public function afterCalculateCartMoney($params){
        $m = new DM();
        $m->calculateCartMoney($params);
    }
    /**
     * 新增订单前执行
     */
    public function beforeInsertOrder($params){
        $m = new DM();
        $m->beforeInsertOrder($params);
    }
    // 商品列表查询之后执行
    public function afterQueryGoods($params){
        $m =new DM();
        if(isset($params['page']['data'])){
            foreach ($params['page']['data'] as $k => $v) {
                $rs =$m->getGoodsCouponTags($v['goodsId']);
                if($rs>0){
                    if(isset($params['isApp'])){
                        $params["page"]["data"][$k]['isCoupon'] = true;
                    }else{
                        $params["page"]["data"][$k]['tags'][] = '<span class="tag">券</span>';
                    }
                }
            }
        }else if(isset($params['page']) && !empty($params['page'])){
            foreach ($params['page'] as $k => $v) {
                $rs =$m->getGoodsCouponTags($v['goodsId']);
                if($rs > 0){
                    $params['page'][$k]['tags'][]='<span class="tag">劵</span>';
                }
            }
            
        }   
    }
    // 注册送优惠券
    public function afterUserRegist($params){
        $m = new DM();
        $m->sendCouponRegist($params);
    }
    // 页面初始化定时任务
    public function initCouponHook(){
        $m = new DM();
        $m->sendCouponBirthday();
    }
}