Напишіть **TCP сервер**!

Ваш сервер має очікувати TCP з’єднань на порту, котрий Ви отримаєте у якості першого аргументу командного рядка. На кожне підключення Ви мусите повертати поточну дату та час у форматі:

```
"YYYY-MM-DD hh:mm"
```

в кінці рядка обов’язково має бути **символ нового рядка**. Місяці, дні, години та хвилини мають бути двохчисельні, тобто:

```
"2013-07-06 17:42"
```

----------------------------------------------------------------------
## ІНФОРМАЦІЯ

У цьому завданні ми будемо створювати простий ТСР-сервер. Оскільки нам не знадобиться HTTP, то ми можемо просто використати вбудований в Node.js модуль `net`, котрий включає всі базові функції для роботи з мережею.

У модуля `net` є метод `net.createServer()`, котрий приймає функцію в якості аргументу. На відміну від функцій окремого виклику (callbacks) в Node, функція передана в `createServer()` викликається більш ніж один раз. Кожне нове з’єднання з сервером буде викликати цю функцію. Вона має наступну сигнатуру:

```js
function callback (socket) { /* ... */ }
```

`net.createServer()` також повертає екземпляр `server`. Ви повинні викликати `server.listen(portNumber)` для запуску сервера на заданому порті.

Типовий Node TCP-сервер виглядає так:

```js
const net = require('net')
const server = net.createServer(function (socket) {
  // керування отриманими сокетами
})
server.listen(8000)
```

Пам’ятайте про те, що Ви повинні використовувати номер порту, переданий Вам в першому аргументі командного рядка.

Об’єкт `socket` містить в собі багато мета-данних про з’єднання, але окрім цього, він також є дуплексним потоком (duplex Stream) в Node - це означає, що він може і писати і читати дані. У нашому випадку, ми повинні написати (ввести) дані, і після того закрити з’єднання.

Використовуйте `socket.write(data)` для того, щоб вивести дані та `socket.end()`, щоб закрити з’єднання. Також метод `.end()` може приймати данні в якості аргументу, тому Ви можете вивести данні наступним чином: `socket.end(data)`.

Документацію до модуля `net` можна знайти, перейшовши у браузері:

  {rootdir:/docs-nodejs/net.html}

Для роботи з датами скористайтесь новим об’єктом `new Date()`, передавши йому необхідний формат. Наступні методи можуть бути корисними:

```js
date.getFullYear()
date.getMonth() // починається із 0
date.getDate() // повертає день місяця
date.getHours()
date.getMinutes()
```

В іншому випадку, якщо Ви бажаєте бути дослідником, то скористайтесь пакетом `strftime` з npm. Функція `strftime(fmt, date)` приймає такий же формат дати, як і unix `date` команда. Додаткову інформацію про strftime можна знайти тут: https://github.com/samsonjs/strftime
