Реализуйте **TCP сервер**, возвращающий текущее время при соединении.

Ваш сервер должен ожидать TCP соединений на порту, который Вы получите в качестве первого аргумента командной строки. На каждое новое соединение сервер должен возвращать текущую дату и время в формате:

```
"YYYY-MM-DD hh:mm"
```

В конце строки с именем обязательно должен быть символ **переноса строки**. Месяцы, дни, часы и минуты должны быть двучисленными, например:

```
"2013-07-06 17:42"
```
----------------------------------------------------------------------
## ИНФОРМАЦИЯ

В этом задании мы будем создавать простой TCP сервер. Так как нам не потребуется HTTP, то мы можем просто использовать встроенный модуль `net`, который включает в себя все базовые функции для работы с сетью.

У `net` модуля есть метод `net.createServer()`, который принимает функцию в качестве аргумента. В отличие от других функций обратного вызова в Node, функция, переданная в `net.createServer()` вызывается больше чем один раз. Каждое новое соединение с сервером будет вызывать эту функцию. Она имеет следующую сигнатуру:

```js
function callback (socket) { /* ... */ }
```

`net.createServer()` возвращает экземпляр `server`. Вы должны вызвать `server.listen(portNumber)`, для того чтобы запустить сервер на заданом порту.

Типичный Node TCP сервер выглядит так:

```js
const net = require('net')
const server = net.createServer(function (socket) {
  // socket handling logic
})
server.listen(8000)
```

Помните о том, что Вы должны использовать номер порта, переданный Вам в первом аргементе командной строки.

Объект `socket` содержит в себе много мета-данных о соединении, но помимо этого, он так же является дуплексным потоком (duplex Stream) Node, это означает что он может и читать, и писать данные. В нашем случае мы должны только написать (вывести) данные и затем закрыть соединение.

Используйте `socket.write(data)`, для того чтобы вывести данные и `socket.end()`, для того чтобы закрыть соединение. Также метод `.end()` может принимать данные в качестве аргумента, поэтому Вы можете вывести данные следующим образом: `socket.end(data)`.

Документацию для `net` модуля Вы сможете найти, набрав в браузере:
  {rootdir:/docs-nodejs/net.html}

Для работы с датой воспользуйтесь `new Date()` объектом. Следующие методы могут быть полезны:

```js
date.getFullYear()
date.getMonth() // starts at 0
date.getDate() // returns the day of month
date.getHours()
date.getMinutes()
```

В другом случае, если работа со стандартным объектом даты кажется скучной, то можно воспользоваться `strftime` библиотекой. Функция `strftime(frm, date)` принимает такие же форматы даты, как и unix `date` комманда. Дополнительную информацию о `strftime` Вы можете получить на: https://github.com/samsonjs/strftime
