Реализуйте программу, которая *синхронно* читает файл и выводит количество, строк (\n) содержащихся в файле, в консоль (stdout), точно так же, как это сделала бы команда `cat file | wc -l`.

Полный путь до файла будет передан в качестве первого аргумента командной строки. Вам не нужно создавать тестовый файл самостоятельно.

----------------------------------------------------------------------
## ИНФОРМАЦИЯ

Для того чтобы прочитать файл Вам понадобится модуль `fs` из встроенной библиотеки Node. Для того чтобы загрузить этот, или любой другой, модуль из этой библиотеки воспользуйтесь следующей конструкцией:

```js
const fs = require('fs')
```

Таким образом `fs` модуль будет доступен в переменной `fs`.

Все синхронные (или блокирующие) методы файловой системы в `fs` оканчиваются на `Sync`. Для того чтобы прочитать файл Вам понадобится `fs.readFileSync('/path/to/file')`. Этот метод вернет объект типа `Buffer` содержащий весь контент файла.

Документацию для `fs` модуля вы сможете найти набрав в браузере:
  {rootdir:/docs-nodejs/fs.html}

Объекты типа `Buffer` используются Node для эффективного представления массивов данных, будь это ascii, бинарный или любой другой формат. Эти объекты могут быть конвертированы в строки путем вызовом метода `toString()` над ними, например `const str = buf.toString()`.

Документацию для `Buffer` вы сможете найти набрав в браузере:
  {rootdir:/docs-nodejs/buffer.html}

Если Вы ищите простой способ посчитать строк в строке, то Вы можете использовать `.split()` с разделителем `\n` для разбиения этой строки на массив подстрок. Примите во внимание то, что тестовый файл не содержит символ `\n` в конце последней строки, таки образом у вас получится массив который содержит на один элемент больше чем число строк в файле.
