**同期処理** をするファイルシステムの関数を使ってファイルの改行文字(\n)の数を出力するアプリを書いてください。 `cat file | wc -l` と同じようなアプリです。

アプリの1つ目のコマンドライン引数は、そのファイルへのパスです。テスト用のファイルを作る必要はありません。

----------------------------------------------------------------------
## ヒント

ファイルシステムにアクセスするためにはNodeのコアライブラリの `fs` モジュールが必要となります。
モジュールをロードするには以下のようにします:

```js
const fs = require('fs')
```

その後は `fs` という変数で `fs` というモジュールを利用出来ます。

同期処理(ブロッキング)をする関数は、名前の後ろに `Sync` がついています。ファイルを読むためには `fs.readFileSync('/あなた/の/ファイル')` を使ってください。
この関数は `Buffer` オブジェクトを返します。この `Buffer` を使うことで全てのファイルコンテンツにアクセスできます。

`fs` モジュールのドキュメントは以下のリンクをブラウザでご覧ください:
  {rootdir:/docs-nodejs/fs.html}

`Buffer` オブジェクトは、ASCIIやバイナリ、その他のフォーマットを扱う際の Nodeの効率的な方法です。エンコーディングは関係ありません。
`Buffer` のオブジェクトは `toString()` をつかって String に変換できます。

例えば `const str = buf.toString()`.

`Buffer` モジュールのドキュメントは、このリンクをブラウザで見てください:
  {rootdir:/docs-nodejs/buffer.html}

簡単に改行を数える方法を探しているのなら、このヒントは役に立つでしょう：

JavaScriptの `String` は `.split()` 関数を使って分割出来ます。`\n` を区切り文字として使えば String を1行ずつに分割した Array を受け取ることが出来ます。
ただし、ファイルの最後の改行には気をつけてください。
