撰寫一個程式，以 **非同步（ asynchronous ）** 的檔案操作方式讀入一個檔案，並在命令列上顯示該檔案的行數。這個程式的行為類似終端機命令 `cat file | wc -l` 。

程式的第一個命令列參數將是檔案的完整路徑。

----------------------------------------------------------------------
# 提示

除了現在您必須以 **Node.js 的** 非同步（asynchronous）方式解決這個習題以外，這個習題的解法 *幾乎* 和前一個習題相同。

您要使用 `fs.readFile()` 取代 `fs.readFileSync()` 方法，相對地，還要用在第二個參數中傳入收集資料的 callback 函式，以取代原本使用回傳值的方法。

請記得， Node.js 的 callback 函式一般會有以下的語法特徵：

```js
function callback (err, data) { /* ... */ }
```

所以您就可以藉著檢查第一個參數是否為 True 以確認是不是有錯誤發生。如果沒有錯誤發生，您應該就會可以取得 Buffer 物件作為您的第二個參數。如果使用 `readFileSync()` 方法，您可以在第二參數中改填入「utf8」，然後把 callback 函式放在第三個參數，相對地，您會得到一個 `String` 而非 `Buffer`。

要閱讀 `fs` 模組的文件，可以在瀏覽器中打開這個頁面：
  {rootdir:/docs-nodejs/fs.html}
