编写一个程序，执行一个**异步**的对文件系统的操作：读取一个文件，并且在终端（标准输出 stdout）打印出这个文件中的内容的行数。类似于执行 `cat file | wc -l` 这个命令。

所要读取的文件的完整路径会在命令行第一个参数提供。

----------------------------------------------------------------------
# 提示

这个题目的答案*几乎*和前一个问题一样，但是你需要用更加**符合 Node.js 的风格**的方式解决：异步。

你将要使用 `fs.readFile()` 方法，而不是 `fs.readFileSync()`，并且你需要从你所传入的回调函数中去收集数据（这些数据会作为第二参数传递给你的回调函数），而不是使用方法的返回值。想要学习更多关于回调函数的知识，请查阅：https://github.com/maxogden/art-of-node#callbacks。

记住，我们习惯中的 Node.js 回调函数都有像如下所示的特征：

```js
function callback (err, data) { /* ... */ }
```

所以，你可以通过检查第一个参数的真假值来判断是否有错误发生。如果没有错误发生，你会在第二个参数中获取到一个 `Buffer` 对象。和 `readFileSync()` 一样，你可以传入 'utf8' 作为它的第二个参数，然后把回调函数作为第三个参数，这样，你得到的将会是一个字符串，而不是 Buffer。

`fs` 模块的文档可以通过使用你的浏览器访问如下路径来查看：
  {rootdir:/docs-nodejs/fs.html}
