Реализуйте программу, которая *асинхронно* прочитает файл и выведет количество строк, содержащихся в файле, в консоль (stdout) точно так же, как это сделала бы команда `cat file | wc -l`.

Полный путь до файла будет передан в качестве первого аргумента командной строки.

----------------------------------------------------------------------
## ИНФОРМАЦИЯ

Решение этой задачи *практически* такое же, как и предущее, только Вы должны сделать это **в стиле Node.js**: асинхронно.

Вместо `fs.readFileSync()` нужно использовать `fs.readFile()`, и вместо того, чтобы просто вернуть результат этого метода, Вы должны собрать вывод из функции обратного вызова, которую Вы передадите вторым аргументом. Для получения большей информации о функциях обратного вызова, воспользуйтесь: https://github.com/maxogden/art-of-node#callbacks.

Примите во внимание то, что характерные для Node.js функции обратного вызова имеют следующую сигнатуру:

```js
function callback (err, data) { /* ... */ }
```

Таким образом Вы можете узнать о наличии ошибки с помощью проверки первого аргумента функции на истинность. Если ошибки нет, то Вы должны получить объект `Buffer` в качестве второго аргумента. Как и с `readFileSync()` Вы можете указать вторым аргументом 'utf8' и передать функцию обратного вызова в третий аргумент и получить результат типа 'String' вместо 'Buffer'.

Документацию для `fs` модуля Вы сможете найти набрав в браузере:
  {rootdir:/docs-nodejs/fs.html}
