**非同期処理** をするファイルシステムのメソッドを使ってファイルの改行数を出力するアプリを書いてください。 `cat file | wc -l` と同じようなアプリです。

アプリの1つ目のコマンドライン引数は、そのファイルへのパスです。

----------------------------------------------------------------------
# ヒント

解決方法は前回とほとんど一緒です。しかし今回は Node に適した方法にする必要があります：**非同期(Async)** 。
`fs.readFileSync()` ではなく `fs.readFile()` を使います。返り値を受け取るのではなく、2つ目の引数であるコールバック関数を使って値を受け取ってください。

コールバックについて勉強したい場合はこれを読んでください： https://github.com/maxogden/art-of-node#callbacks

習慣的として Node のコールバック関数は、以下のように引数をとることに注意してください：

```js
function callback (err, data) { /* ... */ }
```

1つ目の引数 `err` でエラーの判別を行うことができます。
エラーが発生しなければ `err` は `null` となり、2つ目の引数には `Buffer` オブジェクトが入ります。

`readFileSync`と同じようにファイルパスとコールバック引数の間に `"utf8"` を入れてもいいです。その場合、 `Buffer` のかわりに `String` が返るようになります。

`fs` モジュールのドキュメントはブラウザーでこのリンクを見てください:
  {rootdir:/docs-nodejs/fs.html}
