Ця задача дуже схожа на попередню, з тією лише різницею, що вона знайомить нас з концепцією **модулів**. Ви маєте створити два файли, щоб розв’язати цю задачу.

Реалізуйте програму, котра виведе список відфільтрованих по розширенню файлів у вказаній директорії. Першим аргументом командного рядка буде передано ім’я директорії ('path/to/dir/'), другим аргументом буде розширення файлу для фільтрації. Виведіть список файлів (один файл на одному рядку) у консоль. Вам **потрібно** використати асинхронний I/O.

Вам потрібно написати *модуль (module)* - файл, котрий буде виконувати майже всю роботу. Модуль має *експортувати* одну функцію, котра приймає **три** аргументи: ім’я директорії, рядок з розширенням файлу та функцію зворотнього виклику. Розширення файлу має бути таким же, яким воно було отримано Вашою програмою. Не перетворюйте його в RegExp, не додавайте "." на початок, просто передайте його у Ваш модуль, де і будуть здійснюватись всі необхідні операції з фільтрації.

Функція зворотнього виклику (callback) має бути викликаною в характерному для Node.js погодженні: node(err, data). Згідно цього оголошення, якщо помилки немає, то перший аргумент функції буде рівний null, а другий буде містити данні. В цьому завданні в якості данних буде виступати відфільтрований список файлів у вигляді масиву. Якщо ви отримали помилку, наприклад, з виклику `fs.readdir()`, то функція зворотнього виклику (callback) буде викликана тільки з помилкою в якості першого аргументу.

Ви **не повинні** виводити список в консоль напряму з вашого модуля, це має відбуватись лише з вашої оригінальної програми.

Якщо ви отримали помилку з модуля, то просто перевірте її наявність у Вашій програмі, та виведіть зрозуміле повідомлення в консоль.

Ваш модуль має відповідати наступним чотирьом погодженням:

1. Експортувати функцію, яка приймає аргументи точно так, як описано вище.
2. Викликати функцію зворотнього виклику (callback) один раз з помилкою або даними, як і було описано вище.
3. Не повинен змінювати нічого іншого, наприклад, глобальні змінні або  stdout.
4. Відловлювати всі помилки, котрі можуть виникнути, і передавати їх в функцію зворотнього виклику.

Перевага використання погодження полягає у тому, що Ваш модуль зможе використовувати будь-хто, хто очікує такої поведінки від модуля. Тож Ваш модуль міг би використовувати будь-який інший учень learnyounode, або той, хто перевіряє завдання, і це просто буде працювати.

----------------------------------------------------------------------
## ІНФОРМАЦІЯ

Створіть модуль з допомогою створення нового файлу, в котрому міститься тільки функція читання та фільтрації переданої директорії. Для *експортування* даної функції, присвойте її об’єкту `module.exports`, перезаписавши тим самим те, що там було до цього:

```js
module.exports = function (args) { /* ... */ }
```

Або Ви можете використовувати іменовану функцію і присвоїти тільки її ім’я.

Для використання Вашого модуля у програмі, скористайтесь `require()` точно так, як Ви робили це для отримання `fs` модуля `require('fs')`. З тією лише різницею, що для локальних модулів Вам слід додавати префікс './'. Наприклад, якщо файл носить назву mymodule.js, то:

```js
const mymodule = require('./mymodule.js')
```

Розширення '.js' тут не обов’язкове і Ви будете часто помічати, як його упускають.

Зараз ви отримали об’єкт `module.exports` з вашого модуля, що був присвоєний змінній `mymodule`. Якщо Ви експортували функцію, то `mymodule` буде функцією, котру можна викликати!

Також зауважте, що характерним є перевірка помилки і переривання сценарію, шляхом повернення функції зворотнього виклику з помилкою:

```js
function bar (callback) {
  foo(function (err, data) {
    if (err) { return callback(err) } // перериваємо сценарій, повертаємо помилку

    // ... тут помилок немає, продовжуємо роботу з `data`

    // все йде гаразд, викликаємо функцію з переданим `null` в якості аргументу-помилки

    callback(null, data)
  })
}
```
