Эта задача очень похожа на предыдущую, с той лишь разницей, что она знакомит нас с концепцией **модулей**. Вы должны создать два файла, чтобы решить данную задачу.

Реализуйте программу, которая выводит список отфильтрованных по расширению файлов в заданной директории. Имя директории ('/path/to/dir/') будет передано в качестве первого аргумента к вашей программе, а расширение файла для фильтрации в качестве второго.

Вы должны создать *модуль*, который будет делать практически всю работу. Модуль должен *экспортировать* функцию, которая принимает три параметра: имя директории, расширение файла и функцию обратного вызова, в заданном порядке. Расширение файла должно быть передано точно таким же, каким оно было получено Вашей программой. Не преобразовывайте его в RegExp, не добавляйте '.' в начало, просто передайте его в Ваш модуль, где и осуществляйте все необходимые операции для того, чтобы фильтр заработал.

Функция обратного вызова должна быть вызвана в свойственном для Node.js соглашении: node(err, data). Это соглашение гласит, что если ошибки нет, то первый аргумент функции будет равен null, а второй будет содержать данные. В данном упражнении в качестве данных будет выступать список файлов в виде массива. Если Вы получили ошибку, предположим из вызова `fs.readdir()`, то функция обратного вызова должна быть вызвана только с ошибкой в качестве первого аргумента.

Вы **не должны** выводить список в консоль напрямую из вашего модуля, это должна делать ваша вызываемая программа.

Если Вы получили ошибку из модуля, то просто проверьте ее наличие в вашей программе и выведите понятное сообщение об ошибке в консоль.

Ваш модуль должен следовать следующим соглашениям:

1. Экспортировать функцию, принимающую аргументы в точности, как описано выше.
2. Вызывать функцию обратного вызова один раз с ошибкой или данными, как оговаривалось.
3. Не должен изменять глобальные переменные или stdout.
4. Отлавливать все ошибки, которые могут возникнуть, и передавать их в функцию обратного вызова.

Преимущество использования соглашений состоит в том, что Ваш модуль сможет использовать кто угодно, кто ожидает такое поведение от модуля. В нашем случае его сможет использовать другой ученик learnyounode или тот, кто проверяет это задание, и это просто будет работать.

----------------------------------------------------------------------
## ИНФОРМАЦИЯ

Создайте модуль с помощью создания нового файла, в котором содержится только функция чтения и фильтрации переданной директории. Для *экспортирования* данной функции присвойте ее к объекту `module.exports`, перезаписав тем самым то, что там было ранее.

```js
module.exports = function (args) { /* ... */ }
```

Или Вы можете использовать именованную функцию и присвоить только ее имя.

Для использования Вашего модуля в вызываемой программе, воспользуйтесь `require()` точно так же, как Вы делали это для получения `fs` модуля: `require('fs')`. С той лишь разницей, что для локальных модулей Вы должны добавить префикс './' в начале. Например, если файл называется mymodule.js, то:

```js
const mymodule = require('./mymodule.js')
```

'.js' расширение здесь необязательное, и Вы будете часто наблюдать, что оно опускается.

Сейчас Вы получили `module.exports` из Вашего модуля присвоенный к `mymodule` переменной. И если Вы экспортировали функцию, то mymodule является этой функцией, которую Вы можете вызвать.

Также примите во внимание, что характерным является проверка ошибки и прерывание сценария путем возвращения функции обратного вызова с ошибкой:

```js
function bar (callback) {
  foo(function (err, data) {
    if (err) { return callback(err) } // прерываем сценарий, возвращаем ошибку

    // ... тут ошибок нет, продолжаем работу с `data`

    // ... вызываем callback с переданым `null` в качестве аргумента-ошибки

    callback(null, data)
  })
}
```
