이 문제는 이전 문제와 같지만 **모듈**의 개념을 소개하고 있습니다. 이 문제를 풀려면 두 파일을 만들어야 합니다.

주어진 디렉터리의 파일 목록을 만든 후 확장자로 걸러 출력하는 프로그램을 만드세요. 프로그램의 첫 번째 인자로 디렉터리 이름(예: '/path/to/dir/')을 받고 거를 확장자는 두 번째 인자로 받습니다. **반드시** 비동기 I/O를 사용하세요.

대부분의 작업에서 반드시 *모듈* 파일을 작성해야 합니다. 모듈은 순서대로 디렉터리 이름, 파일 확장자 문자열, 콜백 함수 **세 개**의 인자를 받는 함수 하나만 *export*해야 합니다. 파일 확장자 인자는 프로그램에 넘겨진 인자와 같아야 합니다. 거르기 위해 정규식으로 바꾸거나, 앞에 .을 붙이거나, 그냥 넘기는 것 이외에 다른 어떤 일도 하시면 안 됩니다.

콜백 함수는 관용적인 노드(err, data) 관례대로 호출해야 합니다. 이 관례는 에러가 없는 경우 첫 번째 인자는 null이 되어야 하고, 두 번째 인자는 데이터여야 합니다. 이 연습 문제에서 데이터는 걸러진 파일 목록의 배열입니다. 에러를 받았다면(`fs.readdir()`를 호출하거나 하다가), 콜백은 에러만 첫 번째 인자로 넘겨서 호출해야 합니다.

모듈 파일 안에서 직접 콘솔에 출력하시면 **안** 됩니다. 원래 프로그램에서만 하세요.

원래 프로그램에서 에러가 일어난 경우, 간단히 확인만 해서 콘솔에 정보 메세지를 출력하세요.

이 네 가지는 모듈이 반드시 지켜야할 규칙입니다.

1. 설명한 인자만 받는 함수를 하나만 export해야 합니다.
2. 설명된 에러나 데이터로 콜백은 한 번만 호출해야 합니다.
3. 전역 변수나 표준출력(stdout) 같은 다른 건 아무것도 바꾸시면 안 됩니다.
4. 가능한 모든 에러를 처리해 콜백으로 넘겨야 합니다.

이 규칙을 지키면, 이 규칙을 지키는 어떤 곳에서도 모듈을 사용할 수 있게 됩니다. 그래서 이 모듈은 learnyounode를 한 어떤 사람이나, 검증 코드나 아니면 업무에서 사용 할 수 있습니다.

----------------------------------------------------------------------
## 힌트

디렉터리를 읽고 거르는 함수를 가지는 새 파일을 만들어 새 모듈을 만드세요. *단일 함수*의 *export*를 정의하려면, 함수를 이미 있는 `module.exports` 객체에 할당해야합니다.

```js
module.exports = function (args) { /* ... */ }
```

아니면 named 함수를 사용해 이름을 할당할 수도 있습니다.

원래 프로그램에서 새로운 모듈을 사용하려면, `require('fs')`로 `fs`를 불러왔을 때랑 마찬가지로 `require()` 호출을 사용하면 됩니다. 차이점이라면 지역 모듈은 앞에 './'를 붙여야만 하는 것뿐입니다. 즉, 파일 이름이 mymodule.js라면 이렇게 하시면 됩니다.

```js
const mymodule = require('./mymodule.js')
```

'.js'는 생략 가능하고 생략하는 것을 자주 보게 될 것입니다.

이제 모듈의 `module.exports` 객체를 `mymodule` 값에 할당했습니다. 단일 함수를 export했기 때문에, `mymodule`은 호출할 수 있는 함수가 되었습니다.

에러를 먼저 확인해 콜백 함수에서 빠르게 반환하는 관용적인 표현도 기억해두세요.

```js
function bar (callback) {
  foo(function (err, data) {
    if (err) { return callback(err) } // early return

    // ... no error, continue doing cool things with `data`

    // all went well, call callback with `null` for the error argument

    callback(null, data)
  })
}
```
