今回の問題は前回のものとよく似ていますが、今回は **modules** の概念を使いましょう。
問題の解決には2つのファイルが必要になります。

指定したディレクトリから、拡張子でフィルタしたファイルのリストを出力するプログラムを書いてください。
コマンドライン引数の1つ目はディレクトリ名、2つ目は拡張子です。
フィルタリングしたファイル名を1行ずつコンソールに出力してください。非同期 I/O を使ってください。

**module** ファイルに処理の大部分を書いてください。**module** には、3つの引数を取る関数を一つだけ定義してください。
その関数の引数は ディレクトリ名・ファイル拡張子・コールバック関数、という順序です。

コマンドライン引数から与えられるファイル拡張子は、そのままプログラム本体に渡してください。
正規表現に変換したり `"."` を付けたりしてはいけません。

コールバック関数は Node の習慣的なイディオムを使って呼び出してください： `(err, data)` 。
このイディオムでいうとエラーが発生しない場合、1つ目の引数 `err` は `null` で2つ目の引数にはファイルの Array が入っています。
もしエラーが発生した場合（`fs.readdir()` で問題があった場合）、そのエラーだけを1つ目の引数としてコールバック関数に渡してください。

コンソールへの出力は 本体のプログラムで行って下さい。
エラーの場合は、分かりやすいエラーメッセージを出力してください。

まとめ：作成する **module** には、以下の4つの制約があります。

1. 正しい引数を取る関数を定義してください。
2. エラー、もしくはデータを引数に取るコールバック関数を一度だけ呼び出してください。
3. 2つ目の制約以外には何も変えないでください（グローバル変数や標準出力など）。
4. 発生する可能性のあるエラーは全てコールバック関数に渡してください。

この制約の良いところは、あなたの作った **module** をこの制約を知っている全ての人が扱えるようになることです。

----------------------------------------------------------------------
## ヒント

フォルダの内容を読み取り、フィルタする Module を新しいファイルに書いてください。

**関数を1つだけ** 定義するためには、以下の例のように `module.exports` を利用します：

```js
module.exports = function (args) { /* ... */ }
```

あるいは、関数名を使って定義してもいいです。

```js
function hoge () {
  /* ... */
}

module.exports = hoge
```
`require('fs')` で `fs` をロードするのと同じように、`require()` を使ってあなたの Module を読み込んでください。
1つだけ大きな違いがあるとすれば、ローカルの Module を読み込むためには `'./'` を使ってください。
あなたの Module の名前が `mymodule.js` の場合、以下のように使ってください:

```js
const hogemodule = require('./mymodule.js')
```

（メモ： `'.js'` の拡張子は必ずしも必要ではありません。他のコードでは、それをよく省略しています。）
上記コードによって Module に書いてある `module.exports` の Object にアクセスできます。その Object は、 `hogemodule` 変数に格納されます。

`mymodule.js` には1つの関数だけ定義されているので、 `hogemodule` 変数が実行可能な関数となります！

**例**： `hogemodule();`

イディオムのエラーチェックと `return` を忘れないでください：

```js
function bar (callback) {
  foo(function (err, data) {
    if (err) { return callback(err) } // 早期 `return` が大事。

    // ... エラーのない場合、そのまま `data`を使って楽しんでください。

    // 十分楽しんだら、エラー引数に `null` を入れてください。
    callback(null, data)
  })
}
```
