Реалізуйте HTTP **сервер**, котрий повертає JSON-дані у відповідь на GET-запит за адресою '/api/parsetime'. Запит має містити в рядку запиту ключ 'iso' та час в ISO-форматі в якості значення.

Наприклад:

  /api/parsetime?iso=2013-08-10T12:10:15.474Z

JSON-об’єкт у відповіді має містити тільки властивості 'hour', 'minute' та 'second'. Приклад відповіді:

```json
{
  "hour": 14,
  "minute": 23,
  "second": 15
}
```

Також сервер має опрацьовувати запит на '/api/unixtime', котрий містить такий же рядок запиту, але повертає час у форматі UNIX в мілісекундах (кількість мілісекунд, які минули від 1 січня 1970 00:00:00 UTC) у властивості 'unixtime'. Наприклад:

```json
{ "unixtime": 1376136615474 }
```

Ваш сервер має слухати порт, котрий Ви отримаєте у якості першого аргументу командного рядка.

----------------------------------------------------------------------
## ІНФОРМАЦІЯ

Об’єкт `request` в HTTP-сервері має властивість `url`, для того, щоб *"спрямовувати (route)"* ваші запити до потрібних обробників.

Ви можете парсити URL та рядок запиту, скориставшись вбудованим Node-модулем 'url'. `new URL(request.url)` пропарсить request.url та поверне нам об’єкт з необхідними властивостями.

Наприклад, введіть в командному рядку:

```sh
$ node -pe "new URL('/test?q=1', 'http://example.com')"
```

Документація до модуля `url` Ви можете знайти, перейшовши у браузері сюди:
  {rootdir:/docs-nodejs/url.html}

Ваша відповідь має бути у форматі JSON-рядка. Зверніться до `JSON.stringify()` для додаткової інформації.

Також Вам слід бути порядним мешканцем вебу та ставити Content-Type правильно:

```js
res.writeHead(200, { 'Content-Type': 'application/json' })
```

Об’єкт `Date` в JavaScript може повертати час в форматі ISO, наприклад `new Date().toISOString()`. Також він може парсити цей формат, якщо отримає рядок з часом в конструктор `Date`. `Date#getTime()` також може стати в нагоді.
