Реалізуйте HTTP **сервер**, котрий віддає однаковий файл для всіх вхідних запитів.

Сервер має слухати порт, котрий буде передаватись в якості першого аргументу командного рядка.

Вам слід надати можливість вказувати розташування файлу, який буде надсилатись, у якості другого аргументу командного рядка. Ви **повинні** скористатись методом `fs.createReadStream()` для передавання вмісту файлу у відповідь.

----------------------------------------------------------------------
## ІНФОРМАЦІЯ

Оскільки нам потрібно створити HTTP-сервер для цієї задачі, замість низькорівневого TCP-сервера, нам слід використовувати вбудований модуль `http`. Так само як і модуль`net`, `http` також має метод `http.createServer()`, але в цьому випадку він створює сервер, котрий може спілкуватись по HTTP.

`http.createServer()` приймає функцію зворотнього виклику, котра буде викликатись для кожного з’єднання до серверу. Вона має таку сигнатуру:

```js
function callback (request, response) { /* ... */ }
```

Тут два аргументи є об’єктами, що представляють HTTP-запит (request) та відповідну відповідь на цей запит (response). `request` використовує для отримання таких властивостей як заголовок або рядок запиту, у той час як `response` потрібен для надсилання данних клієнту, як заголовків, так і тіла відповіді.

Обидва `request` та `response` також є потоками Node! Це означає, що Ви можете як посилати, так і приймати потоки данних, якщо це підходить для вашого випадку.

`http.createServer()` повертає екземпляр Вашого серверу. Вам потрібно викликати `server.listen(portNumber)` для того, аби стартувати сервер на вказаному порті.

Типовий Node HTTP-сервер виглядає так:

```js
const http = require('http')
const server = http.createServer(function (req, res) {
  // обробка запитів...
})
server.listen(8000)
```

Документацію до модуля `http` Ви можете знайти, набравши в браузері:
  {rootdir:/docs-nodejs/http.html}

Вбудований модуль `fs` також має потоковий АРІ для файлів. Ви можете використовувати метод `fs.createReadStream()` для створення потоку, що представлятиме файл, котрий Ви отримаєте у якості аргументу командного рядка. Цей метод повертає потоковий об’єкт (stream), який Ви можете використовувати як `src.pipe(dst)`, аби направляти данні з потоку `src` в потік `dst`. В нашому випадку Ви можете зв’язати потік файлової системи з потоком відповіді HTTP.
