Реализуйте HTTP сервер, который отдает одинаковый файл для всех входящих запросов.

Сервер должен слушать порт, который будет передан в качестве первого аргумента командной строки.

Файл, который нужно возвращать, будет передан в качестве второго аргумента командной строки. Вы **должны** использовать `fs.createReadStream()` метод для отдачи содержимого файла.

----------------------------------------------------------------------
## ИНФОРМАЦИЯ

В связи с тем, что в этом задании нам нужно создать HTTP сервер, а не низкоуровневый TCP сервер, мы должны использовать встроенный `http` модуль Node. Так же как и `net` модуль, `http` имеет метод `http.createServer()`, но в этом случае он создает сервер, который может общаться по HTTP.

`http.createServer()` принимает функцию, которая будет вызвана один раз для каждого соединения к серверу. Она имеет следующую сигнатуру:

```js
function callback (request, response) { /* ... */ }
```

где два аргумента это объекты, представляющие HTTP запрос и соответствующий ответ на этот запрос. `request` используется для получения таких свойств запроса, как заголовок или строка-зпроса, в то время, как `response` нужен для отправки данных клиенту, как заголовков, так и тела ответа.

Оба `request` и `response` являются потоками Node! Это значит что Вы может как посылать, так и принимать потоки данных, если это подходит для Вашего случая.

`http.createServer` возвращает экземпляр Вашего сервера. Вы должны вызвать `server.listen(portNumber)` для того чтобы стартовать сервер на заданом порту.

Типичный Node HTTP сервер выглядит так:

```js
const http = require('http')
const server = http.createServer(function (req, res) {
  // обработка запросов
})
server.listen(8000)
```

Документацию для `http` модуля Вы сможете найти набрав в браузере:
  {rootdir:/docs-nodejs/http.html}

Встроенный модуль `fs` также имеет потоквые API для файлов. Вы должны использовать метод `fs.createReadStream()` для создания потока представляющий файл, который Вы получите в качестве аргумента командной строки. Этот метод возвращает потоковый объект (stream), который Вы можете использовать как `src.pipe(dst)`, для того чтобы направить данные из потока `src` в поток `dst`. В нашем случае Вы можете связать поток файловой системы с потоком ответа HTTP.
