Реалізуйте програму, котра надсилає HTTP GET запит на URL, який Ви отримаєте в якості першого аргументу командного рядка. Зберіть **всі** данні від серверу (не лише першу подію "data") та виведіть два рядки в консоль (stdout).

Перший рядок повинен містити кількість символів, отриманих від сервера. А другий має безпосередньо вивести весь рядок, надісланий сервером.

----------------------------------------------------------------------
## ІНФОРМАЦІЯ

Є два шляхи вирішення цієї проблеми:

**1)** Зібрати данні зі всіх подій "data" та накопичувати їх для виведення у консоль. Використовуйте подію "end", щоб зрозуміти коли потік закінчився, аби вивести результат.

**2)** Використати додаткові бібліотеки, щоб абстрагуватися від складності збирання потокових данних. Дві різних бібліотеки надають корисний АРІ для вирішення цієї проблеми (насправді їх більше!): `bl` (Buffer List) та `concat-stream`; вибір за вами!

  <https://npmjs.com/bl>
  <https://npmjs.com/concat-stream>

Для встановлення додаткову Node-бібліотеку (пакет), скористайтеся пакетним менеджером Node - `npm`. Просто наберіть:

```sh
$ npm install bl
```

Таким чином Ви завантажите та встановите останню версію пакету в підкаталог `node_modules`. Будь-який пакет, встановлений в цей каталог, може бути завантажений у Вашу програму з допомогою `require`  без необхідності додавання префіксу './':

```js
const bl = require('bl')
```

Спершу Node шукатиме бібліотеку у вбудованих модулях, а потім у каталозі `node_modules`, де він і буде знаходитись.

Якщо у Вас відсутнє з’єднання з інтернетом, просто створіть директорію `node_modules` та скопіюйте туди директорію з бібліотекою, яку Ви хочете використовувати з {appname}:

  {rootdir:/node_modules/bl}
  {rootdir:/node_modules/concat-stream}

Обидві бібліотеки `bl` та `concat-stream` можуть *приймати (piped)* та збирати з них данні для Вас. Коли потік буде закінчений, буде викликана функція зворотнього виклику.

```js
response.pipe(bl(function (err, data) { /* ... */ }))
// or
response.pipe(concatStream(function (data) { /* ... */ }))
```

Зауважте, що можливо Вам доведеться використовувати `data.toString()` для конвертації данних з Buffer.

Документації для обох цих модулів встановлюються разом з {appname} у вашій системі, тож Ви можете читати їх, перейшовши у браузері сюди:

  {rootdir:/docs/bl.html}
  {rootdir:/docs/concat-stream.html}
