1つ目の引数として指定された URL に、 HTTP で GET を送信する (※)アプリを書いてください。

そのリクエストに対するレスポンスを`"data"`イベントで受け取り、受け取った全ての文字列を**1つずつ**改行で区切ってコンソールに書き出してください。

※ これからは「GET リクエスト」と記述します。

----------------------------------------------------------------------
## ヒント

この例題のためには `http` の Node.js モジュールが必要です。

`http` モジュールのドキュメントは、このリンクをブラウザで見てください:

  {rootdir:/docs-nodejs/http.html}

`http.get()` という関数は簡単に GET リクエストを送信するショートカットです。解決方法をシンプルするのに役に立つと思います。
`http.get()` の1つ目の引数は、GET リクエストの URL です。2つ目はコールバック関数です。

```js
http.get(url, callback)
```

`http` はよくあるイディオム  `(error, result)` と違って以下のようなコールバック関数となっています：

```js
function callback (response) { /* ... */ }
```

`response` のオブジェクトは Node.js の **Stream** です。Stream はイベントを発行するオブジェクトと考えてよいです。
Stream における大切な3つのイベントは： `data` 、 `error` と `end` です。
各イベント時にデータを受け取る為には、次のようにリスナを設定します。

```js
response.on('data', function (data) { /* ... */ })
```

`data` イベントは処理できるデータチャンク(※)が現れたときに発行されます。チャンクのサイズはデータによって変わります。
※ データの一部分。Stream ではこれが断続的に提供されます。

`http.get()` の `response` の Stream オブジェクトには `setEncoding()` という関数があります。
それを `utf8` という値を使って呼ぶとデータイベントの `Buffer` の代わりに文字列が渡ってきます。
