1つ以上の整数をコマンドライン引数として受け取り、それらを足し合わせた値をコンソール(stdout)に出力するコマンドラインアプリを書いてください。

----------------------------------------------------------------------
## ヒント

コマンドライン引数を読むためにはグローバル変数の `process` というオブジェクトが使えます。
`process` には `argv` という `配列` のプロパティがあります。その `配列` の中には全てのコマンドライン引数が入っています。

例： `process.argv`

新しいアプリ `(program.js)` にこれを書いてスタートしてください：

```js
console.log(process.argv)
```

コマンドラインに `node program.js` を入力してアプリを実行します。コマンドライン引数も使えます！
例:

```sh
$ node program.js 1 2 3
```

実行すると以下のように出力されるはずです:

```js
['node', '/あなた/の/アプリ/フォルダ/program.js', '1', '2', '3']
```

次のステップでは数値だけを合計して表示する方法を考えます。

`argv` の1つ目の引数はいつでも `node` です。2つ目の引数はあなたのアプリファイルのパスです。
そのためコマンドライン引数は3つ目の引数からスタートします。それぞれの要素を最後の要素まで合計してください。

`process.argv` の要素は全て string ですので注意してください。
もしかしたら数字への変換が必要になるかもしれません。変換するには、数字の前に `+` を書きます。`Number()`を使う方法もあります。

例: `+process.argv[2]` または `Number(process.argv[2])` 。

`{appname} verify program.js` で、アプリが正しく動くかどうか確かめられます。{appname} はあなたのアプリの実行時に引数を渡します。

単純にアプリを実行する方法もあります： `{appname} run program.js`。 `run` を使うと各ステップのためのテスト設定を呼び出して実行することが出来ます。
