"""empty message

Revision ID: 07f1783a51d8
Revises: 
Create Date: 2018-07-09 20:26:40.869809

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '07f1783a51d8'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('pined_msg',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('home_msg', sa.String(length=4000), nullable=True),
    sa.Column('home_enable', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_pined_msg_home_enable'), 'pined_msg', ['home_enable'], unique=False)
    op.create_table('tag',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=20), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_tag_name'), 'tag', ['name'], unique=True)
    op.create_table('user',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('username', sa.String(length=64), nullable=True),
    sa.Column('email', sa.String(length=120), nullable=True),
    sa.Column('password_hash', sa.String(length=128), nullable=True),
    sa.Column('last_seen', sa.DateTime(), nullable=True),
    sa.Column('is_administrator', sa.Boolean(), nullable=True),
    sa.Column('about_me', sa.String(length=280), nullable=True),
    sa.Column('screen_name', sa.String(length=64), nullable=True),
    sa.Column('website', sa.String(length=280), nullable=True),
    sa.Column('github', sa.String(length=280), nullable=True),
    sa.Column('twitter', sa.String(length=280), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_user_email'), 'user', ['email'], unique=True)
    op.create_index(op.f('ix_user_github'), 'user', ['github'], unique=False)
    op.create_index(op.f('ix_user_is_administrator'), 'user', ['is_administrator'], unique=False)
    op.create_index(op.f('ix_user_screen_name'), 'user', ['screen_name'], unique=False)
    op.create_index(op.f('ix_user_twitter'), 'user', ['twitter'], unique=False)
    op.create_index(op.f('ix_user_username'), 'user', ['username'], unique=True)
    op.create_index(op.f('ix_user_website'), 'user', ['website'], unique=False)
    op.create_table('post',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=280), nullable=True),
    sa.Column('url', sa.String(length=280), nullable=True),
    sa.Column('markdown_url', sa.String(length=280), nullable=True),
    sa.Column('timestamp', sa.DateTime(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('img_url', sa.String(length=280), nullable=True),
    sa.Column('summary', sa.String(length=1000), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_post_markdown_url'), 'post', ['markdown_url'], unique=True)
    op.create_index(op.f('ix_post_timestamp'), 'post', ['timestamp'], unique=False)
    op.create_index(op.f('ix_post_title'), 'post', ['title'], unique=True)
    op.create_index(op.f('ix_post_url'), 'post', ['url'], unique=True)
    op.create_table('post_tag',
    sa.Column('post_id', sa.Integer(), nullable=True),
    sa.Column('tag_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['post_id'], ['post.id'], ),
    sa.ForeignKeyConstraint(['tag_id'], ['tag.id'], )
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('post_tag')
    op.drop_index(op.f('ix_post_url'), table_name='post')
    op.drop_index(op.f('ix_post_title'), table_name='post')
    op.drop_index(op.f('ix_post_timestamp'), table_name='post')
    op.drop_index(op.f('ix_post_markdown_url'), table_name='post')
    op.drop_table('post')
    op.drop_index(op.f('ix_user_website'), table_name='user')
    op.drop_index(op.f('ix_user_username'), table_name='user')
    op.drop_index(op.f('ix_user_twitter'), table_name='user')
    op.drop_index(op.f('ix_user_screen_name'), table_name='user')
    op.drop_index(op.f('ix_user_is_administrator'), table_name='user')
    op.drop_index(op.f('ix_user_github'), table_name='user')
    op.drop_index(op.f('ix_user_email'), table_name='user')
    op.drop_table('user')
    op.drop_index(op.f('ix_tag_name'), table_name='tag')
    op.drop_table('tag')
    op.drop_index(op.f('ix_pined_msg_home_enable'), table_name='pined_msg')
    op.drop_table('pined_msg')
    # ### end Alembic commands ###
