/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.messagecontentbuilder;

import cn.wildfirechat.messagecontentbuilder.MessageContentBuilder;
import cn.wildfirechat.pojos.MessagePayload;

public class StreamingTextMessageContentBuilder
extends MessageContentBuilder {
    private String text;
    private String streamId;
    private boolean generating;

    public static StreamingTextMessageContentBuilder newBuilder(String streamId) {
        StreamingTextMessageContentBuilder builder = new StreamingTextMessageContentBuilder();
        builder.generating = false;
        builder.streamId = streamId;
        return builder;
    }

    public StreamingTextMessageContentBuilder text(String text) {
        this.text = text;
        return this;
    }

    public StreamingTextMessageContentBuilder generating(boolean generating) {
        this.generating = generating;
        return this;
    }

    @Override
    public MessagePayload build() {
        MessagePayload payload = this.encodeBase();
        payload.setSearchableContent(this.text);
        payload.setContent(this.streamId);
        if (this.generating) {
            payload.setType(14);
            payload.setPersistFlag(4);
        } else {
            payload.setType(15);
            payload.setPersistFlag(3);
        }
        return payload;
    }
}

