/*
 * Decompiled with CFR 0.152.
 */
package ikidou.reflect;

import ikidou.reflect.exception.TypeException;
import ikidou.reflect.typeimpl.ParameterizedTypeImpl;
import ikidou.reflect.typeimpl.WildcardTypeImpl;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class TypeBuilder {
    private final TypeBuilder parent;
    private final Class raw;
    private final List<Type> args = new ArrayList<Type>();

    private TypeBuilder(Class raw, TypeBuilder parent) {
        assert (raw != null);
        this.raw = raw;
        this.parent = parent;
    }

    public static TypeBuilder newInstance(Class raw) {
        return new TypeBuilder(raw, null);
    }

    private static TypeBuilder newInstance(Class raw, TypeBuilder parent) {
        return new TypeBuilder(raw, parent);
    }

    public TypeBuilder beginSubType(Class raw) {
        return TypeBuilder.newInstance(raw, this);
    }

    public TypeBuilder endSubType() {
        if (this.parent == null) {
            throw new TypeException("expect beginSubType() before endSubType()");
        }
        this.parent.addTypeParam(this.getType());
        return this.parent;
    }

    public TypeBuilder addTypeParam(Class clazz) {
        return this.addTypeParam((Type)clazz);
    }

    public TypeBuilder addTypeParamExtends(Class ... classes) {
        if (classes == null) {
            throw new NullPointerException("addTypeParamExtends() expect not null Class");
        }
        WildcardTypeImpl wildcardType = new WildcardTypeImpl(null, classes);
        return this.addTypeParam(wildcardType);
    }

    public TypeBuilder addTypeParamSuper(Class ... classes) {
        if (classes == null) {
            throw new NullPointerException("addTypeParamSuper() expect not null Class");
        }
        WildcardTypeImpl wildcardType = new WildcardTypeImpl(classes, null);
        return this.addTypeParam(wildcardType);
    }

    public TypeBuilder addTypeParam(Type type) {
        if (type == null) {
            throw new NullPointerException("addTypeParam expect not null Type");
        }
        this.args.add(type);
        return this;
    }

    public Type build() {
        if (this.parent != null) {
            throw new TypeException("expect endSubType() before build()");
        }
        return this.getType();
    }

    private Type getType() {
        if (this.args.isEmpty()) {
            return this.raw;
        }
        return new ParameterizedTypeImpl(this.raw, this.args.toArray(new Type[this.args.size()]), null);
    }
}

