/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.utilities;

import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.util.internal.StringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotHttpUtils
extends JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RobotHttpUtils.class);
    public static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final String url;
    private final String robotId;
    private final String robotSecret;
    private final CloseableHttpClient httpClient;

    public RobotHttpUtils(String url, String robotId, String robotSecret) {
        this.url = url;
        this.robotId = robotId;
        this.robotSecret = robotSecret;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setValidateAfterInactivity(1000);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).evictExpiredConnections().evictIdleConnections(60L, TimeUnit.SECONDS).setRetryHandler((HttpRequestRetryHandler)DefaultHttpRequestRetryHandler.INSTANCE).setMaxConnTotal(100).setMaxConnPerRoute(50).build();
    }

    public <T> IMResult<T> httpJsonPost(String path, Object object, Class<T> clazz) throws Exception {
        if (RobotHttpUtils.isNullOrEmpty(this.url) || RobotHttpUtils.isNullOrEmpty(path)) {
            LOG.error("Not init IM SDK correctly. Do you forget init it?");
            throw new Exception("SDK url or secret lack!");
        }
        String url = this.url + path;
        HttpPost post = null;
        try {
            String line;
            CloseableHttpResponse response;
            int statusCode;
            int nonce = (int)(Math.random() * 100000.0 + 3.0);
            long timestamp = System.currentTimeMillis();
            String str = nonce + "|" + this.robotSecret + "|" + timestamp;
            String sign = DigestUtils.sha1Hex((String)str);
            post = new HttpPost(url);
            post.setHeader("Content-type", "application/json; charset=utf-8");
            post.setHeader("Connection", "Keep-Alive");
            post.setHeader("nonce", nonce + "");
            post.setHeader("timestamp", "" + timestamp);
            post.setHeader("rid", this.robotId);
            post.setHeader("sign", sign);
            String jsonStr = null;
            if (object != null) {
                jsonStr = gson.toJson(object);
            }
            LOG.info("http request:{} content: {}", (Object)url, (Object)jsonStr);
            if (!StringUtil.isNullOrEmpty((String)jsonStr)) {
                StringEntity entity = new StringEntity(jsonStr, Charset.forName("UTF-8"));
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                post.setEntity((HttpEntity)entity);
            }
            if ((statusCode = (response = this.httpClient.execute((HttpUriRequest)post)).getStatusLine().getStatusCode()) != 200) {
                LOG.info("Request error: " + statusCode);
                throw new Exception("Http request error with code:" + statusCode);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            String content = sb.toString();
            LOG.info("http request response content: {}", (Object)content);
            IMResult<T> iMResult = RobotHttpUtils.fromJsonObject(content, clazz);
            return iMResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public String getRobotId() {
        return this.robotId;
    }

    public String getRobotSecret() {
        return this.robotSecret;
    }
}

