/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.GetOnlineUserCountResult;
import cn.wildfirechat.pojos.GetOnlineUserRequest;
import cn.wildfirechat.pojos.GetOnlineUserResult;
import cn.wildfirechat.pojos.GetUserSessionResult;
import cn.wildfirechat.pojos.InputApplicationGetUserInfo;
import cn.wildfirechat.pojos.InputCreateDevice;
import cn.wildfirechat.pojos.InputCreateRobot;
import cn.wildfirechat.pojos.InputDestroyUser;
import cn.wildfirechat.pojos.InputDeviceId;
import cn.wildfirechat.pojos.InputGetToken;
import cn.wildfirechat.pojos.InputGetUserInfo;
import cn.wildfirechat.pojos.InputGetUserList;
import cn.wildfirechat.pojos.InputOutputUserBlockStatus;
import cn.wildfirechat.pojos.InputOutputUserInfo;
import cn.wildfirechat.pojos.InputRobotId;
import cn.wildfirechat.pojos.InputUpdateUserInfo;
import cn.wildfirechat.pojos.InputUserId;
import cn.wildfirechat.pojos.OutputApplicationUserInfo;
import cn.wildfirechat.pojos.OutputCheckUserOnline;
import cn.wildfirechat.pojos.OutputCreateDevice;
import cn.wildfirechat.pojos.OutputCreateRobot;
import cn.wildfirechat.pojos.OutputCreateUser;
import cn.wildfirechat.pojos.OutputDevice;
import cn.wildfirechat.pojos.OutputDeviceList;
import cn.wildfirechat.pojos.OutputGetIMTokenData;
import cn.wildfirechat.pojos.OutputGetUserList;
import cn.wildfirechat.pojos.OutputRobot;
import cn.wildfirechat.pojos.OutputUserBlockStatusList;
import cn.wildfirechat.pojos.OutputUserStatus;
import cn.wildfirechat.pojos.StringPairPojo;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.AdminHttpUtils;

public class UserAdmin {
    public static IMResult<InputOutputUserInfo> getUserByName(String name) throws Exception {
        String path = "/admin/user/get_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(null, name, null);
        return AdminHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public static IMResult<InputOutputUserInfo> getUserByUserId(String userId) throws Exception {
        String path = "/admin/user/get_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(userId, null, null);
        return AdminHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public static IMResult<InputOutputUserInfo> getUserByMobile(String mobile) throws Exception {
        String path = "/admin/user/get_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(null, null, mobile);
        return AdminHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public static IMResult<OutputGetUserList> getAllUsers(int count, int offset) throws Exception {
        String path = "/admin/user/all";
        InputGetUserList input = new InputGetUserList();
        input.count = count;
        input.offset = offset;
        return AdminHttpUtils.httpJsonPost(path, input, OutputGetUserList.class);
    }

    public static IMResult<OutputCreateUser> createUser(InputOutputUserInfo user) throws Exception {
        String path = "/admin/user/create";
        return AdminHttpUtils.httpJsonPost(path, user, OutputCreateUser.class);
    }

    public static IMResult<Void> updateUserInfo(InputOutputUserInfo user, int flag) throws Exception {
        String path = "/admin/user/update";
        InputUpdateUserInfo updateUserInfo = new InputUpdateUserInfo();
        updateUserInfo.flag = flag;
        updateUserInfo.userInfo = user;
        return AdminHttpUtils.httpJsonPost(path, updateUserInfo, Void.class);
    }

    public static IMResult<OutputCreateRobot> createRobot(InputCreateRobot robot) throws Exception {
        String path = "/admin/robot/create";
        return AdminHttpUtils.httpJsonPost(path, robot, OutputCreateRobot.class);
    }

    public static IMResult<Void> destroyRobot(String userId) throws Exception {
        String path = "/admin/user/destroy";
        InputDestroyUser inputDestroyUser = new InputDestroyUser();
        inputDestroyUser.setUserId(userId);
        return AdminHttpUtils.httpJsonPost(path, inputDestroyUser, Void.class);
    }

    public static IMResult<OutputRobot> getRobotInfo(String robotId) throws Exception {
        String path = "/admin/user/get_robot_info";
        InputRobotId getRobotInfo = new InputRobotId();
        getRobotInfo.setRobotId(robotId);
        return AdminHttpUtils.httpJsonPost(path, getRobotInfo, OutputRobot.class);
    }

    public static IMResult<OutputGetIMTokenData> getUserToken(String userId, String clientId, int platform) throws Exception {
        String path = "/admin/user/get_token";
        InputGetToken getToken = new InputGetToken(userId, clientId, platform);
        return AdminHttpUtils.httpJsonPost(path, getToken, OutputGetIMTokenData.class);
    }

    public static IMResult<Void> updateUserBlockStatus(String userId, int block) throws Exception {
        String path = "/admin/user/update_block_status";
        InputOutputUserBlockStatus blockStatus = new InputOutputUserBlockStatus(userId, block);
        return AdminHttpUtils.httpJsonPost(path, blockStatus, Void.class);
    }

    public static IMResult<OutputUserStatus> checkUserBlockStatus(String userId) throws Exception {
        String path = "/admin/user/check_block_status";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(userId, null, null);
        return AdminHttpUtils.httpJsonPost(path, getUserInfo, OutputUserStatus.class);
    }

    public static IMResult<OutputUserBlockStatusList> getBlockedList() throws Exception {
        String path = "/admin/user/get_blocked_list";
        return AdminHttpUtils.httpJsonPost(path, null, OutputUserBlockStatusList.class);
    }

    public static IMResult<OutputCheckUserOnline> checkUserOnlineStatus(String userId) throws Exception {
        String path = "/admin/user/onlinestatus";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(userId, null, null);
        return AdminHttpUtils.httpJsonPost(path, getUserInfo, OutputCheckUserOnline.class);
    }

    public static IMResult<Void> kickoffUserClient(String userId, String clientId) throws Exception {
        String path = "/admin/user/kickoff_client";
        StringPairPojo pojo = new StringPairPojo(userId, clientId);
        return AdminHttpUtils.httpJsonPost(path, pojo, Void.class);
    }

    public static IMResult<Void> destroyUser(String userId) throws Exception {
        String path = "/admin/user/destroy";
        InputDestroyUser inputDestroyUser = new InputDestroyUser();
        inputDestroyUser.setUserId(userId);
        return AdminHttpUtils.httpJsonPost(path, inputDestroyUser, Void.class);
    }

    public static IMResult<OutputCreateDevice> createOrUpdateDevice(InputCreateDevice device) throws Exception {
        String path = "/admin/device/create";
        return AdminHttpUtils.httpJsonPost(path, device, OutputCreateDevice.class);
    }

    public static IMResult<OutputDevice> getDevice(String deviceId) throws Exception {
        String path = "/admin/device/get";
        InputDeviceId inputDeviceId = new InputDeviceId();
        inputDeviceId.setDeviceId(deviceId);
        return AdminHttpUtils.httpJsonPost(path, inputDeviceId, OutputDevice.class);
    }

    public static IMResult<OutputDeviceList> getUserDevices(String userId) throws Exception {
        String path = "/admin/device/user_devices";
        InputUserId inputUserId = new InputUserId();
        inputUserId.setUserId(userId);
        return AdminHttpUtils.httpJsonPost(path, inputUserId, OutputDeviceList.class);
    }

    public static IMResult<GetOnlineUserCountResult> getOnlineUserCount() throws Exception {
        return AdminHttpUtils.httpJsonPost("/admin/user/online_count", null, GetOnlineUserCountResult.class);
    }

    public static IMResult<GetOnlineUserResult> getOnlineUser(int nodeId, int offset, int count) throws Exception {
        GetOnlineUserRequest request = new GetOnlineUserRequest();
        request.nodeId = nodeId;
        request.offset = offset;
        request.count = count;
        return AdminHttpUtils.httpJsonPost("/admin/user/online_list", request, GetOnlineUserResult.class);
    }

    public static IMResult<OutputApplicationUserInfo> applicationGetUserInfo(String authCode) throws Exception {
        String path = "/admin/user/app_get_user_info";
        InputApplicationGetUserInfo input = new InputApplicationGetUserInfo();
        input.setAuthCode(authCode);
        return AdminHttpUtils.httpJsonPost(path, input, OutputApplicationUserInfo.class);
    }

    public static IMResult<GetUserSessionResult> getUserSession(String userId) throws Exception {
        InputUserId inputUserId = new InputUserId(userId);
        return AdminHttpUtils.httpJsonPost("/admin/user/session_list", inputUserId, GetUserSessionResult.class);
    }
}

