/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.Conversation;
import cn.wildfirechat.pojos.InputAddGroupMember;
import cn.wildfirechat.pojos.InputApplicationGetUserInfo;
import cn.wildfirechat.pojos.InputConferenceRequest;
import cn.wildfirechat.pojos.InputCreateGroup;
import cn.wildfirechat.pojos.InputDismissGroup;
import cn.wildfirechat.pojos.InputGetGroup;
import cn.wildfirechat.pojos.InputGetGroupMember;
import cn.wildfirechat.pojos.InputGetUserInfo;
import cn.wildfirechat.pojos.InputKickoffGroupMember;
import cn.wildfirechat.pojos.InputModifyGroupInfo;
import cn.wildfirechat.pojos.InputMuteGroupMember;
import cn.wildfirechat.pojos.InputOutputUserInfo;
import cn.wildfirechat.pojos.InputQuitGroup;
import cn.wildfirechat.pojos.InputSetGroupManager;
import cn.wildfirechat.pojos.InputSetGroupMemberAlias;
import cn.wildfirechat.pojos.InputSetGroupMemberExtra;
import cn.wildfirechat.pojos.InputTransferGroup;
import cn.wildfirechat.pojos.IntStringPairPojo;
import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.pojos.OutputApplicationConfigData;
import cn.wildfirechat.pojos.OutputApplicationUserInfo;
import cn.wildfirechat.pojos.OutputCreateGroupResult;
import cn.wildfirechat.pojos.OutputGroupMemberList;
import cn.wildfirechat.pojos.OutputRobot;
import cn.wildfirechat.pojos.PojoGroup;
import cn.wildfirechat.pojos.PojoGroupInfo;
import cn.wildfirechat.pojos.PojoGroupMember;
import cn.wildfirechat.pojos.RecallMessageData;
import cn.wildfirechat.pojos.RobotCallbackPojo;
import cn.wildfirechat.pojos.SendMessageData;
import cn.wildfirechat.pojos.SendMessageResult;
import cn.wildfirechat.pojos.UpdateMessageContentData;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.RobotHttpUtils;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class RobotService {
    private final RobotHttpUtils robotHttpUtils;

    public RobotService(String url, String robotId, String robotSecret) {
        this.robotHttpUtils = new RobotHttpUtils(url, robotId, robotSecret);
    }

    public String getRobotId() {
        return this.robotHttpUtils.getRobotId();
    }

    public IMResult<SendMessageResult> sendMessage(String sender, Conversation conversation, MessagePayload payload) throws Exception {
        String path = "/robot/message/send";
        SendMessageData messageData = new SendMessageData();
        messageData.setSender(sender);
        messageData.setConv(conversation);
        messageData.setPayload(payload);
        return this.robotHttpUtils.httpJsonPost(path, messageData, SendMessageResult.class);
    }

    public IMResult<String> recallMessage(long messageUid) throws Exception {
        String path = "/robot/message/recall";
        RecallMessageData messageData = new RecallMessageData();
        messageData.setMessageUid(messageUid);
        return this.robotHttpUtils.httpJsonPost(path, messageData, String.class);
    }

    public IMResult<Void> updateMessage(long messageUid, MessagePayload payload) throws Exception {
        String path = "/robot/message/update";
        UpdateMessageContentData updateMessageContentData = new UpdateMessageContentData();
        updateMessageContentData.setMessageUid(messageUid);
        updateMessageContentData.setPayload(payload);
        updateMessageContentData.setUpdateTimestamp(0);
        updateMessageContentData.setDistribute(1);
        return this.robotHttpUtils.httpJsonPost(path, updateMessageContentData, Void.class);
    }

    public IMResult<InputOutputUserInfo> getUserInfo(String userId) throws Exception {
        String path = "/robot/user_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(userId, null, null);
        return this.robotHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public IMResult<InputOutputUserInfo> getUserInfoByMobile(String phone) throws Exception {
        String path = "/robot/user_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(null, null, phone);
        return this.robotHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public IMResult<InputOutputUserInfo> getUserInfoByName(String userName) throws Exception {
        String path = "/robot/user_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(null, userName, null);
        return this.robotHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public IMResult<Void> setCallback(String url) throws Exception {
        String path = "/robot/set_callback";
        RobotCallbackPojo pojo = new RobotCallbackPojo();
        pojo.setUrl(url);
        return this.robotHttpUtils.httpJsonPost(path, pojo, Void.class);
    }

    public IMResult<RobotCallbackPojo> getCallback() throws Exception {
        String path = "/robot/get_callback";
        return this.robotHttpUtils.httpJsonPost(path, null, RobotCallbackPojo.class);
    }

    public IMResult<Void> deleteCallback() throws Exception {
        String path = "/robot/delete_callback";
        return this.robotHttpUtils.httpJsonPost(path, null, Void.class);
    }

    public IMResult<OutputRobot> getProfile() throws Exception {
        String path = "/robot/profile";
        return this.robotHttpUtils.httpJsonPost(path, null, OutputRobot.class);
    }

    public IMResult<Void> updateProfile(int type, String value) throws Exception {
        String path = "/robot/update_profile";
        IntStringPairPojo pojo = new IntStringPairPojo(type, value);
        return this.robotHttpUtils.httpJsonPost(path, pojo, Void.class);
    }

    public IMResult<OutputCreateGroupResult> createGroup(PojoGroupInfo group_info, List<PojoGroupMember> members, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/create";
        PojoGroup pojoGroup = new PojoGroup();
        pojoGroup.setGroup_info(group_info);
        pojoGroup.setMembers(members);
        InputCreateGroup createGroup = new InputCreateGroup();
        createGroup.setGroup(pojoGroup);
        createGroup.setTo_lines(to_lines);
        createGroup.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, createGroup, OutputCreateGroupResult.class);
    }

    public IMResult<PojoGroupInfo> getGroupInfo(String groupId) throws Exception {
        String path = "/robot/group/get_info";
        InputGetGroup input = new InputGetGroup();
        input.setGroupId(groupId);
        return this.robotHttpUtils.httpJsonPost(path, input, PojoGroupInfo.class);
    }

    public IMResult<Void> dismissGroup(String groupId, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/del";
        InputDismissGroup dismissGroup = new InputDismissGroup();
        dismissGroup.setGroup_id(groupId);
        dismissGroup.setTo_lines(to_lines);
        dismissGroup.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, dismissGroup, Void.class);
    }

    public IMResult<Void> transferGroup(String groupId, String newOwner, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/transfer";
        InputTransferGroup transferGroup = new InputTransferGroup();
        transferGroup.setGroup_id(groupId);
        transferGroup.setNew_owner(newOwner);
        transferGroup.setTo_lines(to_lines);
        transferGroup.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, transferGroup, Void.class);
    }

    public IMResult<Void> modifyGroupInfo(String groupId, int type, String value, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/modify";
        InputModifyGroupInfo modifyGroupInfo = new InputModifyGroupInfo();
        modifyGroupInfo.setGroup_id(groupId);
        modifyGroupInfo.setTo_lines(to_lines);
        modifyGroupInfo.setType(type);
        modifyGroupInfo.setValue(value);
        modifyGroupInfo.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, modifyGroupInfo, Void.class);
    }

    public IMResult<OutputGroupMemberList> getGroupMembers(String groupId) throws Exception {
        String path = "/robot/group/member/list";
        InputGetGroup input = new InputGetGroup();
        input.setGroupId(groupId);
        return this.robotHttpUtils.httpJsonPost(path, input, OutputGroupMemberList.class);
    }

    public IMResult<PojoGroupMember> getGroupMember(String groupId, String memberId) throws Exception {
        String path = "/robot/group/member/get";
        InputGetGroupMember input = new InputGetGroupMember();
        input.setGroupId(groupId);
        input.setMemberId(memberId);
        return this.robotHttpUtils.httpJsonPost(path, input, PojoGroupMember.class);
    }

    public IMResult<Void> addGroupMembers(String groupId, List<PojoGroupMember> groupMembers, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/member/add";
        InputAddGroupMember addGroupMember = new InputAddGroupMember();
        addGroupMember.setGroup_id(groupId);
        addGroupMember.setMembers(groupMembers);
        addGroupMember.setTo_lines(to_lines);
        addGroupMember.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, addGroupMember, Void.class);
    }

    public IMResult<Void> setGroupManager(String groupId, List<String> groupMemberIds, boolean isManager, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/manager/set";
        InputSetGroupManager addGroupMember = new InputSetGroupManager();
        addGroupMember.setGroup_id(groupId);
        addGroupMember.setMembers(groupMemberIds);
        addGroupMember.setIs_manager(isManager);
        addGroupMember.setTo_lines(to_lines);
        addGroupMember.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, addGroupMember, Void.class);
    }

    public IMResult<Void> muteGroupMember(String groupId, List<String> groupMemberIds, boolean isMute, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/manager/mute";
        InputMuteGroupMember addGroupMember = new InputMuteGroupMember();
        addGroupMember.setGroup_id(groupId);
        addGroupMember.setMembers(groupMemberIds);
        addGroupMember.setIs_manager(isMute);
        addGroupMember.setTo_lines(to_lines);
        addGroupMember.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, addGroupMember, Void.class);
    }

    public IMResult<Void> allowGroupMember(String groupId, List<String> groupMemberIds, boolean isAllow, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/manager/allow";
        InputMuteGroupMember addGroupMember = new InputMuteGroupMember();
        addGroupMember.setGroup_id(groupId);
        addGroupMember.setMembers(groupMemberIds);
        addGroupMember.setIs_manager(isAllow);
        addGroupMember.setTo_lines(to_lines);
        addGroupMember.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, addGroupMember, Void.class);
    }

    public IMResult<Void> kickoffGroupMembers(String groupId, List<String> groupMemberIds, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/member/del";
        InputKickoffGroupMember kickoffGroupMember = new InputKickoffGroupMember();
        kickoffGroupMember.setGroup_id(groupId);
        kickoffGroupMember.setMembers(groupMemberIds);
        kickoffGroupMember.setTo_lines(to_lines);
        kickoffGroupMember.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, kickoffGroupMember, Void.class);
    }

    public IMResult<Void> quitGroup(String groupId, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/member/quit";
        InputQuitGroup quitGroup = new InputQuitGroup();
        quitGroup.setGroup_id(groupId);
        quitGroup.setTo_lines(to_lines);
        quitGroup.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, quitGroup, Void.class);
    }

    public IMResult<Void> setGroupMemberAlias(String groupId, String memberId, String alias, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/member/set_alias";
        InputSetGroupMemberAlias input = new InputSetGroupMemberAlias();
        input.setGroup_id(groupId);
        input.setMemberId(memberId);
        input.setAlias(alias);
        input.setTo_lines(to_lines);
        input.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public IMResult<Void> setGroupMemberExtra(String groupId, String memberId, String extra, List<Integer> to_lines, MessagePayload notify_message) throws Exception {
        String path = "/robot/group/member/set_extra";
        InputSetGroupMemberExtra input = new InputSetGroupMemberExtra();
        input.setGroup_id(groupId);
        input.setMemberId(memberId);
        input.setExtra(extra);
        input.setTo_lines(to_lines);
        input.setNotify_message(notify_message);
        return this.robotHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public IMResult<OutputApplicationUserInfo> applicationGetUserInfo(String authCode) throws Exception {
        String path = "/robot/application/get_user_info";
        InputApplicationGetUserInfo input = new InputApplicationGetUserInfo();
        input.setAuthCode(authCode);
        return this.robotHttpUtils.httpJsonPost(path, input, OutputApplicationUserInfo.class);
    }

    public OutputApplicationConfigData getApplicationSignature() {
        int nonce = (int)(Math.random() * 100000.0 + 3.0);
        long timestamp = System.currentTimeMillis() / 1000L;
        String str = nonce + "|" + this.robotHttpUtils.getRobotId() + "|" + timestamp + "|" + this.robotHttpUtils.getRobotSecret();
        String sign = DigestUtils.sha1Hex((String)str);
        OutputApplicationConfigData configData = new OutputApplicationConfigData();
        configData.setAppId(this.robotHttpUtils.getRobotId());
        configData.setAppType(0);
        configData.setTimestamp(timestamp);
        configData.setNonceStr(nonce + "");
        configData.setSignature(sign);
        return configData;
    }

    public IMResult<String> sendConferenceRequest(String robotId, String clientId, String request, long sessionId, String roomId, String data, boolean advance) throws Exception {
        String path = "/robot/conference/request";
        InputConferenceRequest input = new InputConferenceRequest(robotId, clientId, request, sessionId, roomId, data, advance);
        return this.robotHttpUtils.httpJsonPost(path, input, String.class);
    }
}

