/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.HealthCheckResult;
import cn.wildfirechat.pojos.InputChannelId;
import cn.wildfirechat.pojos.InputCreateChannel;
import cn.wildfirechat.pojos.InputSubscribeChannel;
import cn.wildfirechat.pojos.OutputBooleanValue;
import cn.wildfirechat.pojos.OutputCreateChannel;
import cn.wildfirechat.pojos.OutputGetChannelInfo;
import cn.wildfirechat.pojos.SystemSettingPojo;
import cn.wildfirechat.pojos.UserSettingPojo;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.AdminHttpUtils;

public class GeneralAdmin {
    public static IMResult<SystemSettingPojo> getSystemSetting(int id) throws Exception {
        String path = "/admin/system/get_setting";
        SystemSettingPojo input = new SystemSettingPojo();
        input.id = id;
        return AdminHttpUtils.httpJsonPost(path, input, SystemSettingPojo.class);
    }

    public static IMResult<Void> setSystemSetting(int id, String value, String desc) throws Exception {
        String path = "/admin/system/put_setting";
        SystemSettingPojo input = new SystemSettingPojo();
        input.id = id;
        input.value = value;
        input.desc = desc;
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputCreateChannel> createChannel(InputCreateChannel inputCreateChannel) throws Exception {
        String path = "/admin/channel/create";
        return AdminHttpUtils.httpJsonPost(path, inputCreateChannel, OutputCreateChannel.class);
    }

    public static IMResult<Void> destroyChannel(String channelId) throws Exception {
        String path = "/admin/channel/destroy";
        InputChannelId inputChannelId = new InputChannelId(channelId);
        return AdminHttpUtils.httpJsonPost(path, inputChannelId, Void.class);
    }

    public static IMResult<OutputGetChannelInfo> getChannelInfo(String channelId) throws Exception {
        String path = "/admin/channel/get";
        InputChannelId inputChannelId = new InputChannelId(channelId);
        return AdminHttpUtils.httpJsonPost(path, inputChannelId, OutputGetChannelInfo.class);
    }

    public static IMResult<Void> subscribeChannel(String channelId, String userId) throws Exception {
        String path = "/admin/channel/subscribe";
        InputSubscribeChannel input = new InputSubscribeChannel(channelId, userId, 1);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<Void> unsubscribeChannel(String channelId, String userId) throws Exception {
        String path = "/admin/channel/subscribe";
        InputSubscribeChannel input = new InputSubscribeChannel(channelId, userId, 0);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputBooleanValue> isUserSubscribedChannel(String userId, String channelId) throws Exception {
        String path = "/admin/channel/is_subscribed";
        InputSubscribeChannel input = new InputSubscribeChannel(channelId, userId, 0);
        return AdminHttpUtils.httpJsonPost(path, input, OutputBooleanValue.class);
    }

    public static IMResult<Void> setConversationTop(String userId, int conversationType, String target, int line, boolean isTop) throws Exception {
        String key = conversationType + "-" + line + "-" + target;
        String value = isTop ? "1" : "0";
        return GeneralAdmin.setUserSetting(userId, 3, key, value);
    }

    public static IMResult<Boolean> getConversationTop(String userId, int conversationType, String target, int line) throws Exception {
        String key = conversationType + "-" + line + "-" + target;
        IMResult<UserSettingPojo> result = GeneralAdmin.getUserSetting(userId, 3, key);
        IMResult<Boolean> out = new IMResult<Boolean>();
        out.code = result.code;
        out.msg = result.msg;
        out.result = result.result != null && "1".equals(((UserSettingPojo)result.result).getValue());
        return out;
    }

    public static IMResult<UserSettingPojo> getUserSetting(String userId, int scope, String key) throws Exception {
        String path = "/admin/user/get_setting";
        UserSettingPojo pojo = new UserSettingPojo();
        pojo.setUserId(userId);
        pojo.setScope(scope);
        pojo.setKey(key);
        return AdminHttpUtils.httpJsonPost(path, pojo, UserSettingPojo.class);
    }

    public static IMResult<Void> setUserSetting(String userId, int scope, String key, String value) throws Exception {
        String path = "/admin/user/put_setting";
        UserSettingPojo pojo = new UserSettingPojo();
        pojo.setUserId(userId);
        pojo.setScope(scope);
        pojo.setKey(key);
        pojo.setValue(value);
        return AdminHttpUtils.httpJsonPost(path, pojo, Void.class);
    }

    public static IMResult<HealthCheckResult> healthCheck() throws Exception {
        return AdminHttpUtils.httpGet("/admin/health", HealthCheckResult.class);
    }

    public static IMResult<String> getCustomer() throws Exception {
        return AdminHttpUtils.httpJsonPost("/admin/customer", null, String.class);
    }
}

