#!/bin/sh
#
# newvers.sh - increment build number in current directory (a build directory)
#              and emit vers.c.
#              The build number is kept in the file "version".
#
# Usage: newvers.sh CONFIGNAME

#
# Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005, 2008, 2009
#	The President and Fellows of Harvard College.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of the University nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

if [ ! -f autoconf.c ]; then
    #
    # If there's no file autoconf.c, we are in the wrong place.
    #
    echo "$0: Not in a kernel build directory"
    exit 1
fi

if [ "x$1" = x ]; then
    echo "Usage: $0 CONFIGNAME"
    exit 1
fi

CONFIG="$1"

#
# Get and increment the version number
#

VERS=`cat version 2>/dev/null || echo 0`
VERS=`expr $VERS + 1`
echo "$VERS" > version

#
# Write vers.c
#

echo '/* This file is automatically generated. Edits will be lost.*/' > vers.c
echo "const int buildversion = $VERS;" >> vers.c
echo 'const char buildconfig[] = "'"$CONFIG"'";' >> vers.c
