use catppuccin::Rgb;

pub fn premul(x: f32, y: f32, z: f32, w: f32) -> [f32; 4] {
    [x * w, y * w, z * w, w]
}

pub fn premul_array(xyzw: [f32; 4]) -> [f32; 4] {
    premul(xyzw[0], xyzw[1], xyzw[2], xyzw[3])
}

pub fn rgb_alpha(xyz: [f32; 3], w: f32) -> [f32; 4] {
    [xyz[0], xyz[1], xyz[2], w]
}

pub fn norm_rgb(rgb: &Rgb) -> [f32; 3] {
    [
        (rgb.r as f32) / (u8::MAX as f32),
        (rgb.g as f32) / (u8::MAX as f32),
        (rgb.b as f32) / (u8::MAX as f32),
    ]
}
