use crate::app::PhosdbState;

use super::{about::UiAbout, UiElement, UiNode};

#[derive(Default)]
pub struct UiMenu {
    ui_about: UiAbout,
}

impl UiNode for UiMenu {
    fn render(&mut self, ui: &imgui::Ui) {
        let mut popup: Option<&str> = None;

        ui.main_menu_bar(|| {
            ui.menu("Help", || {
                if ui.menu_item("About") {
                    popup = Some("About");
                }
            });
        });

        if let Some(id) = popup {
            debug!("opening popup {}", id);
            ui.open_popup(id);
        }

        self.ui_about.render(ui);
    }
}

impl UiElement<PhosdbState> for UiMenu {
    fn update(&mut self, _state: &mut PhosdbState) {}
}
