use crate::{
    app::PhosdbState,
    util::{norm_rgb, rgb_alpha},
    COPYRIGHT_YEAR,
};

use super::{UiElement, UiNode};

#[derive(Default)]
pub struct UiAbout {}

impl UiNode for UiAbout {
    fn render(&mut self, ui: &imgui::Ui) {
        super::center_next_window();

        let popup = ui
            .modal_popup_config("About")
            .always_auto_resize(true)
            .movable(false);

        if let Some(_token) = popup.begin_popup() {
            let header = |s: &str| {
                ui.text_colored(
                    rgb_alpha(
                        norm_rgb(&catppuccin::PALETTE.latte.colors.lavender.rgb),
                        1.0,
                    ),
                    s,
                )
            };

            super::text_hcenter(
                ui,
                format!("phosdb_rs {}", env!("CARGO_PKG_VERSION")).as_str(),
                header,
            );
            super::text_hcenter(
                ui,
                format!("Copyright \u{00A9} {} wipet", COPYRIGHT_YEAR).as_str(),
                header,
            );
            ui.new_line();

            super::text_hcenter(
                ui,
                "phosdb_rs is the official debugger for the Phos kernel.",
                |s| ui.text(s),
            );
            ui.new_line();

            if super::button_hcenter(ui, "Ok", |s: &str| ui.button(s)) {
                ui.close_current_popup();
            }
        }
    }
}

impl UiElement<PhosdbState> for UiAbout {
    fn update(&mut self, _state: &mut PhosdbState) {}
}
