use std::{
    net::{SocketAddr, TcpStream},
    time::Duration,
};

#[derive(Default)]
pub struct Serial {
    stream: Option<TcpStream>,
}

impl Serial {
    pub fn new(addr: &SocketAddr) -> Serial {
        let result = TcpStream::connect_timeout(addr, Duration::new(5, 0));

        Serial {
            stream: if let Ok(stream) = result {
                Some(stream)
            } else {
                None
            },
        }
    }

    pub fn is_connected(&self) -> bool {
        self.stream.is_some()
    }

    pub fn disconnect(&mut self) {
        self.stream = None;
    }
}
