mod app;
mod protocol;
mod serial;
mod ui;
mod util;

use app::{App, PhosdbApp};
use color_eyre::eyre::{self, eyre};
use winit::event_loop::EventLoop;

extern crate pretty_env_logger;
#[macro_use]
extern crate log;

pub const COPYRIGHT_YEAR: &str = "2024";

fn main() -> eyre::Result<()> {
    color_eyre::install()?;
    pretty_env_logger::init();

    info!("starting Phosdb");

    let event_loop = EventLoop::new().unwrap();
    let app = PhosdbApp::new(event_loop);
    let result = app.run();

    if let Err(err) = result {
        Err(eyre!(format!(
            "Phosdb encountered an error: {}",
            err.to_string()
        )))
    } else {
        Ok(())
    }
}
