use std::env;
use std::path::PathBuf;

fn main() {
    println!("cargo::rerun-if-changed=../Phosdb/Protocol.c");
    cc::Build::new()
        .include("../")
        .file("../Phosdb/Protocol.c")
        .compile("PhosdbProtocol");

    println!(
        "cargo:rustc-link-search=\"{}\"",
        env::var("OUT_DIR").unwrap()
    );
    println!("cargo:rustc-link-lib=PhosdbProtocol");

    let bindings = bindgen::Builder::default()
        .header("../Phosdb/Protocol.h")
        .clang_arg("-I../")
        .allowlist_file("../Phosdb/Protocol.h")
        .parse_callbacks(Box::new(bindgen::CargoCallbacks::new()))
        .generate()
        .expect("unable to generate bindings");

    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("couldn't write bindings");
}
