#include "Kd.h"

#include <Rtl/Rtl.h>
#include <Hal/Hal.h>
#include <Phosdb/Protocol.h>

BOOLEAN
PHOSAPI
KdPrint(
	IN const CHAR8 *Message
	)
{
	PDPACKET_MESSAGE *Packet;
	UINTN             MessageSize;
	UINTN             PacketSize;

	MessageSize = RtlStringSizeA(Message);
	PacketSize = sizeof(PDPACKET_MESSAGE) + MessageSize;
	Packet = __builtin_alloca(PacketSize);

	RtlCopyMemory((VOID *)Packet->Message, Message, MessageSize);

	PdPacketMessageInit(Packet);

	HalWriteSerialEx(COM1, (const UINT8 *)Packet, PacketSize);

	return TRUE;
}
