#pragma once

#include <Phosdef.h>

#define DEBUG_SIGNATURE      "PHOSDB\0"
#define DEBUG_SIGNATURE_SIZE 8

#define _PDPACKET                           \
	CHAR8  Signature[DEBUG_SIGNATURE_SIZE]; \
	UINT32 Size;                            \
	UINT8  Identifier

typedef enum {
	PHOSDB_ID_NONE,
	PHOSDB_ID_MESSAGE
} PDIDENTIFIER;

#pragma pack(push, 1)

typedef struct {
	_PDPACKET;
} PDPACKET;

typedef struct {
	_PDPACKET;
	const CHAR8 Message[];
} PDPACKET_MESSAGE;

#pragma pack(pop)

EXTERN_C const CHAR8 DebugSignature[DEBUG_SIGNATURE_SIZE];

VOID
SHAREDAPI
PdPacketInit(
	IN OUT PDPACKET *Packet
	);

VOID
SHAREDAPI
PdPacketMessageInit(
	IN OUT PDPACKET_MESSAGE *Packet
	);

/*
UINTN
SHAREDAPI
PhosdbSerializeMessage(
	IN     const DEBUG_PACKET_MESSAGE *Packet,
	IN OUT VOID                       *Data,
	IN     UINTN                       DataSize
	);

UINTN
SHAREDAPI
PhosdbDeserializeMessage(
	IN     const VOID           *Data,
	IN     UINTN                 DataSize,
	IN OUT DEBUG_PACKET_MESSAGE *Packet
	);
*/
