-- system.lua
--
-- This script is executed after a system boot or a system reset and is intended
-- to config Lua RTOS

-- DO NOT EDIT THIS FILE. TO CHANGE THE DEFAULT CONFIGURATIONS EDIT THE config.lua
-- FILE

-- Config table
config = {
	shell = true,
	history = true,	
	loglevel = os.LOG_INFO,
	logcons = true,
	wifi = false,
	ap = false,
	ethernet = false,
	sntp = false,
	http = false,
	openvpn = false,
	ssh = false,
	lora = {
		gw = false,
	},
	can = {
		gw = false
	},
	net = {
		wifi = nil,
		ethernet = nil
	},
	data = {}
}

-- Default wifi config
config.data.wifi = {
	ssid = "",
	pass = "",
	ip = nil,
	mask = nil,
	gw = nil,
	dns1 = nil,
	dns2 = nil
}

-- Default ethernet config
config.data.ethernet = {
	ssid = "",
	pass = "",
	ip = nil,
	mask = nil,
	gw = nil,
	dns1 = nil,
	dns2 = nil
}

-- HTTP server default config
config.data.http = {
	httpPort = 80,
	httpsPort = 0, 
	caFile = "",
	keyFile = ""
}

-- CAN gateway default config
config.data.can = {
	gw = {
		port = 1333,
		speed = 1000
	}
}

-- Load configution
dofile("config.lua")

if (config.wifi) then
	config.net.wifi = config.data.wifi
end

if (config.ethernet) then
	config.net.ethernet = config.data.ethernet
end

-- Network setup
if (config.wifi) then
	print("Starting wifi ...")
	net.wf.setup(
		net.wf.mode.STA, config.net.wifi.ssid, config.net.wifi.pass, 
		config.net.wifi.ip, config.net.wifi.mask, config.net.wifi.gw,
		config.net.wifi.dns1, config.net.wifi.dns2
	)
	net.wf.start()
end

if (config.ethernet) then
	print("Starting ethernet ...")
	net.en.setup(
		config.net.ethernet.ip, config.net.ethernet.mask, config.net.ethernet.gw,
		config.net.ethernet.dns1, config.net.ethernet.dns2
	)
	net.en.start()
end

-- Start network services
if (config.sntp or config.openvpn or config.ssh or config.lora.gw) then
	print("Starting sntp client ...")
	net.service.sntp.start()
end

if (config.lora.gw) then
	print("Starting lora gateway ...")
	lora.attach()
end

if (config.http) then
	print("Starting http server ...")
	net.service.http.start(
		config.data.http.httpPort, config.data.http.httpsPort,
		config.data.http.caFile, config.data.http.keyFile
	)
end

if (config.can.gw) then
	net.service.can.start(can.CAN0, config.data.can.gw.speed, config.data.can.gw.port)
end

if (config.openvpn) then
	print("Starting openvpn client ...")
	net.service.openvpn.start()
end

if (config.ssh) then
	print("Starting ssh server ...")
	net.service.ssh.start()
end

-- Main setups
os.shell(config.shell)
os.history(config.history)
os.loglevel(config.loglevel)
os.logcons(config.logcons)

config = nil