([Français](#boîte-à-outils-de-lexpérience-web-boew))

# Web Experience Toolkit (WET)

[![Build Status](https://secure.travis-ci.org/wet-boew/wet-boew.svg?branch=master)](https://travis-ci.org/wet-boew/wet-boew)
[![devDependency Status](https://david-dm.org/wet-boew/wet-boew/dev-status.svg)](https://david-dm.org/wet-boew/wet-boew#info=devDependencies)

## What is the Web Experience Toolkit?

* An [award-winning](https://wet-boew.github.io/wet-boew/docs/ref/accolades-en.html#awards) front-end framework for building websites that are [accessible](https://wet-boew.github.io/wet-boew/index-en.html#accessibility), [usable](https://wet-boew.github.io/wet-boew/index-en.html#usability), [interoperable](https://wet-boew.github.io/wet-boew/index-en.html#interoperability), [mobile friendly](https://wet-boew.github.io/wet-boew/index-en.html#mobile-friendly-responsive-design) and [multilingual](https://wet-boew.github.io/wet-boew/index-en.html#multilingual)
* A collection of [flexible and themeable templates and reusable components](https://wet-boew.github.io/wet-boew/index-en.html#themeable-and-reusable)
* A [collaborative open source project led by the Government of Canada](https://wet-boew.github.io/wet-boew/index-en.html#collaborative-approach)

## Key resources

* [Documentation](https://wet-boew.github.io/wet-boew/docs/index-en.html)
* [Downloads](https://wet-boew.github.io/wet-boew/docs/versions/dwnld-en.html)
* [Examples](https://wet-boew.github.io/wet-boew/demos/index-en.html)
* [Version history](https://wet-boew.github.io/wet-boew/docs/versions/index-en.html) and [roadmap](https://wet-boew.github.io/wet-boew/docs/versions/rdmp-en.html)
* [Terms and conditions](https://wet-boew.github.io/wet-boew/License-en.html) (MIT license)
* [Source code repository](https://github.com/wet-boew/wet-boew/) and [contributing guidelines](https://wet-boew.github.io/wet-boew/docs/start-en.html#develop)
* [Communications material](https://wet-boew.github.io/wet-boew/docs/comms-en.html)
* [Websites using WET](https://wet-boew.github.io/wet-boew/docs/ref/wetsites-en.html)

## Benefits

### Accessibility

* Conforms to [WCAG 2.0](https://www.w3.org/TR/WCAG20/) level AA
* Leverages [WAI-ARIA](https://www.w3.org/TR/wai-aria/) to further enhance accessibility
* Assistive technology testing (Access Working Group)

### Usability

* Iterative approach to design
* Design patterns and usability testing (User Experience Working Group)

### Interoperability

* [HTML5](https://www.w3.org/TR/html5/)-first approach (leveraging native HTML5 support and filling support gaps with “polyfills”)
* Supporting a wide variety of browsers (Edge, Firefox, Chrome, Safari, Opera)
* Building support for HTML data ([RDFa 1.1 Lite](https://www.w3.org/TR/rdfa-lite/), [Schema.org](https://www.schema.org/))

### Mobile friendly responsive design

* Adapts to different screen sizes and device capabilities
* Touchscreen support
* Optimized for performance
* Building support for device-based mobile applications

### Multilingual

* Currently supports 34 languages (including right-to-left languages)
  * English
  * French
  * Afrikaans
  * Albanian
  * Arabic
  * Armenian
  * Bulgarian
  * Chinese
  * Chinese (Simplified)
  * Czech
  * Dutch
  * Estonian
  * German
  * Greek
  * Hindi
  * Hungarian
  * Icelandic
  * Indonesian
  * Inuktitut
  * Italian
  * Japanese
  * Korean
  * Latvian
  * Lithuanian
  * Polish
  * Portuguese
  * Portuguese (Brazilian)
  * Russian
  * Slovak
  * Spanish
  * Thai
  * Turkish
  * Ukranian
  * Vietnamese

### Themeable and reusable

* Flexible framework that supports custom themes
* Includes support for [2 different themes](https://wet-boew.github.io/wet-boew/docs/ref/themesstyle-en.html)
* Reusable templates, [plugins](https://wet-boew.github.io/wet-boew/docs/ref/plugins-en.html) and widgets
* [Adapted to various CMS and programming frameworks](https://wet-boew.github.io/wet-boew/docs/ref/variants-en.html) (Drupal, WordPress, SharePoint (in development), DotNetNuke (in development), PHP, SSI, Java/Maven)

### Reduces costs by openly sharing and collaborating

* Drives down research and development costs
* Avoids duplication of effort
* Produces better quality results

### Collaborative approach

* Project managed openly on GitHub, including discussion through the issues tracker
* Encouraging a free flow of ideas, dialogue and innovation including sharing of challenges and ideas
* External contributions welcome
  * Pull requests
  * Design patterns
  * Issues and suggestions
  * Documentation
  * Testing
* Multi-level review process for contributions to ensure code integrity (combination of automated and manual reviews)

## How to Contribute

See [CONTRIBUTING.md](CONTRIBUTING.md)

## License

Unless otherwise noted, the source code of this project is covered under Crown Copyright, Government of Canada, and is distributed under the [MIT License](LICENSE).

The Canada wordmark and related graphics associated with this distribution are protected under trademark law and copyright law. No permission is granted to use them outside the parameters of the Government of Canada's corporate identity program. For more information, see [Federal identity requirements](https://www.canada.ca/en/treasury-board-secretariat/topics/government-communications/federal-identity-requirements.html).

-------------------------------------------------------------------

# Boîte à outils de l’expérience Web (BOEW)

## Qu’est-ce que la Boîte à outils de l’expérience Web?

* Une bibliothèque de code [primée](https://wet-boew.github.io/wet-boew/docs/ref/accolades-fr.html#primes) pour construire des sites Web [accessibles](https://wet-boew.github.io/wet-boew/index-fr.html#accessibilit), [faciles d'emploi](https://wet-boew.github.io/wet-boew/index-fr.html#facilit-demploi), [interopérables](https://wet-boew.github.io/wet-boew/index-fr.html#interoprabilit), [optimisés pour les appareils mobiles](https://wet-boew.github.io/wet-boew/index-fr.html#conception-optimise-pour-les-appareils-mobiles-et-ractive) et [multilingues](https://wet-boew.github.io/wet-boew/index-fr.html#multilingue)
* [Des modèles, ainsi que des composants réutilisables, qui sont flexibles et personnalisables](https://wet-boew.github.io/wet-boew/index-fr.html#personnalisable-et-rutilisable)
* Un [projet à source ouverte collaboratif dirigé par le Gouvernement du Canada](https://wet-boew.github.io/wet-boew/index-fr.html#approche-collaborative)

## Ressources clés

* [Documentation](https://wet-boew.github.io/wet-boew/docs/index-fr.html)
* [Téléchargements](https://wet-boew.github.io/wet-boew/docs/versions/dwnld-fr.html)
* [Exemples pratiques](https://wet-boew.github.io/wet-boew/demos/index-fr.html)
* [Historique des versions](https://wet-boew.github.io/wet-boew/docs/versions/index-fr.html) et [feuille de route](https://wet-boew.github.io/wet-boew/docs/versions/rdmp-fr.html)
* [Conditions régissant l'utilisation](https://wet-boew.github.io/wet-boew/Licence-fr.html) (licence MIT)
* [Dépôt de code source](https://github.com/wet-boew/wet-boew/) et [lignes directrices pour les contributeurs](https://wet-boew.github.io/wet-boew/docs/start-fr.html#develop)
* [Matériel de communications](https://wet-boew.github.io/wet-boew/docs/comms-fr.html)
* [Sites Web qui se servent de la BOEW](https://wet-boew.github.io/wet-boew/docs/ref/wetsites-fr.html)

## Avantages

### Accessibilité

* Conforme aux [Règles pour l'accessibilité des contenus Web (WCAG) 2.0](https://www.w3.org/Translations/WCAG20-fr/) niveau AA
* S'appuie sur [WAI-ARIA](https://www.w3.org/TR/wai-aria/) pour améliorer l'accessibilité
* Vérification avec les technologies d'assistance (Groupe de travail sur l'accessibilité)

### Facilité d'emploi

* Approche itérative pour la conception
* Patrons de conception et les essais de facilité d'emploi (Groupe de travail sur l'expérience des utilisateurs)

### Interopérabilité

* Approche centrée sur le [HTML5](https://www.w3.org/TR/html5/) (s'appuyant sur le soutien HTML5 natif et puis les &laquo;correctifs&raquo; pour résoudre les problèmes de soutien)
* Soutien pour plusieurs navigateurs (Edge, Firefox, Chrome, Safari, Opera)
* Soutien en développement pour les données HTML ([RDFa 1.1 Lite](https://www.w3.org/TR/rdfa-lite/), [Schema.org](https://www.schema.org/))

### Conception optimisée pour les appareils mobiles et réactive

* S'adapte à différentes tailles d'écran et capacités d'appareil
* Soutien pour les écrans tactiles
* Optimisé pour les performances
* Soutien en développement pour les applications s’installant sur un appareil mobile

### Multilingue

* Soutien actuellement 34 langues (y compris les langues droite-à-gauche)
  * Anglais
  * Français
  * Afrikaans
  * Albanais
  * Allemand
  * Arabe
  * Arménien
  * Bulgare
  * Chinois
  * Chinois (simplifiée)
  * Coréen
  * Espagnol
  * Estonien
  * Grec
  * Hindi
  * Hongrois
  * Indonésien
  * Inuktitut
  * Islandais
  * Italien
  * Japonais
  * Letton
  * Lituanien
  * Néerlandais
  * Polonais
  * Portugais
  * Portugais (brésilien)
  * Russe
  * Slovaque
  * Tchèque
  * Thaï
  * Turc
  * Ukrainien
  * Vietnamien

### Personnalisable et réutilisable

* Cadre flexible qui supporte des thèmes personnalisés
* Soutien [2 thèmes différents](https://wet-boew.github.io/wet-boew/docs/ref/themesstyle-fr.html)
* Modèles, [plugiciels](https://wet-boew.github.io/wet-boew/docs/ref/plugins-fr.html) et gadgets réutilisables
* [Adapté aux différents systèmes de gestion de contenu et cadres de programmation](https://wet-boew.github.io/wet-boew/docs/ref/variants-fr.html) (Drupal, WordPress, SharePoint (en développement), DotNetNuke (en développement), PHP, SSI, Java/Maven)

### Réduit les coûts en partageant et en collaborant ouvertement

* Réduit les coûts de recherche et de développement
* Évite la duplication des efforts
* Produit des résultats de meilleure qualité

### Approche collaborative

* Projet géré ouvertement sur GitHub, y compris les discussions à travers le système de suivi des questions
* Encourage la libre circulation des idées, du dialogue et de l'innovation, y compris le partage des défis et des idées
* Les contributions externes sont invités
  * Soumissions de code
  * Patrons de conception
  * Problèmes et suggestions
  * Documentation
  * Évaluations
* Processus d'examen sur plusieurs niveaux pour les contributions pour assurer l'intégrité du code (combinaison d'évaluations automatisées et manuelles)

## Comment contribuer
Voir [CONTRIBUTING.md](CONTRIBUTING.md)

## Licence
Sauf indication contraire, le code source de ce projet est protégé par le droit d'auteur de la Couronne du gouvernement du Canada et distribué sous la [licence MIT](LICENSE).

Le mot-symbole « Canada » et les éléments graphiques connexes liés à cette distribution sont protégés en vertu des lois portant sur les marques de commerce et le droit d'auteur. Aucune autorisation n'est accordée pour leur utilisation à l'extérieur des paramètres du programme de coordination de l'image de marque du gouvernement du Canada. Pour obtenir davantage de renseignements à ce sujet, veuillez consulter les [Exigences pour l'image de marque](https://www.canada.ca/fr/secretariat-conseil-tresor/sujets/communications-gouvernementales/exigences-image-marque.html).
