([Français](#comment-contribuer))

# How to Contribute

When contributing, post comments and discuss changes you wish to make via Issues.

Feel free to propose changes by creating [Pull Requests](https://wet-boew.github.io/wet-boew/docs/pull-en.html). If you don't have write access, editing a file will create a Fork of this project for you to save your proposed changes to. Submitting a change to a file will write it to a new Branch in your Fork, so you can send a Pull Request.

If this is your first time contributing on GitHub, don't worry! Here are some guidelines to help you get started:

## Fixing or improving WET as a developer

Refer to the [get started rubric for developers](https://wet-boew.github.io/wet-boew/docs/start-en.html#develop).

## Create or edit WET features

* Any and all descriptions, guides, or instructions for WET should be included as HTML files in this repository.
* Follow the [documentation example template](https://wet-boew.github.io/wet-boew/docs/ref/docstmpl-en.html).
* At least one working example should be provided for each WET utility, component (plugin or pattern), template or theme. Additional examples should be provided for each parameter or option.

Let us know if you have any questions, or join [WET Office hours](https://github.com/wet-boew/wet-boew/wiki/WET-Office-hours,-Heures-de-service-de-la-BOEW). Please take time to read our [code of conduct](CODE_OF_CONDUCT.md) prior to contributing to the project.

## Security

**Do not post any security issues on the public repository!** See [SECURITY.md](SECURITY.md#security)

______________________

# Comment contribuer

Lorsque vous contribuez, veuillez également publier des commentaires et discuter des modifications que vous souhaitez apporter par l'entremise des enjeux (Issues).

N'hésitez pas à proposer des modifications en créant des demandes de retrait ([Pull Requests](https://wet-boew.github.io/wet-boew/docs/pull-fr.html)). Si vous n'avez pas accès au mode de rédaction, la modification d'un fichier créera une copie (Fork) de ce projet afin que vous puissiez enregistrer les modifications que vous proposez. Le fait de proposer une modification à un fichier l'écrira dans une nouvelle branche dans votre copie (Fork), de sorte que vous puissiez envoyer une demande de tirage (Pull Request).

Si c'est la première fois que vous contribuez à GitHub, ne vous en faites pas! Voici quelques lignes directrices pour vous aider à démarrer :

## Corriger ou améliorer la BOEW en tant que développeur

Veuillez lire la [rubrique pour développeurs dans la section comment démarrer](https://wet-boew.github.io/wet-boew/docs/start-fr.html#develop).

## Créer ou modifier une fonctionnalité dans la BOEW

* Inclure tous les guides, les descriptions ou les directives pour la BOEW en fichiers HTML dans ce répertoire.
* Suivre le <a href="https://wet-boew.github.io/wet-boew/docs/ref/docstmpl-fr.html">modèle de documentation</a>.
* Fournir au moins un exemple pour chaque utilitaire, composante (plugiciel ou motif), gabarit ou thème de la BOEW. D’autres exemples doivent être donnés pour chaque paramètre ou option.

Faites-nous part de vos questions, ou rejoignez les [Heures de service de la BOEW](https://github.com/wet-boew/wet-boew/wiki/WET-Office-hours,-Heures-de-service-de-la-BOEW). Assurez vous de prendre le temps de consulter notre [code de conduite](CODE_OF_CONDUCT.md#Code-de-conduite-pour-le-projet-Boîte-à-outils-de-lexpérience-Web) en vue de contribuer au projet.

## Sécurité

**Ne publiez aucun problème de sécurité sur le dépôt publique!** Voir [SECURITY.md](SECURITY.md)
