## Fontbakery report

<details>
<summary><b>[23] Family checks</b></summary>
<details>
<summary>:fire: <b>FAIL:</b> Check font has a license.</summary>

* [com.google.fonts/check/028](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/028)
* :fire: **FAIL** No license file was found. Please add an OFL.txt or a LICENSE.txt file. If you are running fontbakery on a Google Fonts upstream repo, which is fine, just make sure there is a temporary license file in the same folder. [code: none]

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking all files are in the same directory.</summary>

* [com.google.fonts/check/002](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/002)
* :bread: **PASS** All files are in the same directory.

</details>
<details>
<summary>:bread: <b>PASS:</b> Fonts have equal unicode encodings?</summary>

* [com.google.fonts/check/013](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/013)
* :bread: **PASS** Fonts have equal unicode encodings.

</details>
<details>
<summary>:bread: <b>PASS:</b> Make sure all font files have the same version value.</summary>

* [com.google.fonts/check/014](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/014)
* :bread: **PASS** All font files have the same version.

</details>
<details>
<summary>:bread: <b>PASS:</b> Fonts have consistent PANOSE proportion?</summary>

* [com.google.fonts/check/009](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/009)
* :bread: **PASS** Fonts have consistent PANOSE proportion.

</details>
<details>
<summary>:bread: <b>PASS:</b> Fonts have consistent PANOSE family type?</summary>

* [com.google.fonts/check/010](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/010)
* :bread: **PASS** Fonts have consistent PANOSE family type.

</details>
<details>
<summary>:bread: <b>PASS:</b> Fonts have consistent underline thickness?</summary>

* [com.google.fonts/check/008](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/008)
* :bread: **PASS** Fonts have consistent underline thickness.

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Copyright notice is the same in all fonts?</summary>

* [com.google.fonts/check/088](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/088)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check that METADATA family values are all the same.</summary>

* [com.google.fonts/check/089](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/089)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb should contain at least "menu" and "latin" subsets.</summary>

* [com.google.fonts/check/086](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/086)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb subsets should be alphabetically ordered.</summary>

* [com.google.fonts/check/087](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/087)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb: check if fonts field only contains unique style:weight pairs.</summary>

* [com.google.fonts/check/084](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/084)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb license is "APACHE2", "UFL" or "OFL"?</summary>

* [com.google.fonts/check/085](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/085)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb: check if fonts field only has unique "full_name" values.</summary>

* [com.google.fonts/check/083](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/083)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb: Ensure designer simple short name.</summary>

* [com.google.fonts/check/080](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/080)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb: Fontfamily is listed on Google Fonts API?</summary>

* [com.google.fonts/check/081](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/081)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> DESCRIPTION.en_us.html must have less than 1000 bytes.</summary>

* [com.google.fonts/check/006](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/006)
* :zzz: **SKIP** Unfulfilled Conditions: description

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Font designer field in METADATA.pb must not be 'unknown'.</summary>

* [com.google.fonts/check/007](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/007)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Is this a proper HTML snippet?</summary>

* [com.google.fonts/check/004](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/004)
* :zzz: **SKIP** Unfulfilled Conditions: descfile

</details>
<details>
<summary>:zzz: <b>SKIP:</b> DESCRIPTION.en_us.html must have more than 200 bytes.</summary>

* [com.google.fonts/check/005](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/005)
* :zzz: **SKIP** Unfulfilled Conditions: description

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Does DESCRIPTION file contain broken links?</summary>

* [com.google.fonts/check/003](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/003)
* :zzz: **SKIP** Unfulfilled Conditions: description

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Regular should be 400.</summary>

* [com.google.fonts/check/091](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/091)
* :zzz: **SKIP** Unfulfilled Conditions: metadata, has_regular_style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> According Google Fonts standards, families should have a Regular style.</summary>

* [com.google.fonts/check/090](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/090)
* :zzz: **SKIP** Unfulfilled Conditions: metadata

</details>
<br>
</details>
<details>
<summary><b>[109] WorkSans-VF.ttf</b></summary>
<details>
<summary>:broken_heart: <b>ERROR:</b> Checking with Microsoft Font Validator.</summary>

* [com.google.fonts/check/037](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/037)
* :broken_heart: **ERROR** Mono runtime and/or Microsoft Font Validator are not available!
* :broken_heart: **ERROR** Failed with OSError: [Errno 2] No such file or directory

</details>
<details>
<summary>:fire: <b>FAIL:</b> Check a static ttf can be generated from a variable font.</summary>

* [com.google.fonts/check/174](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/174)
* :fire: **FAIL** fontTools.varLib.mutator failed to generated a static font instance
AssertionError()

</details>
<details>
<summary>:fire: <b>FAIL:</b> Checking file is named canonically.</summary>

* [com.google.fonts/check/001](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/001)
* :fire: **FAIL** Style name used in "WorkSans-VF.ttf" is not canonical. You should rebuild the font using any of the following style names: "Thin", "ExtraLight", "Light", "Regular", "Medium", "SemiBold", "Bold", "ExtraBold", "Black", "Thin Italic", "ExtraLight Italic", "Light Italic", "Italic", "Medium Italic", "SemiBold Italic", "Bold Italic", "ExtraBold Italic", "Black Italic".

</details>
<details>
<summary>:warning: <b>WARN:</b> Checking OS/2 achVendID.</summary>

* [com.google.fonts/check/018](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/018)
* :warning: **WARN** OS/2 VendorID value 'WEI ' is not a known registered id. You should set it to your own 4 character code, and register that code with Microsoft at https://www.microsoft.com/typography/links/vendorlist.aspx [code: unknown]

</details>
<details>
<summary>:warning: <b>WARN:</b> Check if each glyph has the recommended amount of contours.</summary>

* [com.google.fonts/check/153](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/153)
* :warning: **WARN** This check inspects the glyph outlines and detects the total number of counters in each of them. The expected values are infered from the typical ammounts of counters observed in a large collection of reference font families. The divergences listed below may simply indicate a significantly different design on some of your glyphs. On the other hand, some of these may flag actual bugs in the font such as glyphs mapped to an incorrect codepoint. Please consider reviewing the design and codepoint assignment of these to make sure they are correct.

The following glyphs do not have the recommended number of contours:

Glyph name: numbersign	Counters detected: 4	Expected: 2
Glyph name: dollar	Counters detected: 2	Expected: 1 or 3
Glyph name: asterisk	Counters detected: 5	Expected: 1 or 4
Glyph name: plus	Counters detected: 2	Expected: 1
Glyph name: H	Counters detected: 3	Expected: 1
Glyph name: K	Counters detected: 3	Expected: 1 or 2
Glyph name: Q	Counters detected: 3	Expected: 2
Glyph name: R	Counters detected: 3	Expected: 1 or 2
Glyph name: a	Counters detected: 1	Expected: 2
Glyph name: e	Counters detected: 1	Expected: 2
Glyph name: f	Counters detected: 2	Expected: 1
Glyph name: g	Counters detected: 5	Expected: 2 or 3
Glyph name: k	Counters detected: 3	Expected: 1 or 2
Glyph name: uni207A	Counters detected: 2	Expected: 1
Glyph name: uni208A	Counters detected: 2	Expected: 1
Glyph name: currency	Counters detected: 6	Expected: 2
Glyph name: uni20A6	Counters detected: 2	Expected: 1, 3 or 5
Glyph name: uni20A9	Counters detected: 2	Expected: 1, 3, 4 or 7
Glyph name: Euro	Counters detected: 3	Expected: 1 or 2
Glyph name: registered	Counters detected: 5	Expected: 3 or 4
Glyph name: plusminus	Counters detected: 3	Expected: 1 or 2
Glyph name: uni20BA	Counters detected: 3	Expected: 1
Glyph name: uni20BC	Counters detected: 2	Expected: 1
Glyph name: Eth	Counters detected: 3	Expected: 2
Glyph name: multiply	Counters detected: 2	Expected: 1
Glyph name: Oslash	Counters detected: 5	Expected: 3
Glyph name: agrave	Counters detected: 2	Expected: 3
Glyph name: aacute	Counters detected: 2	Expected: 3
Glyph name: acircumflex	Counters detected: 2	Expected: 3
Glyph name: atilde	Counters detected: 2	Expected: 3
Glyph name: adieresis	Counters detected: 3	Expected: 4
Glyph name: aring	Counters detected: 3	Expected: 4
Glyph name: egrave	Counters detected: 2	Expected: 3
Glyph name: eacute	Counters detected: 2	Expected: 3
Glyph name: ecircumflex	Counters detected: 2	Expected: 3
Glyph name: edieresis	Counters detected: 3	Expected: 4
Glyph name: eth	Counters detected: 4	Expected: 2
Glyph name: uni2199	Counters detected: 2	Expected: 1
Glyph name: amacron	Counters detected: 2	Expected: 3
Glyph name: abreve	Counters detected: 2	Expected: 3
Glyph name: Dcroat	Counters detected: 3	Expected: 2
Glyph name: dcroat	Counters detected: 3	Expected: 2
Glyph name: uni2113	Counters detected: 1	Expected: 2
Glyph name: ebreve	Counters detected: 2	Expected: 3
Glyph name: edotaccent	Counters detected: 2	Expected: 3
Glyph name: ecaron	Counters detected: 2	Expected: 3
Glyph name: gcircumflex	Counters detected: 6	Expected: 3 or 4
Glyph name: gbreve	Counters detected: 6	Expected: 3 or 4
Glyph name: gdotaccent	Counters detected: 6	Expected: 3 or 4
Glyph name: uni0123	Counters detected: 6	Expected: 3 or 4
Glyph name: Hcircumflex	Counters detected: 4	Expected: 2
Glyph name: hbar	Counters detected: 2	Expected: 1
Glyph name: uni0136	Counters detected: 4	Expected: 2 or 3
Glyph name: uni0137	Counters detected: 4	Expected: 2 or 3
Glyph name: kgreenlandic	Counters detected: 3	Expected: 1 or 2
Glyph name: Lslash	Counters detected: 2	Expected: 1
Glyph name: lslash	Counters detected: 2	Expected: 1
Glyph name: eng	Counters detected: 2	Expected: 1
Glyph name: uni0156	Counters detected: 4	Expected: 3
Glyph name: Rcaron	Counters detected: 4	Expected: 3
Glyph name: uni0163	Counters detected: 3	Expected: 1 or 2
Glyph name: tcaron	Counters detected: 3	Expected: 2
Glyph name: Tbar	Counters detected: 2	Expected: 1
Glyph name: tbar	Counters detected: 3	Expected: 1
Glyph name: Uogonek	Counters detected: 2	Expected: 1
Glyph name: uogonek	Counters detected: 2	Expected: 1
Glyph name: uni018F	Counters detected: 1	Expected: 2
Glyph name: arrowleft	Counters detected: 2	Expected: 1
Glyph name: arrowup	Counters detected: 2	Expected: 1
Glyph name: arrowright	Counters detected: 2	Expected: 1
Glyph name: arrowdown	Counters detected: 2	Expected: 1
Glyph name: arrowboth	Counters detected: 3	Expected: 1
Glyph name: arrowupdn	Counters detected: 3	Expected: 1
Glyph name: uni2196	Counters detected: 2	Expected: 1
Glyph name: uni2197	Counters detected: 2	Expected: 1
Glyph name: uni2198	Counters detected: 2	Expected: 1
Glyph name: ohorn	Counters detected: 3	Expected: 2
Glyph name: Uhorn	Counters detected: 2	Expected: 1
Glyph name: uhorn	Counters detected: 2	Expected: 1
Glyph name: uni21BA	Counters detected: 2	Expected: 1
Glyph name: gcaron	Counters detected: 6	Expected: 3 or 4
Glyph name: uni01EA	Counters detected: 3	Expected: 2
Glyph name: uni01EB	Counters detected: 3	Expected: 2
Glyph name: Oslashacute	Counters detected: 6	Expected: 4
Glyph name: uni0201	Counters detected: 3	Expected: 4
Glyph name: uni0203	Counters detected: 2	Expected: 3
Glyph name: uni0205	Counters detected: 3	Expected: 4
Glyph name: uni0207	Counters detected: 2	Expected: 3
Glyph name: uni0210	Counters detected: 5	Expected: 4
Glyph name: uni021B	Counters detected: 3	Expected: 2
Glyph name: infinity	Counters detected: 2	Expected: 3
Glyph name: uni0259	Counters detected: 1	Expected: 2
Glyph name: notequal	Counters detected: 3	Expected: 1
Glyph name: fl	Counters detected: 3	Expected: 1 or 2
Glyph name: x	Counters detected: 2	Expected: 1
Glyph name: colonmonetary	Counters detected: 7	Expected: 1 or 3
Glyph name: lira	Counters detected: 3	Expected: 1
Glyph name: logicalnot	Counters detected: 2	Expected: 1
Glyph name: partialdiff	Counters detected: 1	Expected: 2
Glyph name: t	Counters detected: 2	Expected: 1
Glyph name: product	Counters detected: 3	Expected: 1
Glyph name: uni0212	Counters detected: 4	Expected: 3
Glyph name: lozenge	Counters detected: 4	Expected: 2
Glyph name: uni1E08	Counters detected: 3	Expected: 2
Glyph name: uni1E09	Counters detected: 3	Expected: 2
Glyph name: uni1E15	Counters detected: 3	Expected: 4
Glyph name: uni1E17	Counters detected: 3	Expected: 4
Glyph name: uni1E1C	Counters detected: 3	Expected: 2
Glyph name: uni1E21	Counters detected: 6	Expected: 3 or 4
Glyph name: uni1E24	Counters detected: 4	Expected: 2
Glyph name: uni1E2A	Counters detected: 4	Expected: 2
Glyph name: fi	Counters detected: 4	Expected: 1, 2 or 3
Glyph name: uni1E5A	Counters detected: 4	Expected: 3
Glyph name: uni1E5E	Counters detected: 4	Expected: 3
Glyph name: uni1E6D	Counters detected: 3	Expected: 2
Glyph name: uni1E6F	Counters detected: 3	Expected: 2
Glyph name: emacron	Counters detected: 2	Expected: 3
Glyph name: uni1E97	Counters detected: 4	Expected: 3
Glyph name: uni1EA1	Counters detected: 2	Expected: 3
Glyph name: uni1EA3	Counters detected: 2	Expected: 3
Glyph name: uni1EA5	Counters detected: 3	Expected: 4
Glyph name: uni1EA9	Counters detected: 3	Expected: 4
Glyph name: uni1EAB	Counters detected: 3	Expected: 4
Glyph name: uni1EAD	Counters detected: 3	Expected: 4
Glyph name: uni1EAF	Counters detected: 3	Expected: 4
Glyph name: uni1EB1	Counters detected: 3	Expected: 4
Glyph name: uni1EB3	Counters detected: 3	Expected: 4
Glyph name: uni1EB5	Counters detected: 3	Expected: 4
Glyph name: uni1EB7	Counters detected: 3	Expected: 4
Glyph name: uni1EB9	Counters detected: 2	Expected: 3
Glyph name: uni1EBB	Counters detected: 2	Expected: 3
Glyph name: uni1EBD	Counters detected: 2	Expected: 3
Glyph name: uni1EBF	Counters detected: 3	Expected: 4
Glyph name: uni1EC1	Counters detected: 3	Expected: 4
Glyph name: uni1EC3	Counters detected: 3	Expected: 4
Glyph name: uni1EC5	Counters detected: 3	Expected: 4
Glyph name: uni1EC7	Counters detected: 3	Expected: 4
Glyph name: uni1EDB	Counters detected: 4	Expected: 3
Glyph name: uni1EDD	Counters detected: 4	Expected: 3
Glyph name: uni1EDF	Counters detected: 4	Expected: 3
Glyph name: uni1EE1	Counters detected: 4	Expected: 3
Glyph name: uni1EE3	Counters detected: 4	Expected: 3
Glyph name: Hbar	Counters detected: 4	Expected: 2
Glyph name: uni1EE8	Counters detected: 3	Expected: 2
Glyph name: uni1EE9	Counters detected: 3	Expected: 2
Glyph name: uni1EEA	Counters detected: 3	Expected: 2
Glyph name: uni1EEB	Counters detected: 3	Expected: 2
Glyph name: uni1EEC	Counters detected: 3	Expected: 2
Glyph name: uni1EED	Counters detected: 3	Expected: 2
Glyph name: uni1EEE	Counters detected: 3	Expected: 2
Glyph name: uni1EEF	Counters detected: 3	Expected: 2
Glyph name: uni1EF0	Counters detected: 3	Expected: 2
Glyph name: uni1EF1	Counters detected: 3	Expected: 2
Glyph name: florin	Counters detected: 2	Expected: 1
Glyph name: trademark	Counters detected: 3	Expected: 2
Glyph name: uni275D	Counters detected: 2	Expected: 1
Glyph name: uni275E	Counters detected: 2	Expected: 1
Glyph name: uni2761	Counters detected: 3	Expected: 2
Glyph name: uni1EA7	Counters detected: 3	Expected: 4
Glyph name: oe	Counters detected: 2	Expected: 3
Glyph name: Racute	Counters detected: 4	Expected: 3

</details>
<details>
<summary>:warning: <b>WARN:</b> Check if OS/2 xAvgCharWidth is correct.</summary>

* [com.google.fonts/check/034](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/034)
* :warning: **WARN** OS/2 xAvgCharWidth is 599 but should be 597 which corresponds to the weighted average of the widths of the latin lowercase glyphs in the font. These are similar values, which may be a symptom of the slightly different calculation of the xAvgCharWidth value in font editors. There's further discussion on this at https://github.com/googlefonts/fontbakery/issues/1622

</details>
<details>
<summary>:warning: <b>WARN:</b> Is there kerning info for non-ligated sequences?</summary>

* [com.google.fonts/check/065](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/065)
* :warning: **WARN** GPOS table lacks kerning info for the following non-ligated sequences: [u'c_h', u'c_t', u'Iacute_J', u'f_f', u'f_i', u'f_l', u'N_o', u's_t', u'T_h', u'parenleft.case_eight', u'parenleft.case_five', u'parenleft.case_four', u'parenleft.case_nine', u'parenleft.case_one', u'parenleft.case_seven', u'parenleft.case_six', u'parenleft.case_three', u'parenleft.case_two', u'parenleft_eight', u'parenleft_eight.osf', u'parenleft_eight.tf', u'parenleft_eight.tosf', u'parenleft_five', u'parenleft_five.osf', u'parenleft_five.tf', u'parenleft_five.tosf', u'parenleft_four', u'parenleft_four.osf', u'parenleft_four.tf', u'parenleft_four.tosf', u'parenleft_nine', u'parenleft_nine.osf', u'parenleft_nine.tf', u'parenleft_nine.tosf', u'parenleft_one', u'parenleft_one.osf', u'parenleft_one.tf', u'parenleft_one.tosf', u'parenleft_seven', u'parenleft_seven.osf', u'parenleft_seven.tf', u'parenleft_seven.tosf', u'parenleft_six', u'parenleft_six.osf', u'parenleft_six.tf', u'parenleft_six.tosf', u'parenleft_three', u'parenleft_three.osf', u'parenleft_three.tf', u'parenleft_three.tosf', u'parenleft_two', u'parenleft_two.osf', u'parenleft_two.tf', u'parenleft_two.tosf', u'iacute_j'] [code: lacks-kern-info]

</details>
<details>
<summary>:warning: <b>WARN:</b> Is there a caret position declared for every ligature?</summary>

* [com.google.fonts/check/064](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/064)
* :warning: **WARN** This font lacks caret position values for ligature glyphs on its GDEF table. [code: lacks-caret-pos]

</details>
<details>
<summary>:warning: <b>WARN:</b> Check for points out of bounds.</summary>

* [com.google.fonts/check/075](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/075)
* :warning: **WARN** The following glyphs have coordinates which are out of bounds:
[('uni1ED1', 557.3, 835.8000000000001), ('uni03020301', 257.3, 835.8000000000001), ('uni1EBF.sc', 555.3, 895.8000000000001), ('uni1EA5.ss01', 558.3, 835.8000000000001), ('uni1EBE', 597.3, 995.8000000000001), ('uni1EBF', 548.3, 835.8000000000001), ('uni03020301.case', 257.3, 995.8000000000001)]
This happens a lot when points are not extremes, which is usually bad. However, fixing this alert by adding points on extremes may do more harm than good, especially with italics, calligraphic-script, handwriting, rounded and other fonts. So it is common to ignore this message

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check if fontname is not camel cased.</summary>

* [com.google.fonts/check/109](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/109)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.name and font.full_name fields match the values declared on the name table?</summary>

* [com.google.fonts/check/108](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/108)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.style "normal" matches font internals?</summary>

* [com.google.fonts/check/107](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/107)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.style "italic" matches font internals?</summary>

* [com.google.fonts/check/106](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/106)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Filename is set canonically in METADATA.pb?</summary>

* [com.google.fonts/check/105](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/105)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata, canonical_filename

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Copyright notice shouldn't exceed 500 chars.</summary>

* [com.google.fonts/check/104](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/104)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Copyright notice on METADATA.pb does not contain Reserved Font Name?</summary>

* [com.google.fonts/check/103](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/103)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Copyright notice on METADATA.pb matches canonical pattern?</summary>

* [com.google.fonts/check/102](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/102)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.filename field contains font name in right format?</summary>

* [com.google.fonts/check/100](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/100)
* :zzz: **SKIP** Unfulfilled Conditions: style, font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.post_script_name field contains font name in right format?</summary>

* [com.google.fonts/check/101](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/101)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> TTFAutohint x-height increase value is same as in previous release on Google Fonts?</summary>

* [com.google.fonts/check/119](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/119)
* :zzz: **SKIP** Unfulfilled Conditions: api_gfonts_ttFont

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check name table: TYPOGRAPHIC_FAMILY_NAME entries.</summary>

* [com.google.fonts/check/161](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/161)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check name table: POSTSCRIPT_NAME entries.</summary>

* [com.google.fonts/check/160](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/160)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check name table: TYPOGRAPHIC_SUBFAMILY_NAME entries.</summary>

* [com.google.fonts/check/162](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/162)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.full_name field contains font name in right format?</summary>

* [com.google.fonts/check/099](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/099)
* :zzz: **SKIP** Unfulfilled Conditions: style, font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.name field contains font name in right format?</summary>

* [com.google.fonts/check/098](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/098)
* :zzz: **SKIP** Unfulfilled Conditions: style, font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.name value should be same as the family name declared on the name table.</summary>

* [com.google.fonts/check/095](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/095)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata, style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb family.filename and family.post_script_name fields have equivalent values?</summary>

* [com.google.fonts/check/097](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/097)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb family.full_name and family.post_script_name fields have equivalent values ?</summary>

* [com.google.fonts/check/096](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/096)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Checks METADATA.pb font.name field matches family name declared on the name table.</summary>

* [com.google.fonts/check/092](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/092)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check name table: FULL_FONT_NAME entries.</summary>

* [com.google.fonts/check/159](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/159)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check font has same encoded glyphs as version hosted on fonts.google.com</summary>

* [com.google.fonts/check/154](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/154)
* :zzz: **SKIP** Unfulfilled Conditions: api_gfonts_ttFont

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Copyright field for this font on METADATA.pb matches all copyright notice entries on the name table ?</summary>

* [com.google.fonts/check/155](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/155)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check name table: FONT_FAMILY_NAME entries.</summary>

* [com.google.fonts/check/157](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/157)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check copyright namerecords match license file.</summary>

* [com.google.fonts/check/029](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/029)
* :zzz: **SKIP** Unfulfilled Conditions: license

</details>
<details>
<summary>:zzz: <b>SKIP:</b> METADATA.pb font.fullname value matches fullname declared on the name table?</summary>

* [com.google.fonts/check/094](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/094)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Checks METADATA.pb font.post_script_name matches postscript name declared on the name table.</summary>

* [com.google.fonts/check/093](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/093)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Checking head.macStyle value.</summary>

* [com.google.fonts/check/131](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/131)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check that font weight has a canonical value.</summary>

* [com.google.fonts/check/111](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/111)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check name table: FONT_SUBFAMILY_NAME entries.</summary>

* [com.google.fonts/check/158](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/158)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Checking OS/2 fsSelection value.</summary>

* [com.google.fonts/check/129](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/129)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Glyphs are similiar to Google Fonts version?</summary>

* [com.google.fonts/check/118](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/118)
* :zzz: **SKIP** Unfulfilled Conditions: api_gfonts_ttFont

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Check font name is the same as family name.</summary>

* [com.google.fonts/check/110](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/110)
* :zzz: **SKIP** Unfulfilled Conditions: metadata, font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Checking OS/2 usWeightClass matches weight specified at METADATA.pb.</summary>

* [com.google.fonts/check/112](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/112)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Metadata weight matches postScriptName.</summary>

* [com.google.fonts/check/113](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/113)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Font styles are named canonically?</summary>

* [com.google.fonts/check/115](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/115)
* :zzz: **SKIP** Unfulfilled Conditions: font_metadata

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Version number has increased since previous release on Google Fonts?</summary>

* [com.google.fonts/check/117](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/117)
* :zzz: **SKIP** Unfulfilled Conditions: api_gfonts_ttFont, github_gfonts_ttFont

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Checking post.italicAngle value.</summary>

* [com.google.fonts/check/130](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/130)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Font has all mandatory 'name' table entries ?</summary>

* [com.google.fonts/check/156](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/156)
* :zzz: **SKIP** Unfulfilled Conditions: style

</details>
<details>
<summary>:zzz: <b>SKIP:</b> FontForge checks.</summary>

* [com.google.fonts/check/039](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/039)
* :zzz: **SKIP** Unfulfilled Conditions: fontforge_check_results

</details>
<details>
<summary>:zzz: <b>SKIP:</b> FontForge validation outputs error messages?</summary>

* [com.google.fonts/check/038](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/038)
* :zzz: **SKIP** Unfulfilled Conditions: fontforge_check_results

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Checking OS/2 usWeightClass.</summary>

* [com.google.fonts/check/020](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/020)
* :zzz: **SKIP** Unfulfilled Conditions: expected_os2_weight

</details>
<details>
<summary>:zzz: <b>SKIP:</b> Monospace font has hhea.advanceWidthMax equal to each glyph's advanceWidth?</summary>

* [com.google.fonts/check/079](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/079)
* :zzz: **SKIP** Unfulfilled Conditions: seems_monospaced

</details>
<details>
<summary>:zzz: <b>SKIP:</b> The variable font 'ital' (Italic) axis coordinate must be zero on the 'Regular' instance.</summary>

* [com.google.fonts/check/170](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/170)
* :zzz: **SKIP** Unfulfilled Conditions: regular_ital_coord

</details>
<details>
<summary>:zzz: <b>SKIP:</b> The variable font 'wdth' (Width) axis coordinate must be 100 on the 'Regular' instance.</summary>

* [com.google.fonts/check/168](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/168)
* :zzz: **SKIP** Unfulfilled Conditions: regular_wdth_coord

</details>
<details>
<summary>:zzz: <b>SKIP:</b> The variable font 'slnt' (Slant) axis coordinate must be zero on the 'Regular' instance.</summary>

* [com.google.fonts/check/169](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/169)
* :zzz: **SKIP** Unfulfilled Conditions: regular_slnt_coord

</details>
<details>
<summary>:zzz: <b>SKIP:</b> The variable font 'opsz' (Optical Size) axis coordinate should be between 9 and 13 on the 'Regular' instance.</summary>

* [com.google.fonts/check/171](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/171)
* :zzz: **SKIP** Unfulfilled Conditions: regular_opsz_coord

</details>
<details>
<summary>:information_source: <b>INFO:</b> EPAR table present in font?</summary>

* [com.google.fonts/check/061](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/061)
* :information_source: **INFO** EPAR table not present in font. To learn more see https://github.com/googlefonts/fontbakery/issues/818

</details>
<details>
<summary>:information_source: <b>INFO:</b> Check for font-v versioning</summary>

* [com.google.fonts/check/166](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/166)
* :information_source: **INFO** Version string is: "Version 2.000"
The version string must ideally include a git commit hash and either a 'dev' or a 'release' suffix such as in the example below:
"Version 1.3; git-0d08353-release"

</details>
<details>
<summary>:information_source: <b>INFO:</b> Show hinting filesize impact.</summary>

* [com.google.fonts/check/054](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/054)
* :information_source: **INFO** Hinting filesize impact:

|  | WorkSans-VF.ttf |
|:--- | ---:|
| Dehinted Size | 327.7kb |
| Hinted Size | 327.0kb |
| Increase | -780 bytes |
| Change   | -0.0 % |


</details>
<details>
<summary>:information_source: <b>INFO:</b> Font has old ttfautohint applied?</summary>

* [com.google.fonts/check/056](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/056)
* :information_source: **INFO** Could not detect which version of ttfautohint was used in this font. It is typically specified as a comment in the font version entries of the 'name' table. Such font version strings are currently: [u'Version 2.000']

</details>
<details>
<summary>:information_source: <b>INFO:</b> Font contains all required tables?</summary>

* [com.google.fonts/check/052](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/052)
* :information_source: **INFO** This font contains the following optional tables [DSIG, gasp, loca, GSUB, GPOS, prep]
* :bread: **PASS** Font contains all required tables.

</details>
<details>
<summary>:bread: <b>PASS:</b> Make sure family name does not begin with a digit.</summary>

* [com.google.fonts/check/067](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/067)
* :bread: **PASS** Font family name first character is not a digit.

</details>
<details>
<summary>:bread: <b>PASS:</b> Is 'gasp' table set to optimize rendering?</summary>

* [com.google.fonts/check/062](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/062)
* :bread: **PASS** 'gasp' table is correctly set, with one gaspRange:value of 0xFFFF:0x0F.

</details>
<details>
<summary>:bread: <b>PASS:</b> Familyname must be unique according to namecheck.fontdata.com</summary>

* [com.google.fonts/check/165](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/165)
* :bread: **PASS** Font familyname seems to be unique.

</details>
<details>
<summary>:bread: <b>PASS:</b> Font has all expected currency sign characters?</summary>

* [com.google.fonts/check/070](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/070)
* :bread: **PASS** Font has all expected currency sign characters.

</details>
<details>
<summary>:bread: <b>PASS:</b> Are there non-ASCII characters in ASCII-only NAME table entries?</summary>

* [com.google.fonts/check/074](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/074)
* :bread: **PASS** None of the ASCII-only NAME table entries contain non-ASCII characteres.

</details>
<details>
<summary>:bread: <b>PASS:</b> Length of copyright notice must not exceed 500 characters.</summary>

* [com.google.fonts/check/164](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/164)
* :bread: **PASS** All copyright notice name entries on the 'name' table are shorter than 500 characters.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking OS/2 fsType.</summary>

* [com.google.fonts/check/016](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/016)
* :bread: **PASS** OS/2 fsType is properly set to zero (80's DRM scheme is disabled).

</details>
<details>
<summary>:bread: <b>PASS:</b> Fonts have equal numbers of glyphs?</summary>

* [com.google.fonts/check/011](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/011)
* :bread: **PASS** All font files in this family have an equal total ammount of glyphs.

</details>
<details>
<summary>:bread: <b>PASS:</b> Fonts have equal glyph names?</summary>

* [com.google.fonts/check/012](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/012)
* :bread: **PASS** All font files have identical glyph names.

</details>
<details>
<summary>:bread: <b>PASS:</b> Substitute copyright, registered and trademark symbols in name table entries.</summary>

* [com.google.fonts/check/019](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/019)
* :bread: **PASS** No need to substitute copyright, registered and trademark symbols in name table entries of this font.

</details>
<details>
<summary>:bread: <b>PASS:</b> "License URL matches License text on name table?</summary>

* [com.google.fonts/check/030](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/030)
* :bread: **PASS** Font has a valid license URL in NAME table.

</details>
<details>
<summary>:bread: <b>PASS:</b> Is font em size (ideally) equal to 1000?</summary>

* [com.google.fonts/check/116](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/116)
* :bread: **PASS** Font em size is equal to 1000.

</details>
<details>
<summary>:bread: <b>PASS:</b> Version format is correct in 'name' table?</summary>

* [com.google.fonts/check/055](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/055)
* :bread: **PASS** Version format in NAME table entries is correct.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking with ftxvalidator.</summary>

* [com.google.fonts/check/035](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/035)
* :bread: **PASS** ftxvalidator passed this file

</details>
<details>
<summary>:bread: <b>PASS:</b> Font has **proper** whitespace glyph names?</summary>

* [com.google.fonts/check/048](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/048)
* :bread: **PASS** Font has **proper** whitespace glyph names.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking with ots-sanitize.</summary>

* [com.google.fonts/check/036](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/036)
* :bread: **PASS** ots-sanitize passed this file

</details>
<details>
<summary>:bread: <b>PASS:</b> Font contains the first few mandatory glyphs (.null or NULL, CR and space)?</summary>

* [com.google.fonts/check/046](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/046)
* :bread: **PASS** Font contains the first few mandatory glyphs (.null or NULL, CR and space).

</details>
<details>
<summary>:bread: <b>PASS:</b> Are there unwanted tables?</summary>

* [com.google.fonts/check/053](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/053)
* :bread: **PASS** There are no unwanted tables.

</details>
<details>
<summary>:bread: <b>PASS:</b> Font contains glyphs for whitespace characters?</summary>

* [com.google.fonts/check/047](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/047)
* :bread: **PASS** Font contains glyphs for whitespace characters.

</details>
<details>
<summary>:bread: <b>PASS:</b> Font contains unique glyph names?</summary>

* [com.google.fonts/check/059](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/059)
* :bread: **PASS** Font contains unique glyph names.

</details>
<details>
<summary>:bread: <b>PASS:</b> Glyph names are all valid?</summary>

* [com.google.fonts/check/058](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/058)
* :bread: **PASS** Glyph names are all valid.

</details>
<details>
<summary>:bread: <b>PASS:</b> Whitespace glyphs have ink?</summary>

* [com.google.fonts/check/049](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/049)
* :bread: **PASS** There is no whitespace glyph with ink.

</details>
<details>
<summary>:bread: <b>PASS:</b> Check all glyphs have codepoints assigned.</summary>

* [com.google.fonts/check/077](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/077)
* :bread: **PASS** All glyphs have a codepoint value assigned.

</details>
<details>
<summary>:bread: <b>PASS:</b> Check glyphs have unique unicode codepoints.</summary>

* [com.google.fonts/check/076](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/076)
* :bread: **PASS** All glyphs have unique unicode codepoint assignments.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking font version fields (head and name table).</summary>

* [com.google.fonts/check/044](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/044)
* :bread: **PASS** All font version fields match.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking unitsPerEm value is reasonable.</summary>

* [com.google.fonts/check/043](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/043)
* :bread: **PASS** unitsPerEm value on the 'head' table is reasonable.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking OS/2 Metrics match hhea Metrics.</summary>

* [com.google.fonts/check/042](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/042)
* :bread: **PASS** OS/2.sTypoAscender/Descender match hhea.ascent/descent.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking OS/2 usWinAscent & usWinDescent.</summary>

* [com.google.fonts/check/040](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/040)
* :bread: **PASS** OS/2 usWinAscent & usWinDescent values look good!

</details>
<details>
<summary>:bread: <b>PASS:</b> Font has correct post table version (2 for TTF, 3 for OTF)?</summary>

* [com.google.fonts/check/015](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/015)
* :bread: **PASS** Font has post table version 2.

</details>
<details>
<summary>:bread: <b>PASS:</b> Font follows the family naming recommendations?</summary>

* [com.google.fonts/check/071](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/071)
* :bread: **PASS** Font follows the family naming recommendations.

</details>
<details>
<summary>:bread: <b>PASS:</b> Does full font name begin with the font family name?</summary>

* [com.google.fonts/check/068](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/068)
* :bread: **PASS** Full font name begins with the font family name.

</details>
<details>
<summary>:bread: <b>PASS:</b> Combined length of family and style must not exceed 20 characters.</summary>

* [com.google.fonts/check/163](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/163)
* :bread: **PASS** All name entries are good.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking correctness of monospaced metadata.</summary>

* [com.google.fonts/check/033](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/033)
* :bread: **PASS** Font is not monospaced and all related metadata look good. [code: good]

</details>
<details>
<summary>:bread: <b>PASS:</b> Description strings in the name table must not exceed 100 characters.</summary>

* [com.google.fonts/check/032](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/032)
* :bread: **PASS** Description name records do not exceed 100 characters.

</details>
<details>
<summary>:bread: <b>PASS:</b> Description strings in the name table must not contain copyright info.</summary>

* [com.google.fonts/check/031](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/031)
* :bread: **PASS** Description strings in the name table do not contain any copyright string.

</details>
<details>
<summary>:bread: <b>PASS:</b> Name table strings must not contain the string 'Reserved Font Name'.</summary>

* [com.google.fonts/check/152](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/152)
* :bread: **PASS** None of the name table strings contain "Reserved Font Name".

</details>
<details>
<summary>:bread: <b>PASS:</b> Name table entries should not contain line-breaks.</summary>

* [com.google.fonts/check/057](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/057)
* :bread: **PASS** Name table entries are all single-line (no line-breaks found).

</details>
<details>
<summary>:bread: <b>PASS:</b> MaxAdvanceWidth is consistent with values in the Hmtx and Hhea tables?</summary>

* [com.google.fonts/check/073](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/073)
* :bread: **PASS** MaxAdvanceWidth is consistent with values in the Hmtx and Hhea tables.

</details>
<details>
<summary>:bread: <b>PASS:</b> Checking Vertical Metric Linegaps.</summary>

* [com.google.fonts/check/041](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/041)
* :bread: **PASS** OS/2 sTypoLineGap and hhea lineGap are both 0.

</details>
<details>
<summary>:bread: <b>PASS:</b> Does the font have a DSIG table?</summary>

* [com.google.fonts/check/045](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/045)
* :bread: **PASS** Digital Signature (DSIG) exists.

</details>
<details>
<summary>:bread: <b>PASS:</b> Whitespace and non-breaking space have the same width?</summary>

* [com.google.fonts/check/050](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/050)
* :bread: **PASS** Whitespace and non-breaking space have the same width.

</details>
<details>
<summary>:bread: <b>PASS:</b> Does GPOS table have kerning information?</summary>

* [com.google.fonts/check/063](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/063)
* :bread: **PASS** GPOS table has got kerning information.

</details>
<details>
<summary>:bread: <b>PASS:</b> Is there a "kern" table declared in the font?</summary>

* [com.google.fonts/check/066](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/066)
* :bread: **PASS** Font does not declare an optional "kern" table.

</details>
<details>
<summary>:bread: <b>PASS:</b> Is there any unused data at the end of the glyf table?</summary>

* [com.google.fonts/check/069](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/069)
* :bread: **PASS** There is no unused data at the end of the glyf table.

</details>
<details>
<summary>:bread: <b>PASS:</b> Font enables smart dropout control in "prep" table instructions?</summary>

* [com.google.fonts/check/072](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/072)
* :bread: **PASS** Program at 'prep' table contains instructions enabling smart dropout control.

</details>
<details>
<summary>:bread: <b>PASS:</b> The variable font 'wght' (Weight) axis coordinate must be 700 on the 'Bold' instance.</summary>

* [com.google.fonts/check/172](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/172)
* :bread: **PASS** Bold:wght is 700.

</details>
<details>
<summary>:bread: <b>PASS:</b> The variable font 'wght' (Weight) axis coordinate must be 400 on the 'Regular' instance.</summary>

* [com.google.fonts/check/167](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/167)
* :bread: **PASS** Regular:wght is 400.

</details>
<details>
<summary>:bread: <b>PASS:</b> Does the number of glyphs in the loca table match the maxp table?</summary>

* [com.google.fonts/check/180](https://github.com/googlefonts/fontbakery/search?q=com.google.fonts/check/180)
* :bread: **PASS** 'loca' table matches numGlyphs in 'maxp' table.

</details>
<br>
</details>

### Summary

| :broken_heart: ERROR | :fire: FAIL | :warning: WARN | :zzz: SKIP | :information_source: INFO | :bread: PASS |
|:-----:|:----:|:----:|:----:|:----:|:----:|
| 1 | 3 | 6 | 63 | 5 | 54 |
| 1% | 2% | 5% | 48% | 4% | 41% |
