<?php
/**
 * [WeEngine System] Copyright (c) 2014 W7.CC
 * $sn$
 */
defined('IN_IA') or exit('Access Denied');

/**
 * 构建管理员或操作员权限数据
 * @return array|mixed
 */
function permission_build() {
	global $_W, $acl;
	load()->model('system');
	$w7_file_permission = $acl;
	$permission_frames = system_menu();
	if (!in_array($_W['role'], array(ACCOUNT_MANAGE_NAME_OPERATOR, ACCOUNT_MANAGE_NAME_MANAGER)) || empty($_W['uniacid'])) {
		return $w7_file_permission;
	}

	$cachekey = cache_system_key('permission', array('uniacid' => $_W['uniacid'], 'uid' => $_W['uid']));
	$cache = cache_load($cachekey);

	if (!empty($cache)) {
		return $cache;
	}
	$permission_exist = permission_account_user_permission_exist($_W['uid'], $_W['uniacid']);
	if (empty($permission_exist)) {
		cache_write($cachekey, $w7_file_permission);
		return $w7_file_permission;
	}
	$user_account_permission = permission_account_user_menu($_W['uid'], $_W['uniacid'], PERMISSION_ACCOUNT);
	$user_wxapp_permission = permission_account_user_menu($_W['uid'], $_W['uniacid'], PERMISSION_WXAPP);
	$account_info = uni_fetch($_W['uniacid']);
	$user_other_permission = permission_account_user_menu($_W['uid'], $_W['uniacid'], $account_info->typeSign);
	$user_permission = array_merge($user_account_permission, $user_wxapp_permission, $user_other_permission);

	$permission_contain = array('account', 'wxapp', 'system', 'phoneapp');
	$section = array();
	$permission_result = array();
	foreach ($permission_frames as $key => $frames) {
		if (!in_array($key, $permission_contain) || empty($frames['section'])) {
			continue;
		}
		foreach ($frames['section'] as $frame_key => $frame) {
			if (empty($frame['menu'])) {
				continue;
			}
			$section[$key][$frame_key] = $frame['menu'];
		}
	}
	$account = permission_get_nameandurl($section[$permission_contain[0]]);
	$wxapp = permission_get_nameandurl($section[$permission_contain[1]]);
	$system = permission_get_nameandurl($section[$permission_contain[2]]);
	$permission_result = array_merge($account, $wxapp, $system);

	foreach ($permission_result as $permission_val) {
		if (in_array($permission_val['permission_name'], $user_permission)) {
			$w7_file_permission[$permission_val['controller']][$_W['role']][] = $permission_val['action'];
		}
	}
	cache_write($cachekey, $w7_file_permission);
	return $w7_file_permission;
}

/**
 * @return array()
 */
function permission_get_nameandurl($permission) {
	$result = array();
	if (empty($permission)) {
		return $result;
	}
	foreach ($permission as $menu) {
		if (empty($menu)) {
			continue;
		}
		foreach ($menu as $permission_name) {
			$url_query_array = url_params($permission_name['url']);
			$result[] = array(
				'url' => $permission_name['url'],
				'controller' => $url_query_array['c'],
				'action' => $url_query_array['a'],
				'permission_name' => $permission_name['permission_name']
			);
			if (!empty($permission_name['sub_permission'])) {
				foreach ($permission_name['sub_permission'] as $key => $sub_permission_name) {
					$sub_url_query_array = url_params($sub_permission_name['url']);
					$result[] = array(
						'url' => $sub_permission_name['url'],
						'controller' => $sub_url_query_array['c'],
						'action' => $sub_url_query_array['a'],
						'permission_name' => $sub_permission_name['permission_name'],
					);
				}
			}
		}
	}
	return $result;
}

/**
 * 获取指定操作用户在指定的公众号所具有的操作权限
 * @param int $uid 操作用户
 * @param int $uniacid 指定统一公众号
 * @return string 操作用户的 role (manager|operator)
 */
function permission_account_user_role($uid = 0, $uniacid = 0) {
	global $_W;
	load()->model('user');
	$role = '';
	$uid = empty($uid) ? $_W['uid'] : intval($uid);

	if (user_is_founder($uid, true)) {
		return ACCOUNT_MANAGE_NAME_FOUNDER;
	} else {
		$user_info = pdo_get('users', array('uid' => $uid));
		if (!empty($user_info['endtime']) && $user_info['endtime'] != USER_ENDTIME_GROUP_EMPTY_TYPE && $user_info['endtime'] != USER_ENDTIME_GROUP_UNLIMIT_TYPE && $user_info['endtime'] < TIMESTAMP) {
			return ACCOUNT_MANAGE_NAME_EXPIRED;
		}
		if (!user_is_bind()) {
			return ACCOUNT_MANAGE_NAME_UNBIND_USER;
		}
		if ($user_info['type'] == ACCOUNT_OPERATE_CLERK) {
			return ACCOUNT_MANAGE_NAME_CLERK;
		}
	}

	if (!empty($uniacid)) {
		$role = table('uni_account_users')->getUserRoleByUniacid($uid, $uniacid);
		if ($role == ACCOUNT_MANAGE_NAME_OWNER) {
			$role = ACCOUNT_MANAGE_NAME_OWNER;
		} elseif ($role == ACCOUNT_MANAGE_NAME_VICE_FOUNDER) {
			$role = ACCOUNT_MANAGE_NAME_VICE_FOUNDER;
		} elseif ($role == ACCOUNT_MANAGE_NAME_MANAGER) {
			$role = ACCOUNT_MANAGE_NAME_MANAGER;
		} elseif ($role == ACCOUNT_MANAGE_NAME_OPERATOR) {
			$role = ACCOUNT_MANAGE_NAME_OPERATOR;
		} elseif ($role == ACCOUNT_MANAGE_NAME_CLERK) {
			$role = ACCOUNT_MANAGE_NAME_CLERK;
		}
		return $role;
	} else {
		if (user_is_vice_founder($uid)) {
			return ACCOUNT_MANAGE_NAME_VICE_FOUNDER;
		}
		$roles = table('uni_account_users')->getAllUserRole($uid);
		$roles = array_keys($roles);
		if (in_array(ACCOUNT_MANAGE_NAME_VICE_FOUNDER, $roles)) {
			$role = ACCOUNT_MANAGE_NAME_VICE_FOUNDER;
		} elseif (in_array(ACCOUNT_MANAGE_NAME_OWNER, $roles)) {
			$role = ACCOUNT_MANAGE_NAME_OWNER;
		} elseif (in_array(ACCOUNT_MANAGE_NAME_MANAGER, $roles)) {
			$role = ACCOUNT_MANAGE_NAME_MANAGER;
		} elseif (in_array(ACCOUNT_MANAGE_NAME_OPERATOR, $roles)) {
			$role = ACCOUNT_MANAGE_NAME_OPERATOR;
		}
	}
	$role = empty($role) ? user_is_vice_founder($uid) ? ACCOUNT_MANAGE_NAME_VICE_FOUNDER : ACCOUNT_MANAGE_NAME_OWNER : $role;
	return $role;
}

/**
 * 判断某个用户在某个公众号是否配置过权限清单
 * @param number $uid
 * @param number $uniacid
 * @return boolean
 */
function permission_account_user_permission_exist($uid = 0, $uniacid = 0) {
	global $_W;
	load()->model('user');
	$uid = intval($uid) > 0 ? $uid : $_W['uid'];
	$uniacid = intval($uniacid) > 0 ? $uniacid : $_W['uniacid'];
	if (user_is_founder($uid, true)) {
		return false;
	}
	if (defined('FRAME') && FRAME == 'system') {
		return true;
	}
	$is_exist = table('users_permission')->getUserPermissionByType($uid, $uniacid);
	if(empty($is_exist)) {
		return false;
	} else {
		return true;
	}
}

/**
 * 默认获取当前操作员对于某个公众号的权限
 * $type => 'system' 获取系统菜单权限
 */
function permission_account_user($type = 'system') {
	global $_W;
	$user_permission = table('users_permission')->getUserPermissionByType($_W['uid'], $_W['uniacid'], $type);
	$user_permission = $user_permission['permission'];
	if (empty($user_permission)) {
		$user_permission = array('account*', 'wxapp*', 'phoneapp*');
	}
	$permission_append = frames_menu_append();
	//目前只有系统管理才有预设权限，公众号权限走数据库
	if (!empty($permission_append[$_W['role']])) {
		$user_permission = array_merge($user_permission, $permission_append[$_W['role']]);
	}
	//未分配公众号的新用户用户权限取操作员相同权限
	if (empty($_W['role']) && empty($_W['uniacid'])) {
		$user_permission = array_merge($user_permission, $permission_append['operator']);
	}
	return (array)$user_permission;
}

/**
 * 获取某一用户对某个公众号的菜单操作权限
 * @param int $uid 用户uid
 * @param int $uniacid 公众号uniacid
 * @param string $type 权限类型（公众号、小程序、某一模块、所有模块）
 * @return array
 */
function permission_account_user_menu($uid, $uniacid, $type) {
	$user_menu_permission = array();

	$uid = intval($uid);
	$uniacid = intval($uniacid);
	$type = trim($type);
	if (empty($uid) || empty($uniacid) || empty($type)) {
		return error(-1, '参数错误！');
	}
	$permission_exist = permission_account_user_permission_exist($uid, $uniacid);
	if (empty($permission_exist)) {
		return array('all');
	}
	$user_permission_table = table('users_permission');
	$user_menu_permission = $user_permission_table->getAllUserModulePermission($uid, $uniacid);
	if ($type == 'modules') {
		if ($user_menu_permission['modules'] && $user_menu_permission['modules']['permission'] == 'all') {
			return array('all');
		}
	} else {
		$module = uni_modules_by_uniacid($uniacid);
		$module = array_keys($module);
		if (in_array($type, $module) && $user_menu_permission['modules'] && $user_menu_permission['modules']['permission'] == 'all') {
			return array('all');
		}
		if (in_array($type, $module) || in_array($type, array(PERMISSION_ACCOUNT, PERMISSION_WXAPP, PERMISSION_WEBAPP, PERMISSION_PHONEAPP, PERMISSION_ALIAPP, PERMISSION_BAIDUAPP, PERMISSION_TOUTIAOAPP, PERMISSION_SYSTEM))) {
			$menu_permission = $user_permission_table->getUserPermissionByType($uid, $uniacid, $type);
			$user_menu_permission = !empty($menu_permission['permission']) ? $menu_permission['permission'] : array();
		}
	}

	return $user_menu_permission;
}

/*
 * 获取所有权限的permission_name
 * @return array
 */
function permission_menu_name() {
	load()->model('system');
	$menu_permission = array();

	$menu_list = system_menu_permission_list();
	$middle_menu = array();
	$middle_sub_menu = array();
	if (!empty($menu_list)) {
		foreach ($menu_list as $nav_id => $section) {
			if (empty($section['section'])) {
				continue;
			}
			foreach ($section['section'] as $section_id => $section) {
				if (!empty($section['menu'])) {
					$middle_menu[] = $section['menu'];
				}
			}
		}
	}

	if (!empty($middle_menu)) {
		foreach ($middle_menu as $menu) {
			foreach ($menu as $menu_val) {
				$menu_permission[] = $menu_val['permission_name'];
				if (!empty($menu_val['sub_permission'])) {
					$middle_sub_menu[] = $menu_val['sub_permission'];
				}
			}
		}
	}

	if (!empty($middle_sub_menu)) {
		foreach ($middle_sub_menu as $sub_menu) {
			foreach ($sub_menu as $sub_menu_val) {
				$menu_permission[] = $sub_menu_val['permission_name'];
			}
		}
	}
	return $menu_permission;
}

/*
 * 更新用户对某一公众号的权限（公众号、小程序、系统）
 * @param int $uid 用户uid
 * @param int $uniacid 公众号uniacid
 * @param array $data 要更新的数据
 * @return boolean
 */
function permission_update_account_user($uid, $uniacid, $data) {
	$uid = intval($uid);
	$uniacid = intval($uniacid);
	if (empty($uid) || empty($uniacid) || !in_array($data['type'], array(PERMISSION_ACCOUNT, PERMISSION_WXAPP, PERMISSION_WEBAPP, PERMISSION_PHONEAPP, PERMISSION_ALIAPP, PERMISSION_BAIDUAPP, PERMISSION_TOUTIAOAPP, PERMISSION_SYSTEM))) {
		return error('-1', '参数错误！');
	}
	$user_menu_permission = permission_account_user_menu($uid, $uniacid, $data['type']);
	if (is_error($user_menu_permission)) {
		return error('-1', '参数错误！');
	}
	$permission = table('users_permission')->getUserPermissionByType($uid, $uniacid, $data['type']);
	if (empty($permission)) {
		$result = table('users_permission')->fill(array(
			'uniacid' => $uniacid,
			'uid' => $uid,
			'type' => $data['type'],
			'permission' => $data['permission'],
		))->save();
	}  else {
		$result = table('users_permission')->fill(array('permission' => $data['permission']))->whereId($permission['id'])->save();
	}
	return $result;
}

/*
 * 判断用户是否有某一权限
 * @param string $permission_name 权限名
 * @param boolean $show_message 是否显示错误信息
 * @param string $action
 */

function permission_check_account_user($permission_name, $show_message = true, $action = '') {
	global $_W, $_GPC, $acl;
	load()->model('module');
	$see_more_info = $acl['see_more_info'];

	if (strpos($permission_name, 'see_') === 0) {
		$can_see_more = false;
		if (in_array(FRAME, array('system', 'site', 'myself', 'user_manage', 'permission'))) {
			$can_see_more = in_array($permission_name, $see_more_info[$_W['highest_role']]) ? true : false;
		} else {
			if (is_array($see_more_info[$_W['role']]) && !empty($see_more_info[$_W['role']])) {
				$can_see_more = in_array($permission_name, $see_more_info[$_W['role']]) ? true : false;
			}
		}
		/*用户有上级则不能修改(owner_uid)start*/
		$uniacid = safe_gpc_int($_GPC['uniacid']);
		if(($can_see_more == true && $permission_name == 'see_account_manage_users_edit_vicefounder') || $permission_name == 'see_account_manage_users_add_viceuser') {
			$founder_uid = pdo_getcolumn('uni_account_users', array('uniacid'=>$uniacid, 'role'=>'owner'), 'uid');
			if(empty($founder_uid)) $can_see_more = false;
			$owner_uid = pdo_getcolumn('users', array('uid'=>$founder_uid), 'owner_uid');
			if($owner_uid) $can_see_more = false;
		}
		/*end*/
		return $can_see_more;
	}

	$user_has_permission = permission_account_user_permission_exist();
	if (empty($user_has_permission)) {
		return true;
	}
	$modulename = safe_gpc_string($_GPC['module_name']) ?: safe_gpc_string($_GPC['m']);
	$do = trim($_GPC['do']);
	$entry_id = intval($_GPC['eid']);

	if ($action == 'reply') {
		$system_modules = module_system();
		if (!empty($modulename) && !in_array($modulename, $system_modules)) {
			$permission_name = $modulename . '_rule';
			$users_permission = permission_account_user($modulename);
		}
	} elseif ($action == 'cover' && $entry_id > 0) {
		load()->model('module');
		$entry = module_entry($entry_id);
		if (!empty($entry)) {
			$permission_name = $entry['module'] . '_cover_' . trim($entry['do']);
			$users_permission = permission_account_user($entry['module']);
		}
	} elseif ($action == 'nav') {
		//只对模块的导航进行权限判断，不对微站的导航判断
		if(!empty($modulename)) {
			$permission_name = "{$modulename}_{$do}";
			$users_permission = permission_account_user($modulename);
		} else {
			return true;
		}
	} elseif ($action == 'wxapp' || !empty($_W['account']) && $_W['account']['type_sign'] == WXAPP_TYPE_SIGN) {
		$users_permission = permission_account_user('wxapp');
	} else {
		$users_permission = permission_account_user('system');
	}
	if (!isset($users_permission)) {
		$users_permission = permission_account_user('system');
	}
	if ($users_permission[0] != 'all' && !in_array($permission_name, $users_permission) && !in_array(FRAME . '*', $users_permission)) {
		if (in_array($permission_name, permission_first_sub_permission()) && !empty($show_message)) {
			load()->model('system');
			$permission_string = explode('_', $permission_name);
			$goto_permission = permission_subpermission($permission_string[0] . '_' . $permission_string[1] . '_');
			$system_menu = system_menu_permission_list(ACCOUNT_MANAGE_NAME_OPERATOR);
			$goto_url = $system_menu[FRAME]['section'][$permission_string[0]]['menu'][$permission_string[0] . '_' . $permission_string[1]]['sub_permission'][$goto_permission]['url'];
			itoast('', $goto_url);
		}
		if ($show_message) {
			empty($_W['isajax']) ? itoast('您没有进行该操作的权限！', '', '') : iajax(-1, '您没有进行该操作的权限');
		} else {
			return false;
		}
	}
	return true;
}

function permission_first_sub_permission() {
	return array(
		'platform_reply_keyword',
		'platform_menu_default',
		'platform_qr_qr',
		'platform_masstask_post',
		'platform_material_news',
		'platform_site_multi',
		'mc_fans_display',
		'mc_member_diaplsy',
		'profile_setting_remote',
		'profile_payment_pay',
		'statistics_visit_app',
		'wxapp_payment_pay',
	);
}

/*
 * 判断操作员是否具有模块某个业务功能菜单的权限
 */
function permission_check_account_user_module($action = '', $module_name = '') {
	global $_W, $_GPC;
	$status = permission_account_user_permission_exist();
	if(empty($status)) {
		return true;
	}
	$a = trim($_GPC['a']);
	$do = trim($_GPC['do']);
	$m = safe_gpc_string($_GPC['module_name']) ? safe_gpc_string($_GPC['module_name']) : safe_gpc_string($_GPC['m']);
	//参数设置权限
	if ($a == 'manage-account' && $do == 'setting' && !empty($m)) {
		$permission_name = $m . '_settings';
		$users_permission = permission_account_user($m);
		if ($users_permission[0] != 'all' && !in_array($permission_name, $users_permission)) {
			return false;
		}
		//模块其他业务菜单
	} elseif (!empty($do) && !empty($m)) {
		$is_exist = table('modules_bindings')->isEntryExists($m, 'menu', $do);
		if(empty($is_exist)) {
			return true;
		}
	}
	if(empty($module_name)) {
		$module_name = IN_MODULE;
	}
	$permission = permission_account_user($module_name);
	if(empty($permission) || ($permission[0] != 'all' && !empty($action) && !in_array($action, $permission))) {
		return false;
	}
	return true;
}

/*
 * 获取某个用户所在用户组可添加的主公号数量，已添加的数量，还可以添加的数量
 * $uid int 要查询的用户uid
 */
function permission_user_account_num($uid = 0) {
	global $_W;
	$uid = intval($uid);
	$user = $uid > 0 ? user_single($uid) : $_W['user'];
	if (empty($user)) {
		return array();
	}
	$user_founder_info = table('users_founder_own_users')->getFounderByUid($user['uid']);
	$account_all_type = uni_account_type();
	$account_all_type_sign = array_keys(uni_account_type_sign());
	$extra_group_table = table('users_extra_group');
	$extra_limit_table = table('users_extra_limit');

	if (user_is_vice_founder($user['uid']) || !empty($user_founder_info['founder_uid'])) {
		if (!empty($user_founder_info['founder_uid'])  && !user_is_vice_founder($user['uid'])) {
			$role = ACCOUNT_MANAGE_NAME_OWNER;
			$group = table('users_group')->getById($user['groupid']);
			$user_uid = $user_founder_info['founder_uid'];
		} else {
			$role = ACCOUNT_MANAGE_NAME_VICE_FOUNDER;
			$group = table('users_founder_group')->getById($user['groupid']);
			$user_uid = $user['uid'];
		}

		foreach ($account_all_type_sign as $type_info) {
			$key_name = $type_info . '_num';
			$group_num[$key_name] = 0;
		}
		//获取副创始人下的所有用户（包括自己）所创建的帐号数量
		$fouder_own_users_owner_account = table('account')->searchAccountList(false, 1, $fields = 'a.uniacid, b.type', $user['uid']);
		$current_vice_founder_user_group_nums = 0;
		if (!empty($fouder_own_users_owner_account)) {
			foreach ($fouder_own_users_owner_account as $account) {
				foreach ($account_all_type as $type_key => $type_info) {
					if ($type_key == $account['type']) {
						$key_name = $type_info['type_sign'] . '_num';
						$group_num[$key_name] += 1;
						$current_vice_founder_user_group_nums += 1;
						continue;
					}
				}
			}
		}
	} else {
		$role = ACCOUNT_MANAGE_NAME_OWNER;
		$group = table('users_group')->getById($user['groupid']);
		$group_num = uni_owner_account_nums($user['uid'], $role);
		if (empty($_W['isfounder'])) {
			if (!empty($user['owner_uid'])) {
				$owner_info = table('users')->getById($user['owner_uid']);
				$group_vice = table('users_founder_group')->getById($owner_info['groupid']);

				$founder_group_num = uni_owner_account_nums($owner_info['uid'], ACCOUNT_MANAGE_NAME_VICE_FOUNDER);
				foreach ($account_all_type_sign as $sign) {
					$maxsign = 'max' . $sign;
					$group[$maxsign] = min(intval($group[$maxsign]), intval($group_vice[$maxsign]));
				}
			}
		}
	}
	if (!empty($user_founder_info['founder_uid'])) {
		$owner_info = table('users')->getById($user_founder_info['founder_uid']);
		$group_vice = table('users_founder_group')->getById($owner_info['groupid']);
		$founder_group_num = uni_owner_account_nums($owner_info['uid'], ACCOUNT_MANAGE_NAME_VICE_FOUNDER);
	}
	$store_order_table = table('site_store_order');
	$store_create_table = table('site_store_create_account');
	foreach ($account_all_type_sign as $type_sign) {
		$create_buy_num[$type_sign] = $store_create_table->getUserCreateNumByType($user['uid'], $type_sign);
	}
	foreach ($account_all_type_sign as $type_sign) {
		$store_buy[$type_sign] = $store_order_table->getUserBuyNumByType($user['uid'], $type_sign);
		$store_buy[$type_sign] = $store_buy[$type_sign] < 0 ? 0 : $store_buy[$type_sign];
	}

	$extra_create_group_info  = array_keys($extra_group_table->getCreateGroupsByUid($user['uid']));
	$extra_limits_info = $extra_limit_table->getExtraLimitByUid($user['uid']);
	if (!empty($user_founder_info['founder_uid'])) {
		$founder_extra_create_group_info  = array_keys($extra_group_table->getCreateGroupsByUid($user_founder_info['founder_uid']));
		$founder_extra_limits_info = $extra_limit_table->getExtraLimitByUid($user_founder_info['founder_uid']);

		$vice_founder_own_users_create_accounts = table('account')->searchAccountList(false, 1, $fields = 'a.uniacid, b.type', $user_founder_info['founder_uid']);
		$vice_founder_own_users_create_nums = array();
		foreach ($account_all_type_sign as $type_info) {
			$key_name = $type_info . '_num';
			$vice_founder_own_users_create_nums[$key_name] = 0;
		}
		if (!empty($vice_founder_own_users_create_accounts)) {
			foreach ($vice_founder_own_users_create_accounts as $vice_founder_own_users_create_account){
				foreach ($account_all_type as $type_key => $type_info) {
					if ($vice_founder_own_users_create_account['type'] == $type_key) {
						$key_name = $type_info['type_sign'] . '_num';
						$vice_founder_own_users_create_nums[$key_name] += 1;
						continue;
					}
				}
			}
		}

	}
	$create_group_info_all = array();
	if (!empty($extra_create_group_info)) {
		$create_group_table = table('users_create_group');
		$create_groups = array();
		foreach($extra_create_group_info as $create_group_id) {
			$create_group_info = $create_group_table->getById($create_group_id);
			$create_groups[] = $create_group_info;
			foreach ($account_all_type_sign as $sign) {
				$maxsign = 'max' . $sign;
				$create_group_info_all[$maxsign] += $create_group_info[$maxsign];
			}
		}
	}
	$founcder_create_group_info_all = array();
	if (!empty($user_founder_info['founder_uid']) && !empty($extra_create_group_info)) {
		$create_group_table = table('users_create_group');
		$founder_create_groups = array();
		foreach($founder_extra_create_group_info as $create_group_id) {
			$create_group_info = $create_group_table->getById($create_group_id);
			$founder_create_groups[] = $create_group_info;
			foreach ($account_all_type_sign as $sign) {
				$maxsign = 'max' . $sign;
				$founcder_create_group_info_all[$maxsign] += $create_group_info[$maxsign];
			}
		}
	}
	$extra = $limit = $founder_limit = array();
	$founder_limit_total = 0;

	foreach ($account_all_type_sign as $sign) {
		$maxsign = 'max' . $sign;
		$extra[$sign] = $create_group_info_all[$maxsign] + $extra_limits_info[$maxsign];
		if (!empty($user_founder_info['founder_uid'])){
			$founder_extra[$sign] = $founcder_create_group_info_all[$maxsign] + $founder_extra_limits_info[$maxsign];
		} else {
			$founder_extra[$sign] = 0;
		}
		$sign_num = $sign . '_num';
		$limit[$sign] = max((intval($group[$maxsign]) + $extra[$sign] + intval($store_buy[$sign]) - $group_num[$sign_num]), 0);
		$founder_limit[$sign] = max((intval($group_vice[$maxsign]) + $founder_extra[$sign]), 0);

		# 当当前用户属于副创始人时, (副创始人总的创建权限要减去副创始人下所有用户创建的帐号数量)
		if (!empty($vice_founder_own_users_create_nums)) {
			$founder_limit[$sign] -= $vice_founder_own_users_create_nums[$sign_num];
		}
		$founder_limit_total += $founder_limit[$sign];
	}
	$founder_limit_total = max(0, $founder_limit_total);
	$data = array(
		'group_name' => $group['name'],
		'vice_group_name' => $group_vice['name'],
		'create_groups' => $create_groups,
		'founder_limit_total' => $founder_limit_total,
	);
	$data['max_total'] = 0;
	$data['created_total'] = 0;
	$data['limit_total'] = 0;
	foreach ($account_all_type_sign as $sign) {
		$data["store_buy_{$sign}"] = $store_buy[$sign];
		$data["store_{$sign}_limit"] = intval($store_buy[$sign]) - intval($create_buy_num[$sign]) <= 0 ? 0 : intval($store_buy[$sign]);
		$data['store_limit_total' ] += $data["store_{$sign}_limit"];

		$maxsign = 'max' . $sign;
		$sign_num = $sign . '_num';
		//用户组可创建数量
		$data['user_group_max' . $sign] = $group[$maxsign];
		//用户组剩余创建数量
		$data['usergroup_' . $sign . '_limit'] = max($group[$maxsign] - $group_num[$sign_num] - intval($create_buy_num[$sign]), 0);
		//最大创建数量
		$data[$maxsign] = $group[$maxsign] + intval($store_buy[$sign]) + $extra[$sign];
		//已创建的数量
		$data[$sign_num] = $group_num[$sign_num];
		//剩余创建数量
		$data[$sign . '_limit'] = max($limit[$sign], 0);
		//附加权限
		$data['extra_' . $sign] = $extra_limits_info[$maxsign];
		//副创始人账号剩余
		$data['founder_' . $sign . '_limit'] = max($founder_limit[$sign], 0);
		$data['max_total'] = $data[$maxsign] + $data['max_total'];
		$data['created_total'] = $data[$sign_num] + $data['created_total'];
		$data['limit_total'] = $data[$sign . '_limit'] + $data['limit_total'];
		$data['current_vice_founder_user_created_total'] = !empty($current_vice_founder_user_group_nums) ? $current_vice_founder_user_group_nums : 0;
		if (!empty($vice_founder_own_users_create_nums)) {
			$data['vice_founder_own_users_' . $sign_num] = $vice_founder_own_users_create_nums[$sign_num]; # 副创始人下所有用户创建的各类型帐号数量
		}
	}

	if (!empty($vice_founder_own_users_create_nums)) {
		foreach ($vice_founder_own_users_create_nums as $vice_founder_own_users_create_num) {
			$data['vice_founder_own_users_created_total'] += $vice_founder_own_users_create_num; # 副创始人下所有用户创建的帐号总数量(所有类型相加)
		}
	}
	ksort($data);
	return $data;
}

function permission_subpermission($prefix, $module = '') {
	global $_W;
	$result = '';
	if (empty($prefix)) {
		return $result;
	}
	$type = !empty($module) ? safe_gpc_string($module) : ($_W['account']['type_sign'] == 'account' ? 'system' : $_W['account']['type_sign']);
	$account_premission = table('users_permission')->getUserPermissionByType($_W['uid'], $_W['uniacid'], $type);
	if (!empty($account_premission['permission'])) {
		foreach ($account_premission['permission'] as $permission) {
			$if_exist = strpos($permission, $prefix);
			$result = $if_exist !== false ? $permission : '';
			if (!empty($result)) break;
		}
	}
	return $result;
}

/**
 * 是否可创建帐号
 * @param $uid
 * @param $type_sign
 * @return bool
*/
function permission_user_account_creatable($uid = 0, $type_sign = '') {
	global $_W;
	$uid = empty($uid) ? $_W['uid'] : $uid;
	$type_sign = empty($type_sign) ? 'account' : $type_sign;
	if(user_is_founder($uid) && !user_is_vice_founder()) {
		return true;
	}
	$key = $type_sign . '_limit';
	$data = permission_user_account_num($uid);
	return isset($data[$key]) && $data[$key] > 0;
}

/**
 * 获取用户的所有到期时间
 * @param int $uid
 * @return array|int
 */
function permission_user_timelimits($uid = 0) {
	global $_W;
	$uid = empty($uid) ? $_W['uid'] : $uid;
	$user = user_single($uid);

	if (user_is_founder($uid) && !user_is_vice_founder()) {
		return 0;
	}

	if (user_is_vice_founder($uid)) {
		$group_info = user_founder_group_detail_info($user['groupid']);
	} else {
		$group_info = user_group_detail_info($user['groupid']);
	}

	$users_extra_limit_table = table('users_extra_limit');
	$extra_limit_info = $users_extra_limit_table->getExtraLimitByUid($uid);

	$limits = array();
	$limits['user_group'] = $group_info['timelimit'];
	$limits['user_extra'] = $extra_limit_info['timelimit'];
	$limits['total'] = $group_info['timelimit'] + $extra_limit_info['timelimit'];
	return $limits;
}

/**
 * 副创始人 创建用户及权限组时, 检测是否超出自身权限限制
 * @param $group_info
 * @return array|bool
 */
function permission_check_vice_founder_limit($group_info) {
	global $_W;
	$timelimits = permission_user_timelimits();
	$user_end_time = user_end_time($_W['uid']);
	if ($group_info['timelimit'] > $timelimits['total'] && !empty($user_end_time)) {
		return error(-1, '当前用户组的有效期不能超过' . $timelimits['total'] . '天！');
	}

	$account_nums = permission_user_account_num();
	$account_all_type_sign = uni_account_type_sign();
	foreach ($account_all_type_sign as $account_type_key => $account_type_info) {
		$maxtype = 'max' . $account_type_key;
		if ($group_info[$maxtype] > $account_nums[$maxtype]) {
			return error(-1, "当前用户组的" . $account_type_info['title'] . "个数不能超过" . $account_nums[$maxtype] . '个!');
		}
	}
	return true;
}

/*
 * 初始化某个用户在某个公众号的权限(菜单权限和模块权限)
 * @param number $uid
 * @param number $uniacid
 * @return boolean
 * */
function permission_account_user_init($uid, $uniacid) {
	$uid = intval($uid);
	$uniacid = intval($uniacid);

	if (empty($uid) || empty($uniacid)) {
		return error(-1, '参数错误');
	}

	$account = uni_fetch($uniacid);
	$account_all_type_sign = uni_account_type_sign();
	foreach ($account_all_type_sign as $account_type_sign => $account_type_info) {
		if (in_array($account['type'], $account_type_info['contain_type'])) {
			$account_type = $account_type_sign == 'account' ? 'system' : $account_type_sign;
		}
	}

	$user_own_menu_permission = table('users_permission')->getUserPermissionByType($uid, $uniacid, $account_type);
	$user_own_module_permission = table('users_permission')->getAllUserModulePermission($uid, $uniacid);

	if (empty($user_own_menu_permission)) {
		$all_menu_permission = permission_menu_name();
		$user_menu_permission_data = array(
			'type' => $account_type,
			'permission' => implode('|', $all_menu_permission),
		);
		permission_update_account_user($uid, $uniacid, $user_menu_permission_data);

	}

	if (empty($user_own_module_permission)) {
		$insert = array(
			'uniacid' => $uniacid,
			'uid' => $uid,
			'type' => 'modules',
			'permission' => 'all',

		);
		pdo_insert('users_permission', $insert);
	}
	return true;
}