<?php
/**
 * [WeEngine System] Copyright (c) 2014 W7.CC
 * $sn$
 */
defined('IN_IA') or exit('Access Denied');

/**
 * 系统预置的模块
 */
function module_system() {
	return array(
		'basic', 'news', 'music', 'service', 'userapi', 'recharge', 'images', 'video', 'voice', 'wxcard',
		'custom', 'chats', 'paycenter', 'keyword', 'special', 'welcome', 'default', 'apply', 'reply', 'core', 'store', 'wxapp'
	);
}

/**
 * 模块类型
 *
 * @return array
 */
function module_types() {
	static $types = array(
		'business' => array(
			'name' => 'business',
			'title' => '主要业务',
			'desc' => ''
		),
		'customer' => array(
			'name' => 'customer',
			'title' => '客户关系',
			'desc' => ''
		),
		'activity' => array(
			'name' => 'activity',
			'title' => '营销及活动',
			'desc' => ''
		),
		'services' => array(
			'name' => 'services',
			'title' => '常用服务及工具',
			'desc' => ''
		),
		'biz' => array(
			'name' => 'biz',
			'title' => '行业解决方案',
			'desc' => ''
		),
		'enterprise' => array(
			'name' => 'enterprise',
			'title' => '企业应用',
			'desc' => ''
		),
		'h5game' => array(
			'name' => 'h5game',
			'title' => 'H5游戏',
			'desc' => ''
		),
		'other' => array(
			'name' => 'other',
			'title' => '其他',
			'desc' => ''
		)
	);
	return $types;
}

function module_support_type() {
	//根据模块类型分类
	$module_support_type = array(
		'wxapp_support' => array(
			'type' => WXAPP_TYPE_SIGN,
			'type_name' => '微信小程序',
			'support' => MODULE_SUPPORT_WXAPP,
			'not_support' => MODULE_NONSUPPORT_WXAPP,
			'store_type' => STORE_TYPE_WXAPP_MODULE,
		),
		'account_support' => array(
			'type' => ACCOUNT_TYPE_SIGN,
			'type_name' => '公众号',
			'support' => MODULE_SUPPORT_ACCOUNT,
			'not_support' => MODULE_NONSUPPORT_ACCOUNT,
			'store_type' => STORE_TYPE_MODULE,
		),
		'welcome_support' => array(
			'type' => WELCOMESYSTEM_TYPE_SIGN,
			'type_name' => '系统首页',
			'support' => MODULE_SUPPORT_SYSTEMWELCOME,
			'not_support' => MODULE_NONSUPPORT_SYSTEMWELCOME,
		),
		'webapp_support' => array(
			'type' => WEBAPP_TYPE_SIGN,
			'type_name' => 'PC',
			'support' => MODULE_SUPPORT_WEBAPP,
			'not_support' => MODULE_NOSUPPORT_WEBAPP,
			'store_type' => STORE_TYPE_WEBAPP_MODULE,
		),
		'phoneapp_support' => array(
			'type' => PHONEAPP_TYPE_SIGN,
			'type_name' => 'APP',
			'support' => MODULE_SUPPORT_PHONEAPP,
			'not_support' => MODULE_NOSUPPORT_PHONEAPP,
			'store_type' => STORE_TYPE_PHONEAPP_MODULE,
		),
		'aliapp_support' => array(
			'type' => ALIAPP_TYPE_SIGN,
			'type_name' => '支付宝小程序',
			'support' => MODULE_SUPPORT_ALIAPP,
			'not_support' => MODULE_NOSUPPORT_ALIAPP,
			'store_type' => STORE_TYPE_ALIAPP_MODULE,
		),
		'baiduapp_support' => array(
			'type' => BAIDUAPP_TYPE_SIGN,
			'type_name' => '百度小程序',
			'support' => MODULE_SUPPORT_BAIDUAPP,
			'not_support' => MODULE_NOSUPPORT_BAIDUAPP,
			'store_type' => STORE_TYPE_BAIDUAPP_MODULE,
		),
		'toutiaoapp_support' => array(
			'type' => TOUTIAOAPP_TYPE_SIGN,
			'type_name' => '字节跳动小程序',
			'support' => MODULE_SUPPORT_TOUTIAOAPP,
			'not_support' => MODULE_NOSUPPORT_TOUTIAOAPP,
			'store_type' => STORE_TYPE_TOUTIAOAPP_MODULE,
		)
	);
	return $module_support_type;
}

/**
 * 获取指定模块的所有入口地址
 *
 * @param string $name 模块名称
 * @param string|array $types 入口类型
 * @param number $rid 规则编号
 * @param string $args 附加参数
 * @return array
 */
function module_entries($name, $types = array(), $rid = 0, $args = null) {
	load()->func('communication');

	global $_W;
	
	
		$ts = array('rule', 'cover', 'menu', 'home', 'profile', 'shortcut', 'function', 'mine');
	
	if (empty($types)) {
		$types = $ts;
	} else {
		$types = array_intersect($types, $ts);
	}
	$bindings = pdo_getall('modules_bindings', array('module' => $name, 'entry' => $types), array(), '', 'displayorder DESC, multilevel DESC, eid ASC');
	$entries = array();
	$cache_key = cache_system_key('module_entry_call', array('module_name' => $name));
	$entry_call = cache_load($cache_key);
	if (empty($entry_call)) {
		$entry_call = array();
	}
	foreach ($bindings as $bind) {
		if (!empty($bind['call'])) {
			if (empty($entry_call[$bind['entry']])) {
				$call_url = url('utility/bindcall', array('modulename' => $bind['module'], 'callname' => $bind['call'], 'args' => $args, 'uniacid' => $_W['uniacid']));
				$response = ihttp_request($call_url);
				if (is_error($response) || $response['code'] != 200) {
					$response = ihttp_request($_W['siteroot'] . 'web/' . $call_url); //127.0.0.1 get 不到数据时,尝试使用域名get
					if (is_error($response) || $response['code'] != 200) {
						continue;
					}
				}
				$response = json_decode($response['content'], true);
				$ret = $response['message']['message'];
				if (is_array($ret)) {
					foreach ($ret as $i => $et) {
						if (empty($et['url'])) {
							continue;
						}
						$urlinfo = url_params($et['url']);
						$et['do'] = empty($et['do']) ? $urlinfo['do'] : $et['do'];
						$et['url'] = $et['url'] . '&__title=' . urlencode($et['title']);
						$entry_call[$bind['entry']][] = array('eid' => 'user_' . $i, 'title' => $et['title'], 'do' => $et['do'], 'url' => $et['url'], 'from' => 'call', 'icon' => $et['icon'], 'displayorder' => $et['displayorder']);
					}
				}
				cache_write($cache_key, $entry_call, 300);
			}
			$entries[$bind['entry']] = $entry_call[$bind['entry']];
		} else {
			if (in_array($bind['entry'], array('cover', 'home', 'profile', 'shortcut'))) {
				$url = murl('entry', array('eid' => $bind['eid']));
			}
			if (in_array($bind['entry'], array('menu', 'system_welcome'))) {
				$url = wurl("site/entry", array('eid' => $bind['eid']));
			}
			if ($bind['entry'] == 'mine') {
				$url = $bind['url'];
			}
			if ($bind['entry'] == 'rule') {
				$par = array('eid' => $bind['eid']);
				if (!empty($rid)) {
					$par['id'] = $rid;
				}
				$url = wurl("site/entry", $par);
			}

			if (empty($bind['icon'])) {
				$bind['icon'] = 'wi wi-appsetting';
			}
			if (!defined('SYSTEM_WELCOME_MODULE') && $bind['entry'] == 'system_welcome') {
				continue;
			}
			$entries[$bind['entry']][] = array(
				'eid' => $bind['eid'],
				'title' => $bind['title'],
				'do' => $bind['do'],
				'url' => !$bind['multilevel'] ? $url : '',
				'from' => 'define',
				'icon' => $bind['icon'],
				'displayorder' => $bind['displayorder'],
				'direct' => $bind['direct'],
				'multilevel' => $bind['multilevel'],
				'parent' => $bind['parent'],
			);
		}
	}
	return $entries;
}
/**
 * 专属生成APP端的入口地址
 */
function module_app_entries($name, $types = array(), $args = null) {
	global $_W;
	$ts = array('rule', 'cover', 'menu', 'home', 'profile', 'shortcut', 'function');
	if (empty($types)) {
		$types = $ts;
	} else {
		$types = array_intersect($types, $ts);
	}
	$bindings = pdo_getall('modules_bindings', array('module' => $name, 'entry' => $types));
	$entries = array();
	foreach ($bindings as $bind) {
		if (!empty($bind['call'])) {
			$extra = array();
			$extra['Host'] = $_SERVER['HTTP_HOST'];
			load()->func('communication');
			$urlset = parse_url($_W['siteurl']);
			$urlset = pathinfo($urlset['path']);
			$response = ihttp_request($_W['sitescheme'] . $extra['Host'] . $urlset['dirname'] . '/' . url('utility/bindcall', array('modulename' => $bind['module'], 'callname' => $bind['call'], 'args' => $args, 'uniacid' => $_W['uniacid'])), array('W' => base64_encode(iserializer($_W))), $extra);
			if (is_error($response)) {
				continue;
			}
			$response = json_decode($response['content'], true);
			$ret = $response['message']['message'];
			if (is_array($ret)) {
				foreach ($ret as $et) {
					$et['url'] = $et['url'] . '&__title=' . urlencode($et['title']);
					$entries[$bind['entry']][] = array('title' => $et['title'], 'url' => $et['url'], 'from' => 'call');
				}
			}
		} else {
			if ($bind['entry'] == 'cover') {
				$url = murl("entry", array('eid' => $bind['eid']));
			}
			if ($bind['entry'] == 'home') {
				$url = murl("entry", array('eid' => $bind['eid']));
			}
			if ($bind['entry'] == 'profile') {
				$url = murl("entry", array('eid' => $bind['eid']));
			}
			if ($bind['entry'] == 'shortcut') {
				$url = murl("entry", array('eid' => $bind['eid']));
			}
			$entries[$bind['entry']][] = array('title' => $bind['title'], 'do' => $bind['do'], 'url' => $url, 'from' => 'define');
		}
	}
	return $entries;
}

function module_entry($eid) {
	$sql = "SELECT * FROM " . tablename('modules_bindings') . " WHERE `eid`=:eid";
	$pars = array();
	$pars[':eid'] = $eid;
	$entry = pdo_fetch($sql, $pars);
	if (empty($entry)) {
		return error(1, '模块菜单不存在');
	}
	$module = module_fetch($entry['module']);
	if (empty($module)) {
		return error(2, '模块不存在');
	}
	$querystring = array(
		'do' => $entry['do'],
		'm' => $entry['module'],
	);
	if (!empty($entry['state'])) {
		$querystring['state'] = $entry['state'];
	}

	$entry['url'] = murl('entry', $querystring);
	$entry['url_show'] = murl('entry', $querystring, true, true);
	return $entry;
}

/**
 * 显示模块设置表单
 *
 * @param string $name
 * @param number $rid
 * @param array $option 模块显示隐藏设置
 * @return string
 */
function module_build_form($name, $rid, $option = array()) {
	$rid = intval($rid);
	$m = WeUtility::createModule($name);
	if (!empty($m)) {
		return $m->fieldsFormDisplay($rid, $option);
	} else {
		return null;
	}
}

/**
 * 添加应用权限组
 * @param $package
 * @return bool
 */
function module_save_group_package($package) {
	global $_W;
	load()->model('user');
	load()->model('cache');

	if (empty($package['name'])) {
		return error(-1, '请输入套餐名');
	}

	if (!empty($package['modules'])) {
		$package['modules'] = iserializer($package['modules']);
	}

	if (!empty($package['templates'])) {
		$templates = array();
		foreach ($package['templates'] as $id) {
			$templates[] = $id;
		}
		$package['templates'] = iserializer($templates);
	}

	if (!empty($package['id'])) {
		$name_exist = pdo_get('uni_group', array('uniacid' => 0, 'id <>' => $package['id'], 'name' => $package['name']));
	} else {
		$name_exist = pdo_get('uni_group', array('uniacid' => 0, 'name' => $package['name']));
	}

	if (!empty($name_exist)) {
		return error(-1, '套餐名已存在');
	}

	if (!empty($package['id'])) {
		pdo_update('uni_group', $package, array('id' => $package['id']));
		cache_build_account_modules();
	} else {
		pdo_insert('uni_group', $package);
		$uni_group_id = pdo_insertid();
		if (user_is_vice_founder()) {
			$table = table('users_founder_own_uni_groups');
			$table->addOwnUniGroup($_W['uid'], $uni_group_id);
		}
	}
	cache_build_uni_group();
	return error(0, '添加成功');
}
/**
 * 获取指定模块及模块信息
 *
 * @param string $name 模块名称
 * @return array 模块信息
 */
function module_fetch($name, $enabled = true) {
	global $_W;
	$cachekey = cache_system_key('module_info', array('module_name' => $name));
	$module = cache_load($cachekey);
	if (empty($module)) {
		$module_info = table('modules')->getByName($name);
		if (empty($module_info)) {
			return array();
		}
		$module_info['isdisplay'] = 1;
		$module_info['logo'] = tomedia($module_info['logo']);
		$module_info['preview'] = tomedia(IA_ROOT . '/addons/' . $module_info['name'] . '/preview.jpg', '', true);
		if (file_exists(IA_ROOT . '/addons/' . $module_info['name'] . '/preview-custom.jpg')) {
			$module_info['preview'] = tomedia(IA_ROOT . '/addons/' . $module_info['name'] . '/preview-custom.jpg', '', true);
		}
		if (APPLICATION_TYPE_TEMPLATES == $module_info['application_type']) {
			$module_info['preview'] = tomedia(IA_ROOT . '/app/themes/' . $module_info['name'] . '/preview-custom.jpg', '', true);
		}
		$modules_plugin = table('modules_plugin')->getAllByNameOrMainModule($module_info['name']);
		$main_module = array_column($modules_plugin, 'main_module');
		if (in_array($module_info['name'], $main_module)) {
			$module_info['plugin_list'] = array_column($modules_plugin, 'name');
		} else {
			$module_info['main_module'] = current($main_module);
			if (!empty($module_info['main_module'])) {
				$main_module_info = module_fetch($module_info['main_module'], false);
				if (empty($main_module_info)) {
					$main_module_info = pdo_get('modules_cloud', array('name' => $module_info['main_module']));
				}
				$module_info['main_module_logo'] = $main_module_info['logo'];
				$module_info['main_module_title'] = $main_module_info['title'];
			}
		}
		//禁用订阅
		$module_receive_ban = (array)setting_load('module_receive_ban');
		if (is_array($module_receive_ban['module_receive_ban']) && in_array($name, $module_receive_ban['module_receive_ban'])) {
			$module_info['is_receive_ban'] = true;
		}
		//盗版模块
		$module_ban = (array)setting_load('module_ban');
		if (is_array($module_ban['module_ban']) && in_array($name, $module_ban['module_ban'])) {
			$module_info['is_ban'] = true;
		}
		$module_upgrade = (array)setting_load('module_upgrade');
		if (is_array($module_upgrade['module_upgrade']) && in_array($name, array_keys($module_upgrade['module_upgrade']))) {
			$module_info['is_upgrade'] = true;
		}

		//回收详情
		$module_info['recycle_info'] = array();
		$recycle_info = table('modules_recycle')->getByName($name);
		if (!empty($recycle_info)) {
			$is_delete = true;
			foreach (module_support_type() as $support => $value) {
				if (!empty($recycle_info[MODULE_RECYCLE_UNINSTALL_IGNORE][$support])) {
					$module_info['recycle_info'][$support] = MODULE_RECYCLE_UNINSTALL_IGNORE; //0 无操作, 1 已停用, 2 已删除
				} else {
					$module_info['recycle_info'][$support] = empty($recycle_info[MODULE_RECYCLE_INSTALL_DISABLED][$support]) ? 0 : MODULE_RECYCLE_INSTALL_DISABLED;
				}
				if ($module_info[$support] == $value['support'] && empty($module_info['recycle_info'][$support])) {
					$is_delete = false;
				}
			}
			$module_info['is_delete'] = $is_delete; //全部支持被停用或删除
		}

		$module = $module_info;
		cache_write($cachekey, $module_info);
	}

	//增加开启参数，可以获取放入回收站的模块
	if (!empty($enabled)) {
		if (!empty($module['is_delete'])) {
			return array();
		}
	}

	//有公众号时，附加模块配置信息
	if (!empty($module) && !empty($_W['uniacid'])) {
		$setting_cachekey = cache_system_key('module_setting', array('module_name' => $name, 'uniacid' => $_W['uniacid']));
		$setting = cache_load($setting_cachekey);
		if (empty($setting)) {
			$setting = table('uni_account_modules')->getByUniacidAndModule($name, $_W['uniacid']);
			$setting = empty($setting) ? array('module' => $name) : $setting;
			cache_write($setting_cachekey, $setting);
		}
		$module['config'] = $setting['settings'];
		$module['enabled'] = $module['issystem'] || !isset($setting['enabled']) ? 1 : $setting['enabled'];
		$module['displayorder'] = $setting['displayorder'];
		$module['shortcut'] = $setting['shortcut'];
		$module['module_shortcut'] = $setting['module_shortcut'];
	}
	return $module;
}

function module_main_info($module_name) {
	$cachekey = cache_system_key('module_main_info', array('module_name' => $module_name));
	$module = cache_load($cachekey);
	if (empty($module)) {
		$fileds = array('name', 'title', 'version', 'logo', 'account_support', 'wxapp_support', 'webapp_support', 'phoneapp_support', 'aliapp_support', 'baiduapp_support', 'toutiaoapp_support', 'welcome_support');
		$module_info = pdo_get('modules', array('name' => $module_name), $fileds);
		if (empty($module_info)) {
			return array();
		}
		$module_info['logo'] = tomedia($module_info['logo']);
		$module = $module_info;
		cache_write($cachekey, $module_info);
	}
	return $module;
}
/**
 * 获取某个模块的权限列表
 * @param string $name 模块标识
 */
function module_permission_fetch($name) {
	$module = module_fetch($name);
	$data = array();
	if ($module['settings']) {
		$data[] = array('title' => '参数设置', 'permission' => $name . '_settings');
	}
	if ($module['isrulefields']) {
		$data[] = array('title' => '回复规则列表', 'permission' => $name . '_rule');
	}
	$entries = module_entries($name);
	if (!empty($entries['home'])) {
		$data[] = array('title' => '微站首页导航', 'permission' => $name . '_home');
	}
	if (!empty($entries['profile'])) {
		$data[] = array('title' => '个人中心导航', 'permission' => $name . '_profile');
	}
	if (!empty($entries['shortcut'])) {
		$data[] = array('title' => '快捷菜单', 'permission' => $name . '_shortcut');
	}
	if (!empty($entries['cover'])) {
		foreach ($entries['cover'] as $cover) {
			$data[] = array('title' => $cover['title'], 'permission' => $name . '_cover_' . $cover['do']);
		}
	}
	if (!empty($entries['menu'])) {
		foreach ($entries['menu'] as $menu) {
			if (!empty($menu['multilevel'])) {
				continue;
			}
			$data[$menu['do']] = array('title' => $menu['title'], 'permission' => $name . '_menu_' . $menu['do']);
		}
	}
	unset($entries);
	if (!empty($module['permissions'])) {
		$module['permissions'] = (array)iunserializer($module['permissions']);
		foreach ($module['permissions'] as $permission) {
			if (!empty($permission['parent']) && !empty($data[$permission['parent']])) {
				$sub_permission = array(
					'title' => $permission['title'],
					'permission' => $name . '_menu_' . $permission['parent'] . '_' . $permission['permission'],
				);
				if (empty($data[$permission['parent']]['sub_permission'])) {
					$data[$permission['parent']]['sub_permission'] = array($sub_permission);
				} else {
					array_push($data[$permission['parent']]['sub_permission'], $sub_permission);
				}
			}
			$data[] = array('title' => $permission['title'], 'permission' => $name . '_permission_' . $permission['permission']);
		}
	}
	return $data;
}

/**
 *  获取指定模块在当前公众号安装的插件
 * @param string $module_name 模块标识
 * @param array() $plugin_list 插件列表
 */
function module_get_plugin_list($module_name) {
	$module_info = module_fetch($module_name);
	if (!empty($module_info['plugin_list']) && is_array($module_info['plugin_list'])) {
		$plugin_list = array();
		foreach ($module_info['plugin_list'] as $plugin) {
			$plugin_info = module_fetch($plugin);
			if (!empty($plugin_info)) {
				$plugin_list[$plugin] = $plugin_info;
			}
		}
		return $plugin_list;
	} else {
		return array();
	}
}

/**
 *  返回模块的盗版信息与升级信息
 * @param string $module 模块标识
 * @return array
 */
function module_status($module) {
	load()->model('cloud');
	$result = array(
		'upgrade' => array(
			'has_upgrade' => false,
		),
		'ban' => false,
	);

	$module_cloud_info = table('modules_cloud')->getByName($module);
	if (!empty($module_cloud_info['has_new_version']) || !empty($module_cloud_info['has_new_branch'])) {
		$result['upgrade'] = array(
			'has_upgrade' => true,
			'name' => $module_cloud_info['title'],
			'version' => $module_cloud_info['version'],
		);
	}
	if (!empty($module_cloud_info['is_ban'])) {
		$result['ban'] = true;
	}
	return $result;
}

/**
 * 判断某一模块是否在公众号模块权限内
 * @param string $module_name
 * @param int $uniacid
 * @return boolean
 */
function module_exist_in_account($module_name, $uniacid) {
	load()->model('user');
	$module_name = trim($module_name);
	$uniacid = intval($uniacid);
	if (empty($module_name) || empty($uniacid)) {
		return false;
	}
	$result = table('uni_modules')->where(array('uniacid' => $uniacid, 'module_name' => $module_name))->getcolumn('id');
	return $result ? true : false;
}

/**
 * 获取操作员有某一模块权限的所有公众号和小程序
 * @param int $uid 用户UID
 * @param string $module_name 模块name
 * @return array()
 */
function module_get_user_account_list($uid, $module_name) {
	$accounts_list = array();
	$uid = intval($uid);
	$module_name = trim($module_name);
	if (empty($uid) || empty($module_name)) {
		return $accounts_list;
	}
	$module_info = module_fetch($module_name);
	if (empty($module_info)) {
		return $accounts_list;
	}
	$account_users_info = table('account')->userOwnedAccount($uid);
	if (empty($account_users_info)) {
		return $accounts_list;
	}

	foreach ($account_users_info as $account) {
		if (empty($account['uniacid'])) {
			continue;
		}
		$uniacid = 0;
		if (($account['type'] == ACCOUNT_TYPE_OFFCIAL_NORMAL || $account['type'] == ACCOUNT_TYPE_OFFCIAL_AUTH) && $module_info[MODULE_SUPPORT_ACCOUNT_NAME] == MODULE_SUPPORT_ACCOUNT) {
			$uniacid = $account['uniacid'];
		} elseif ($account['type'] == ACCOUNT_TYPE_APP_NORMAL && $module_info['wxapp_support'] == MODULE_SUPPORT_WXAPP) {
			$uniacid = $account['uniacid'];
		} elseif (($account['type'] == ACCOUNT_TYPE_WEBAPP_NORMAL && $module_info[MODULE_SUPPORT_WEBAPP_NAME] == MODULE_SUPPORT_WEBAPP)) {
			$uniacid = $account['uniacid'];
		} elseif (($account['type'] == ACCOUNT_TYPE_PHONEAPP_NORMAL && $module_info[MODULE_SUPPORT_PHONEAPP_NAME] == MODULE_SUPPORT_PHONEAPP)) {
			$uniacid = $account['uniacid'];
		} elseif (($account['type'] == ACCOUNT_TYPE_ALIAPP_NORMAL && $module_info[MODULE_SUPPORT_ALIAPP_NAME] == MODULE_SUPPORT_ALIAPP)) {
			$uniacid = $account['uniacid'];
		}
		if (!empty($uniacid)) {
			if (module_exist_in_account($module_name, $uniacid)) {
				$accounts_list[$uniacid] = $account;
			}
		}
	}

	return $accounts_list;
}

/**
 * 获取操作员对某一模块，公众号与小程序关联信息
 */
function module_link_uniacid_fetch($uid, $module_name) {
	load()->model('phoneapp');
	$result = array();
	$uid = intval($uid);
	$module_name = trim($module_name);
	if (empty($uid) || empty($module_name)) {
		return $result;
	}
	$accounts_list = module_get_user_account_list($uid, $module_name);
	if (empty($accounts_list)) {
		return $result;
	}

	$accounts_link_result = array();
	foreach ($accounts_list as $key => $account_value) {
		$account_info = uni_fetch($account_value['uniacid']);
		if ($account_info->supportVersion) {
			if ($account_value['type'] == ACCOUNT_TYPE_PHONEAPP_NORMAL) {
				$account_value['versions'] = phoneapp_version_all($account_value['uniacid']);
			} else {
				$account_value['versions'] = miniapp_version_all($account_value['uniacid']);
			}
			if (empty($account_value['versions'])) {
				$accounts_link_result[$key] = $account_value;
				continue;
			}
			foreach ($account_value['versions'] as $version_key => $version_value) {
				if (empty($version_value['modules'])) {
					continue;
				}
				$version_module_names = array_column($version_value['modules'], 'name');
				if (!in_array($module_name, $version_module_names)) {
					continue;
				}
				if (empty($version_value['modules'][0]['account']) || !is_array($version_value['modules'][0]['account'])) {
					$accounts_link_result[$key] = $account_value;
					continue;
				}
				if (!empty($version_value['modules'][0]['account']['uniacid'])) {
					$accounts_link_result[$version_value['modules'][0]['account']['uniacid']][] = array(
						'uniacid' => $key,
						'version' => $version_value['version'],
						'version_id' => $version_value['id'],
						'name' => $account_value['name'],
					);
					unset($account_value['versions'][$version_key]);
				}
			}
		} elseif ($account_value['type'] == ACCOUNT_TYPE_OFFCIAL_NORMAL || $account_value['type'] == ACCOUNT_TYPE_OFFCIAL_AUTH) {
			if (empty($accounts_link_result[$key])) {
				$accounts_link_result[$key] = $account_value;
			} else {
				$link_wxapp = $accounts_link_result[$key];
				$accounts_link_result[$key] = $account_value;
				$accounts_link_result[$key]['link_wxapp'] = $link_wxapp;
			}
		} else {
			if (empty($accounts_link_result[$key])) {
				$accounts_link_result[$key] = $account_value;
			}
		}
	}
	if (!empty($accounts_link_result)) {
		foreach ($accounts_link_result as $link_key => $link_value) {
			if (in_array($link_value['type'], array(ACCOUNT_TYPE_OFFCIAL_NORMAL, ACCOUNT_TYPE_OFFCIAL_AUTH))) {
				$link_value['type_name'] = ACCOUNT_TYPE_SIGN;
			} elseif (in_array($link_value['type'], array(ACCOUNT_TYPE_APP_NORMAL, ACCOUNT_TYPE_APP_AUTH))) {
				$link_value['type_name'] = WXAPP_TYPE_SIGN;
			} elseif ($link_value['type'] == ACCOUNT_TYPE_WEBAPP_NORMAL) {
				$link_value['type_name'] = WEBAPP_TYPE_SIGN;
			} elseif ($link_value['type'] == ACCOUNT_TYPE_PHONEAPP_NORMAL) {
				$link_value['type_name'] = PHONEAPP_TYPE_SIGN;
			} elseif ($link_value['type'] == ACCOUNT_TYPE_ALIAPP_NORMAL) {
				$link_value['type_name'] = ALIAPP_TYPE_SIGN;
			}

			if (in_array($link_value['type'], array(ACCOUNT_TYPE_OFFCIAL_NORMAL, ACCOUNT_TYPE_OFFCIAL_AUTH)) && !empty($link_value['link_wxapp']) && is_array($link_value['link_wxapp'])) {
				foreach ($link_value['link_wxapp'] as $value) {
					$result[] = array(
						'app_name' => $link_value['name'],
						'wxapp_name' => $value['name'] . ' ' . $value['version'],
						'uniacid' => $link_value['uniacid'],
						'version_id' => $value['version_id'],
						'type_name' => $link_value['type_name'],
						'account_name' => $link_value['name'],
						'type' => $link_value['type'],
						'logo' => to_global_media('headimg_' . $link_value['acid'] . '.jpg') . '?time=' . time(),
					);
				}
			} elseif ($link_value['type'] == ACCOUNT_TYPE_APP_NORMAL && !empty($link_value['versions']) && is_array($link_value['versions'])) {
				foreach ($link_value['versions'] as $value) {
					$result[] = array(
						'app_name' => '',
						'wxapp_name' => $link_value['name'] . ' ' . $value['version'],
						'uniacid' => $link_value['uniacid'],
						'version_id' => $value['id'],
						'type_name' => $link_value['type_name'],
						'account_name' => $link_value['name'],
						'type' => $link_value['type'],
						'logo' => to_global_media('headimg_' . $link_value['acid'] . '.jpg') . '?time=' . time(),
					);
				}
			} else {
				$result[] = array(
					'app_name' => $link_value['name'],
					'wxapp_name' => '',
					'uniacid' => $link_value['uniacid'],
					'version_id' => '',
					'type_name' => $link_value['type_name'],
					'account_name' => $link_value['name'],
					'type' => $link_value['type'],
					'logo' => to_global_media('headimg_' . $link_value['acid'] . '.jpg') . '?time=' . time(),
				);
			}
		}
	}

	return $result;
}

/**
 * 获取模块店员信息
 */
function module_clerk_info($module_name) {
	$user_permissions = array();
	$module_name = trim($module_name);
	if (empty($module_name)) {
		return $user_permissions;
	}
	$user_permissions = table('users_permission')->getClerkPermission($module_name);
	if (!empty($user_permissions)) {
		foreach ($user_permissions as $key => $value) {
			$user_permissions[$key]['user_info'] = user_single($value['uid']);
		}
	}
	return $user_permissions;
}

/**
 * 将应用列表页的模块置顶
 */
function module_rank_top($module_name, $uniacid) {
	global $_W;
	if (empty($module_name)) {
		return false;
	}
	$result = table('modules_rank')->setTop($module_name, $uniacid);
	return empty($result) ? true : false;
}

function module_installed_list($type = '') {
	global $_W;
	$module_list = array();
	$user_has_module = user_modules($_W['uid']);
	if (empty($user_has_module)) {
		return $module_list;
	}

	if ($type == 'all') {
		return $user_has_module;
	}

	foreach ($user_has_module as $modulename => $module) {
		if ((!empty($module['issystem']) && $module['name'] != 'we7_coupon')) {
			continue;
		}
		foreach (module_support_type() as $support_name => $support) {
			if ($module[$support_name] == $support['support'] && (empty($module['recycle_info']) || empty($module['recycle_info'][$support_name]))) {
				$module_list[$support['type']][$modulename] = $module;
			}
		}
	}

	if (!empty($type)) {
		return (array)$module_list[$type];
	} else {
		return $module_list;
	}
}

/**
 * 获取所有未安装的模块
 * @param string $module_type 模块类型;
 */
function module_uninstall_list() {
	$uninstall_modules = table('modules_cloud')->getUninstallModule();
	$recycle = table('modules_recycle')->where('type', 2)->where('name', array_keys($uninstall_modules))->getall('name');
	if (!empty($uninstall_modules)) {
		foreach ($uninstall_modules as $name => &$module) {
			if (!empty($recycle[$name])) {
				foreach (module_support_type() as $support => $value) {
					if ($module[$support] == $value['support'] && $recycle[$name][$support] == 1) {
						$module[$support] = $value['not_support'];
					}
				}
			}
			$need_install = false;
			foreach (module_support_type() as $support => $value) {
				if ($module[$support] == MODULE_SUPPORT_ACCOUNT) {
					$need_install = true;
					$module['link'] = url('module/manage-system/install', array('module_name' => $module['name'], 'support' => $support));
					break;
				}
			}
			if (!$need_install) {
				unset($module);
			}
		}
	}
	return $uninstall_modules;
}

/**
 * 获取未安装模块数量
 */
function module_uninstall_total($type) {
	$type_list = module_support_type();
	if (!isset($type_list["{$type}_support"]) && $type != 'all') {
		return 0;
	}
	if ($type == 'all') {
		$total = table('modules_cloud')->searchUninstallWithOutWelcome()->getcolumn('count(*)');
	} else {
		$total = table('modules_cloud')->searchUninstallSupport("{$type}_support")->getcolumn('count(*)');
	}
	return intval($total);
}
/**
 * 得到最新可升级应用
 * @param type account/wxapp
 * @return array 升级的模块列表
 */
function module_upgrade_list() {
	global $_W;
	$result = array();
	$module_list = user_modules($_W['uid']);
	if (empty($module_list)) {
		return $result;
	}

	$modules_cloud_table = table('modules_cloud');
	$modules_cloud_table->orderby('buytime', 'desc');
	$modules_cloud_table->orderby('lastupdatetime', 'asc');
	$upgrade_modules = $modules_cloud_table->getUpgradeByModuleNameList(array_keys($module_list));
	if (empty($upgrade_modules)) {
		return $result;
	}

	$modules_ignore = table('modules_ignore')->where('name', array_keys($upgrade_modules))->getall('name');
	foreach ($upgrade_modules as $modulename => &$module) {
		if (!empty($modules_ignore[$modulename])) {
			if (ver_compare($modules_ignore[$modulename]['version'], $module['version']) >= 0) {
				$module['is_ignore'] = 1;
			}
		}
		if (!empty($module_list[$modulename]) && $module['title'] != $module_list[$modulename]['title']) {
			$module['title'] = $module_list[$modulename]['title'];
		}
		$module['link'] = url('module/manage-system/module_detail', array('name' => $module['name'], 'show' => 'upgrade'));
	}
	unset($module);
	return $upgrade_modules;
}

function module_upgrade_total($type) {
	$type_list = module_support_type();

	if (!isset($type_list["{$type}_support"])) {
		return 0;
	}
	$modules = table('modules_cloud')->getUpgradeModulesBySupportType($type);
	return count($modules);
}

/**
 * 检查传入的模块是否有更新
 * 优先检查本地是否包含Manifest.xml
 * 否则通过modules_cloud表先查询模块云端缓存信息
 * 如果记录过期则通过接口更新modules_cloud表中的数据
 * @param array $modulelist
 */
function module_upgrade_info($modulelist = array()) {
	load()->model('cloud');
	load()->model('extension');

	$result = array();
	$module_support_type = module_support_type();
	//按照本地manifest整理接口数据
	$manifest_cloud_list = array();

	cloud_prepare();
	$cloud_m_query_module_pageinfo = cloud_m_query(array(), 1);
	if (is_error($cloud_m_query_module_pageinfo)) {
		return $cloud_m_query_module_pageinfo;
	}
	$cloud_t_query_module = cloud_t_query();
	if (is_error($cloud_t_query_module)) {
		return $cloud_t_query_module;
	}
	$cloud_m_query_module = $cloud_m_query_module_pageinfo['data'];
	if ($cloud_m_query_module_pageinfo['page'] > 1) {
		for ($i = 2;$i <= $cloud_m_query_module_pageinfo['page']; $i++) {
			$cloud_m_query_module_i = cloud_m_query(array(), $i);
			$cloud_m_query_module = array_merge($cloud_m_query_module, $cloud_m_query_module_i['data']);
		}
	}
	$pirate_apps = $cloud_m_query_module['pirate_apps'];
	unset($cloud_m_query_module['pirate_apps']);
	//模板的处理
	foreach ($cloud_t_query_module as $template_name => $template_manifest_cloud) {
		if (empty($template_manifest_cloud) || !is_array($template_manifest_cloud)) {
			continue;
		}
		$template_manifest = array(
			'application' => array(
				'name' => $template_name,
				'title' => $template_manifest_cloud['title'],
				'version' => $template_manifest_cloud['version'],
				'logo' => $template_manifest_cloud['logo'],
				'last_upgrade_time' => $template_manifest_cloud['last_upgrade_time'],
			),
			'platform' => array(
				'supports' => array('account')
			),
		);
		$template_manifest['branches'] = $template_manifest_cloud['branches'];
		$template_manifest['site_branch'] = array(
			'id' => $template_manifest_cloud['branch'],
			'name' => $template_manifest_cloud['title'],
			'version' => $template_manifest_cloud['version'],
			'app_support' => MODULE_SUPPORT_ACCOUNT,
			'bought' => array('app'),
		);
		$template_manifest['cloud_id'] = $template_manifest_cloud['id'];
		$template_manifest['buytime'] = $template_manifest_cloud['buytime'];
		$template_manifest['system_shutdown'] = $template_manifest_cloud['system_shutdown'];
		$template_manifest['system_shutdown_delay_time'] = $template_manifest_cloud['system_shutdown_delay_time'];
		$template_manifest['can_update'] = $template_manifest_cloud['can_update'];
		$template_manifest['service_expiretime'] = empty($template_manifest_cloud['service_expiretime']) ? 0 : $template_manifest_cloud['service_expiretime'];
		$template_manifest['application_type'] = APPLICATION_TYPE_TEMPLATES;
		$template_manifest['label'] = empty($template_manifest_cloud['label']) ? '' : iserializer($template_manifest_cloud['label']);
		$manifest_cloud_list[$template_name] = $template_manifest;
	}
	//模块的处理
	foreach ($cloud_m_query_module as $modulename => $manifest_cloud) {
		if (empty($manifest_cloud) || empty($manifest_cloud['site_branch'])) {
			continue;
		}
		$manifest = array(
			'application' => array(
				'name' => $modulename,
				'title' => $manifest_cloud['title'],
				'version' => $manifest_cloud['version'],
				'logo' => $manifest_cloud['thumb'],
				'last_upgrade_time' => $manifest_cloud['last_upgrade_time'],
			),
			'platform' => array(
				'supports' => array()
			),
		);
		foreach ($module_support_type as $support_key => $support_value) {
			if ($support_key == 'account_support' && $manifest_cloud['site_branch']['app_support'] == $support_value['support']) {
				$manifest['platform']['supports'][] = $support_value['type'];
				continue;
			}
			if ($support_key == 'phoneapp_support' && ($manifest_cloud['site_branch']['android_support'] == $support_value['support'] || $manifest_cloud['site_branch']['ios_support'] == $support_value['support'])) {
				$manifest['platform']['supports'][] = $support_value['type'];
				continue;
			}
			if ($support_key == 'welcome_support' && $manifest_cloud['site_branch']['system_welcome_support'] == $support_value['support']) {
				$manifest['platform']['supports'][] = $support_value['type'];
				continue;
			}
			if ($manifest_cloud['site_branch'][$support_key] == $support_value['support']) {
				$manifest['platform']['supports'][] = $support_value['type'];
			}
		}

		if (empty($manifest['platform']['supports'])) {
			continue;
		}
		$manifest['status'] = $manifest_cloud['status'];
		$manifest['branches'] = $manifest_cloud['branches'];
		$manifest['site_branch'] = $manifest_cloud['site_branch'];
		$manifest['cloud_id'] = $manifest_cloud['id'];
		$manifest['buytime'] = $manifest_cloud['buytime'];
		$manifest['system_shutdown'] = $manifest_cloud['system_shutdown'];
		$manifest['system_shutdown_delay_time'] = $manifest_cloud['system_shutdown_delay_time'];
		$manifest['can_update'] = $manifest_cloud['can_update'];
		$manifest['service_expiretime'] = empty($manifest_cloud['service_expiretime']) ? 0 : $manifest_cloud['service_expiretime'];
		$manifest['application_type'] = APPLICATION_TYPE_MODULE;
		$manifest['label'] = empty($manifest_cloud['label']) ? '' : iserializer($manifest_cloud['label']);
		$manifest['main_module'] = $manifest_cloud['main_module'];
		$manifest_cloud_list[$modulename] = $manifest;
	}

	//没有指定查询模块列表，则获取全部模块查询
	if (empty($modulelist)) {
		$modulelist = pdo_getall('modules', array('issystem !=' => 1));
		$modulelist = array_column($modulelist, null, 'name');
	}
	foreach ($modulelist as $modulename => $module) {
		$module_upgrade_data = array(
			'name' => $modulename,
			'has_new_version' => 0,
			'has_new_branch' => 0,
		);

		if (!empty($pirate_apps) && in_array($modulename, $pirate_apps)) {
			$module_upgrade_data['is_ban'] = 1;
		}
		if (APPLICATION_TYPE_TEMPLATES == $module['application_type']) {
			$module_upgrade_data['application_type'] = APPLICATION_TYPE_TEMPLATES;
			$manifest = ext_template_manifest($modulename, false);
		} else {
			$module_upgrade_data['application_type'] = APPLICATION_TYPE_MODULE;
			$manifest = ext_module_manifest($modulename);
		}

		if (!empty($manifest)) {
			$module_upgrade_data['install_status'] = MODULE_LOCAL_INSTALL;
		} elseif ($manifest_cloud_list[$modulename]) {
			$module_upgrade_data['install_status'] = MODULE_CLOUD_INSTALL;
			$manifest = $manifest_cloud_list[$modulename];
		} else {
			//本地已安装没有manifest也没有cloud信息，默认为本地安装
			$module_upgrade_data['install_status'] = MODULE_LOCAL_INSTALL;
		}

		$module_upgrade_data['logo'] = !empty($module['logo']) ? tomedia($module['logo']) : $manifest['application']['logo'];
		$module_upgrade_data['version'] = $manifest['application']['version'];
		$module_upgrade_data['title'] = $manifest['application']['title'];
		$module_upgrade_data['title_initial'] = get_first_pinyin($manifest['application']['title']);
		$module_upgrade_data['buytime'] = $manifest_cloud_list[$modulename]['buytime'];
		$module_upgrade_data['label'] = $manifest_cloud_list[$modulename]['label'];
		$module_upgrade_data['main_module_name'] = $manifest_cloud_list[$modulename]['main_module'];
		$status = empty($manifest_cloud_list[$modulename]['status']) || empty($manifest_cloud_list[$modulename]['site_branch']['status']) || ($manifest_cloud_list[$modulename]['system_shutdown_delay_time'] && TIMESTAMP > $manifest_cloud_list[$modulename]['system_shutdown_delay_time']) ? STATUS_OFF : STATUS_ON;
		pdo_update('modules', array('label' => $module_upgrade_data['label'], 'status' => $status), array('mid' => $module['mid']));
		//云服务模块已在本地安装，unset后方便后面排查未安装模块
		//云上模块，如果在本地有manifest.xml，以本地模块为主
		unset($manifest_cloud_list[$modulename]);
		$result[$modulename] = array(
			'name' => $modulename,
			'best_version' => $manifest['application']['version'],
		);
		$result[$modulename]['new_version'] = STATUS_OFF;
		if (version_compare($module['version'], $manifest['application']['version']) == '-1') {
			$module_upgrade_data['has_new_version'] = 1;
			$module_upgrade_data['lastupdatetime'] = TIMESTAMP;
			$result[$modulename]['new_version'] = STATUS_ON;
		}

		//本地已安装，没有更新的模块不入表，防止无用数据太多
		if ($module_upgrade_data['install_status'] == MODULE_LOCAL_INSTALL && empty($module_upgrade_data['has_new_version'])) {
			continue;
		}
		$result[$modulename]['new_branch'] = STATUS_OFF;
		if (!empty($manifest['branches']) && $manifest['application_type'] == APPLICATION_TYPE_MODULE) {
			foreach ($manifest['branches'] as &$branch) {
				if ($branch['displayorder'] > $manifest['site_branch']['displayorder'] || ($branch['displayorder'] == $manifest['site_branch']['displayorder'] && $manifest['site_branch']['id'] < intval($branch['id']))) {
					$module_upgrade_data['has_new_branch'] = 1;
					$result[$modulename]['new_branch'] = STATUS_ON;
				}
			}
		}
		if (!empty($manifest['system_shutdown'])) {
			$result[$modulename]['system_shutdown'] = $manifest['system_shutdown'];
			$result[$modulename]['system_shutdown_delay_time'] = date('Y-m-d', $manifest['system_shutdown_delay_time']);
		}
		$result[$modulename]['can_update'] = $manifest['can_update'] ? 1 : 0;
		if (!empty($manifest['service_expiretime'])) {
			$result[$modulename]['service_expiretime'] = date('Y-m-d H:i:s', $manifest['service_expiretime']);
			if ($manifest['service_expiretime'] < time()) {
				$result[$modulename]['service_expire'] = STATUS_ON;
			}
		} else {
			$result[$modulename]['service_expire'] = STATUS_OFF;
		}
		if (!$manifest['status'] || $manifest['system_shutdown'] == 2) {
			$result[$modulename]['offsell'] = STATUS_ON;
		} else {
			$response[$modulename]['offsell'] = STATUS_OFF;
		}

		if (!empty($manifest['platform']['supports'])) {
			foreach ($module_support_type as $support_key => $support_value) {
				if (in_array($support_value['type'], $manifest['platform']['supports'])) {
					$module_upgrade_data[$support_key] = $support_value['support'];
				} else {
					$module_upgrade_data[$support_key] = $support_value['not_support'];
				}
			}
		}

		$module_cloud_upgrade = table('modules_cloud')->getByName($modulename);

		if (empty($module_cloud_upgrade)) {
			pdo_insert('modules_cloud', $module_upgrade_data);
		} else {
			pdo_update('modules_cloud', $module_upgrade_data, array('name' => $modulename));
		}
	}

	if (!empty($manifest_cloud_list)) {
		foreach ($manifest_cloud_list as $modulename => $manifest) {
			$module_upgrade_data = array(
				'name' => $modulename,
				'application_type' => $manifest['application_type'],
				'has_new_version' => 0,
				'has_new_branch' => 0,
				'install_status' => MODULE_CLOUD_UNINSTALL,
				'logo' => $manifest['application']['logo'],
				'version' => $manifest['application']['version'],
				'title' => $manifest['application']['title'],
				'title_initial' => get_first_pinyin($manifest['application']['title']),
				'lastupdatetime' => $manifest['application']['last_upgrade_time'],
				'buytime' => $manifest['buytime'],
				'cloud_id' => $manifest['cloud_id'],
				'label' => $manifest['label'],
				'main_module_name' => $manifest['main_module']
			);
			if (!empty($manifest['platform']['supports'])) {
				foreach ($module_support_type as $support_key => $support_value) {
					if (in_array($support_value['type'], $manifest['platform']['supports'])) {
						$module_upgrade_data[$support_key] = $support_value['support'];
					} else {
						$module_upgrade_data[$support_key] = $support_value['not_support'];
					}
				}
			}

			$module_recycle_info = table('modules_recycle')->searchWithNameType($modulename, MODULE_RECYCLE_UNINSTALL_IGNORE)->get();
			if (!empty($module_recycle_info)) {
				foreach ($module_support_type as $support => $value) {
					if ($module_recycle_info[$support] == 1) {
						$module_upgrade_data[$support] = $value['not_support'];
					}
				}
			}

			$module_cloud_upgrade = table('modules_cloud')->getByName($modulename);
			if (empty($module_cloud_upgrade)) {
				pdo_insert('modules_cloud', $module_upgrade_data);
			} else {
				pdo_update('modules_cloud', $module_upgrade_data, array('name' => $modulename));
			}
		}
	}
	return $result;
}

function module_check_notinstalled_support($module, $manifest_support) {
	if (empty($manifest_support)) {
		return array();
	}
	$has_notinstalled_support = false;
	$notinstalled_support = array();
	$module_support_type = module_support_type();

	foreach ($manifest_support as $support) {
		if ($support == 'app') {
			$support = 'account';
		} elseif ($support == 'system_welcome') {
			$support = 'welcome';
		} elseif ($support == 'android' || $support == 'ios') {
			$support = 'phoneapp';
		}
		$support .= '_support';
		if (!in_array($support, array_keys($module_support_type))) {
			continue;
		}

		if ($module[$support] != $module_support_type[$support]['support']) {
			$has_notinstalled_support = true;
			$notinstalled_support[$support] = $module_support_type[$support]['support'];
		} else {
			$notinstalled_support[$support] = $module_support_type[$support]['not_support'];
		}
	}
	if ($has_notinstalled_support) {
		return $notinstalled_support;
	} else {
		return array();
	}
}

/**
 * 将模块加入到应用权限组中
 * @param $module 必须包含模块的name和支持
 */
function module_add_to_uni_group($module, $uni_group_id, $support) {
	if (!in_array($support, array_keys(module_support_type()))) {
		return error(1, '支持类型不存在');
	}
	if (empty($module[$support]) || $module[$support] != MODULE_SUPPORT_ACCOUNT) {
		return error(1, '模块支持不存在');
	}
	$unigroup_table = table('uni_group');
	$uni_group = $unigroup_table->getById($uni_group_id);
	if (empty($uni_group)) {
		return error(1, '应用权限组不存在');
	}
	if (!empty($uni_group['modules'])) {
		$uni_group['modules'] = iunserializer($uni_group['modules']);
	}
	$update_data = $uni_group['modules'];

	$key = str_replace('_support', '', $support);
	$key = $key == 'account' ? 'modules' : $key;
	if (!in_array($module['name'], $update_data[$key])) {
		$update_data[$key][] = $module['name'];
	}
	return $unigroup_table->fill('modules', iserializer($update_data))->where('id', $uni_group_id)->save();
}

/**
 * 停用或删除模块
 */
function module_recycle($modulename, $type, $support) {
	global $_W;
	$module_support_types = module_support_type();
	$module_support_type = $module_support_types[$support]['type'];
	$all_support = array_keys($module_support_types);

	# 停用模块时,删除相关权限和记录
	if ($type == MODULE_RECYCLE_INSTALL_DISABLED) {
		table('system_welcome_binddomain')->where(array('module_name' => $modulename))->delete();
		$uni_modules_table = table('uni_modules');
		$uni_accounts = $uni_modules_table->where('module_name', $modulename)->getall('uniacid');
		if (!empty($uni_accounts)) {
			foreach ($uni_accounts as $uni_account_val) {
				$account_info = uni_fetch($uni_account_val['uniacid']);
				if ($account_info['type_sign'] == $module_support_type) {
					$uni_modules_table->deleteUniModules($modulename, $uni_account_val['uniacid']);
				}
			}
		}

		$lastuse_table = table('users_lastuse');
		$lastuse_accounts = switch_getall_lastuse_by_module($modulename);
		if (!empty($lastuse_accounts)) {
			foreach ($lastuse_accounts as $lastuse_account_val) {
				$lastuse_account_info = uni_fetch($lastuse_account_val['uniacid']);
				if ($lastuse_account_info['type_sign'] == $module_support_type) {
					$lastuse_table->searchWithUid($_W['uid']);
					$lastuse_table->searchWithUniacid($lastuse_account_val['uniacid']);
					$lastuse_table->searchWithModule($modulename);
					$lastuse_table->delete();
				}
			}
		}
	}

	if (!in_array($support, $all_support)) {
		return false;
	}
	if ($type == MODULE_RECYCLE_UNINSTALL_IGNORE) {
		table('modules_cloud')->fill(array($support => 1, 'module_status' => MODULE_CLOUD_UNINSTALL_NORMAL))->where('name', $modulename)->save();
	}
	$module_recycle = table('modules_recycle');
	$record = $module_recycle->searchWithNameType($modulename, $type)->get();
	if (empty($record)) {
		return $module_recycle->fill(array('name' => $modulename, 'type' => $type, $support => 1))->save();
	} else {
		$record[$support] = 1;
		return $module_recycle->where('id', $record['id'])->fill($record)->save();
	}
}

/**
 * 恢复停用或删除的模块
 */
function module_cancel_recycle($modulename, $type, $support) {
	$all_support = array_keys(module_support_type());
	if (!in_array($support, $all_support)) {
		return false;
	}
	$module_recycle = table('modules_recycle');
	$record = $module_recycle->searchWithNameType($modulename, $type)->get();
	if (empty($record)) {
		return true;
	}
	$record[$support] = 0;
	$is_update = false;
	foreach ($all_support as $s) {
		if ($record[$s] == 1) {
			$is_update = true;
		}
	}
	if ($type == MODULE_RECYCLE_UNINSTALL_IGNORE) {
		table('modules_cloud')->fill(array($support => 2, 'module_status' => MODULE_CLOUD_UNINSTALL_NORMAL))->where('name', $modulename)->save();
	}
	if ($is_update) {
		return $module_recycle->where('id', $record['id'])->fill($record)->save();
	} else {
		return $module_recycle->where('id', $record['id'])->delete();
	}
}

/**
 * @param $module_name
 * @return int
 */
function module_get_direct_enter_status($module_name) {
	global $_W;
	if (empty($module_name)) {
		return STATUS_OFF;
	}
	$module_setting = table('uni_account_modules')->getByUniacidAndModule($module_name, $_W['uniacid']);
	$status = !empty($module_setting['settings']) && $module_setting['settings']['direct_enter'] == STATUS_ON ? STATUS_ON : STATUS_OFF;
	return $status;
}
/**
 * @param $module_name
 * @return bool
 */
function module_change_direct_enter_status($module_name) {
	global $_W;
	if (empty($module_name)) {
		return false;
	}
	$module_setting = table('uni_account_modules')->getByUniacidAndModule($module_name, $_W['uniacid']);
	$direct_enter_status = !empty($module_setting['settings']) && $module_setting['settings']['direct_enter'] == STATUS_ON ? STATUS_OFF : STATUS_ON;
	if (empty($module_setting)) {
		$data = array('direct_enter' => $direct_enter_status);
		$result = table('uni_account_modules')->fill(array('settings' => iserializer($data), 'uniacid' => $_W['uniacid'], 'module' => $module_name))->save();
	} else {
		$module_setting['settings']['direct_enter'] = $direct_enter_status;
		$data = $module_setting['settings'];
		$result = table('uni_account_modules')->fill(array('settings' => iserializer($data)))->where('module', $module_name)->where('uniacid', $_W['uniacid'])->save();
	}
	return $result ? true : false;
}

function module_delete_store_wish_goods($module_name, $support_name) {
	load()->model('store');
	$all_type = store_goods_type_info();
	foreach ($all_type as $info) {
		if ($info['group'] == 'module' && $support_name == $info['sign'] . '_support') {
			$type = $info['type'];
			break;
		}
	}
	if (!empty($type)) {
		pdo_update('site_store_goods', array('status' => 2), array('module' => $module_name, 'type' => $type));
	}
	return true;
}

function module_expire_notice() {
	$module_expire = setting_load('module_expire');
	$module_expire = !empty($module_expire['module_expire']) ? $module_expire['module_expire'] : array();
	foreach ($module_expire as $value) {
		if ($value['status'] == 1) {
			$expire_notice = $value['notice'];
			break;
		}
	}
	if (empty($expire_notice)) {
		$system_module_expire = setting_load('system_module_expire');
		$expire_notice = !empty($system_module_expire['system_module_expire']) ? $system_module_expire['system_module_expire'] : '您访问的功能模块不存在，请重新进入';
	}
	return $expire_notice;
}

/**
 * 获取到期的应用
 */
function module_expired_list() {
	$cachekey = cache_system_key('expired_modules');
	$expired_modules_cache = cache_load($cachekey);
	if (!empty($expired_modules_cache)) {
		return $expired_modules_cache;
	}
	$cloud_m_query_module_pageinfo = cloud_m_query(array(), 1);
	if (is_error($cloud_m_query_module_pageinfo)) {
		return $cloud_m_query_module_pageinfo;
	}
	$cloud_m_query_module = $cloud_m_query_module_pageinfo['data'];
	if ($cloud_m_query_module_pageinfo['page'] > 1) {
		for ($i = 2;$i <= $cloud_m_query_module_pageinfo['page']; $i++) {
			$cloud_m_query_module_i = cloud_m_query(array(), $i);
			$cloud_m_query_module = array_merge($cloud_m_query_module, $cloud_m_query_module_i['data']);
		}
	}
	$module_list = pdo_getall('modules', array('issystem !=' => 1, 'status' => 1), array('name'));
	$expired_modules = array();
	if (!empty($module_list)) {
		foreach ($module_list as $module_name) {
			$module = $cloud_m_query_module[$module_name['name']];
			if (empty($module) || empty($module['site_branch']['status']) || !empty($module['system_shutdown_delay_time'])) {
				continue;
			}
			if (!empty($module['service_expiretime']) && $module['service_expiretime'] < TIMESTAMP && $module['site_branch']['status']) {
				$expired_modules[] = $module_name['name'];
			}
		}
	}
	cache_write($cachekey, $expired_modules);
	return $expired_modules;
}

/**
 * 获取到期应用的名称
 * @param $module_expired_list
 * @param $modules_name
 */
function module_expired_diff($module_expired_list, $modules_name) {
	$expired_modules = array_intersect($module_expired_list, $modules_name);
	if ($expired_modules) {
		$expired_modules = pdo_getall('modules', array('name IN' => $expired_modules), array('title'), 'title');
		$expired_modules_name = implode('，', array_column($expired_modules, 'title'));
		return $expired_modules_name;
	}
	return '';
}

/**
 * 根据应用权限组 id 获取应用标识
 * @param array $group_id
 * @return array
 */
function module_name_list($group_id = array()) {
	$module_name_list = array();
	if (empty($group_id)) {
		return $module_name_list;
	}
	if (!is_array($group_id)) {
		$group_id = explode(',', $group_id);
	}
	$group_module = pdo_getall('uni_group', array('id IN ' => $group_id), array('modules'));//暂时不考虑 templates 字段
	if (empty($group_module)) {
		return $module_name_list;
	}
	foreach ($group_module as $modules) {
		if (empty($modules['modules'])) {
			continue;
		}
		$modules_name = array_reduce(iunserializer($modules['modules']), 'array_merge', array());
		$module_name_list = array_merge($module_name_list, $modules_name);
	}

	return array_unique($module_name_list);
}

/**
 * 根据开发模式获取本地安装应用
 * @param string $message_type
 * @return bool
 */
function module_local_dev($message_type = '') {
	global $_W,$controller,$action,$do;
	$api_whitelist = array(
		'c=cloud&a=newprocess&do=module_build', //应用安装和升级
		'c=module&a=group&do=save', //保存应用权限组
		'c=utility&a=group&do=get_module_group_detail_info', //编辑应用权限组
		'c=module&a=group&do=del', //删除应用权限组
		'c=account&a=post&do=', //平台列表下的平台可用应用
		'c=account&a=post&do=modules_tpl', //平台详情下的平台可用应用
		'c=account&a=post-user&do=edit', //平台使用者
		'c=account&a=post-user&do=set_manager', //修改平台使用者
		'c=miniapp&a=manage&do=display', //平台版本管理
		'c=utility&a=modules&do=modules', //平台版本管理修改应用
		'c=user&a=edit&do=', //用户相关权限
		'c=user&a=create&do=check_user_info', //添加用户时检测用户是否已创建
		'c=utility&a=group&do=get_user_group_detail_info', //用户权限组详情
		'c=user&a=group&do=save', //用户权限组保存
	);
	$cado = 'c=' . $controller . '&a=' . $action . '&do=' . $do;
	if (!empty($_W['config']['setting']['local_dev']) || !in_array($cado, $api_whitelist)) {
		return true;
	}
	$cachekey = cache_system_key('local_dev_modules');
	$local_module_cache = cache_load($cachekey);
	if (empty($local_module_cache)) {
		$local_module = pdo_get('modules', array('issystem' => '0', 'from' => 'local', 'createtime >' => 1631695337));
		$local_module_cache = empty($local_module) ? STATUS_OFF : STATUS_ON;
		cache_write($cachekey, $local_module_cache);
	}
	//验证 uid 是防止云服务 api 回调时出问题
	if ($local_module_cache && !empty($_W['uid'])) {
		$message = empty($_W['isw7_request']) ? '运营模式下请联系管理员卸载本地应用！' : '打开开发模式进入应用管理-需卸载应用列表，卸载完毕后关闭开发模式，恢复正常使用！';
		switch ($message_type) {
			case 'message':
				message($message);
				break;
			case 'itoast':
				itoast($message);
				break;
			case 'iajax':
				iajax(-1, $message);
				break;
			default:
				empty($_W['isajax']) ? itoast($message) : iajax(-1, $message);
				break;
		}
	}

	return true;
}
