<?php
/**
 * [WeEngine System] Copyright (c) 2014 W7.CC
 * $sn$
 */
define('IN_MOBILE', true);

require __DIR__ . '/../framework/bootstrap.inc.php';
require IA_ROOT . '/app/common/bootstrap.app.inc.php';

$acl = array(
	'home' => array(
		'default' => 'home',
	),
	'mc' => array(
		'default' => 'home'
	)
);

if ($_W['setting']['copyright']['status'] == 1) {
	$_W['siteclose'] = true;
	message('抱歉，站点已关闭，关闭原因：' . $_W['setting']['copyright']['reason']);
}
module_local_dev('message');
// 多微站id(主要用于预览功能【区分导航链接】)
$multiid = intval($_GPC['t']);
if (empty($multiid)) {
	// 获取指定的默认微站
	$multiid = intval($unisetting['default_site']);
	unset($setting);
}

$multi = table('site_multi')->getById($multiid, $_W['uniacid']);

$multi['site_info'] = @iunserializer($multi['site_info']);

$styleid = !empty($_GPC['s']) ? intval($_GPC['s']) : intval($multi['styleid']);
$style = table('site_styles')->getById($styleid, $_W['uniacid']);

$templates = uni_templates();
$templateid = intval($style['templateid']);
$template = $templates[$templateid];

$_W['template'] = !empty($template) ? $template['name'] : 'default';
$_W['styles'] = array();

//对于设置的默认风格，判断该用户有没有该风格对应的模板的使用权限，如果没有，直接default，不再加载该风格自定义的变量。
if (!empty($template) && !empty($style)) {
	$stylevars = table('site_styles_vars')
		->select(array('variable', 'content'))
		->where(array(
			'uniacid' => $_W['uniacid'],
			'styleid' => $styleid
		))
		->getall();
	if (!empty($stylevars)) {
		foreach ($stylevars as $row) {
			if (strexists($row['variable'], 'img')) {
				$row['content'] = tomedia($row['content']);
			}
			$_W['styles'][$row['variable']] = $row['content'];
		}
	}
	unset($stylevars, $row, $sql, $params);
}

$_W['page'] = array();
$_W['page']['title'] = $multi['title'];
if (is_array($multi['site_info'])) {
	$_W['page'] = array_merge($_W['page'], $multi['site_info']);
}
unset($multi, $styleid, $style, $templateid, $template, $templates);

if ($controller == 'wechat' && $action == 'card' && $do == 'use') {
	header("location: index.php?i={$_W['uniacid']}&c=entry&m=paycenter&do=consume&encrypt_code=" . safe_gpc_string($_GPC['encrypt_code']) . "&card_id=" . intval($_GPC['card_id']) . "&openid=" . safe_gpc_string($_GPC['openid']) . "&source=" . safe_gpc_string($_GPC['source']));
	exit;
}
$controllers = array();
$handle = opendir(IA_ROOT . '/app/source/');
if (!empty($handle)) {
	while ($dir = readdir($handle)) {
		if ($dir != '.' && $dir != '..') {
			$controllers[] = $dir;
		}
	}
}
if (!in_array($controller, $controllers)) {
	$controller = 'home';
}
$init = IA_ROOT . "/app/source/{$controller}/__init.php";
if (is_file($init)) {
	require $init;
}

$actions = array();
$handle = opendir(IA_ROOT . '/app/source/' . $controller);
if (!empty($handle)) {
	while ($dir = readdir($handle)) {
		if ($dir != '.' && $dir != '..' && strexists($dir, '.ctrl.php')) {
			$dir = str_replace('.ctrl.php', '', $dir);
			$actions[] = $dir;
		}
	}
}

if (empty($actions)) {
	header("location: index.php?i={$_W['uniacid']}&c=home?refresh");
}
if (!in_array($action, $actions)) {
	$action = $acl[$controller]['default'];
}
if (!in_array($action, $actions)) {
	$action = $actions[0];
}
require _forward($controller, $action);

function _forward($c, $a) {
	$file = IA_ROOT . '/app/source/' . $c . '/' . $a . '.ctrl.php';
	return $file;
}
