/*
Feathers
Copyright 2012-2015 Bowler Hat LLC. All Rights Reserved.

This program is free software. You can redistribute and/or modify it in
accordance with the terms of the accompanying license agreement.
*/
package feathers.layout
{
	/**
	 * Constants for horizontal alignment of items in a layout.
	 *
	 * <p>Note: Some constants may not be valid for certain properties. Please
	 * see the description of the property in the API reference for full
	 * details.</p>
	 */
	public class HorizontalAlign
	{
		/**
		 * The items in the layout will be horizontally aligned to the left of
		 * the bounds.
		 */
		public static const LEFT:String = "left";

		/**
		 * The items in the layout will be horizontally aligned to the center of
		 * the bounds.
		 */
		public static const CENTER:String = "center";

		/**
		 * The items in the layout will be horizontally aligned to the right of
		 * the bounds.
		 */
		public static const RIGHT:String = "right";

		/**
		 * The items in the layout will fill the width of the bounds.
		 */
		public static const JUSTIFY:String = "justify";
	}
}
