﻿using System.Collections.Generic;

namespace AcapellaDownloader
{
    public enum Gender
    {
        Female,
        Male
    }

    public class Voice
    {
        public string Name;
        public Gender Gender;
        public string Lang;
        public string VoiceId;

        public Voice(string name, Gender gender, string lang, string voiceId)
        {
            Name = name;
            Gender = gender;
            Lang = lang;
            VoiceId = voiceId;
        }
    }

    public static class Voices
    {
        public static List<Voice> VoiceList;

        static Voices()
        {
            VoiceList = new List<Voice>
            {
                new Voice("Leila (neural voice)", Gender.Female, "ar_sa", "leila_nt22k"),
                new Voice("Jalal (premium voice)", Gender.Male, "ar_sa", "jalal22k"),
                new Voice("Jalal (neural premium voice)", Gender.Male, "ar_sa", "jalal_nt22k"),
                new Voice("Mehdi", Gender.Male, "ar_sa", "mehdi22k"),
                new Voice("Mehdi (neural voice)", Gender.Male, "ar_sa", "mehdi_nt22k"),
                new Voice("Nizar", Gender.Male, "ar_sa", "nizar22k"),
                new Voice("Nizar (neural voice)", Gender.Male, "ar_sa", "nizar_nt22k"),
                new Voice("Salma", Gender.Female, "ar_sa", "salma22k"),
                new Voice("Salma (neural voice)", Gender.Female, "ar_sa", "salma_nt22k"),
                new Voice("Laia", Gender.Female, "ca_es", "laia22k"),
                new Voice("Laia (neural voice)", Gender.Female, "ca_es", "laia_nt22k"),
                new Voice("Eliska", Gender.Female, "cs_cz", "eliska22k"),
                new Voice("Eliska (neural voice)", Gender.Female, "cs_cz", "eliska_nt22k"),
                new Voice("Mette", Gender.Female, "da_dk", "mette22k"),
                new Voice("Mette (neural voice)", Gender.Female, "da_dk", "mette_nt22k"),
                new Voice("Rasmus", Gender.Male, "da_dk", "rasmus22k"),
                new Voice("Rasmus (neural voice)", Gender.Male, "da_dk", "rasmus_nt22k"),
                new Voice("Rikke", Gender.Female, "da_dk", "rikke22k"),
                new Voice("Rikke (neural premium voice)", Gender.Female, "da_dk", "rikke_nt22k"),
                new Voice("Zoe", Gender.Female, "be", "zoe22k"),
                new Voice("Zoe (neural voice)", Gender.Female, "be", "zoe_nt22k"),
                new Voice("Christinabtob (premium voice)", Gender.Female, "be", "christinabtob22k"),
                new Voice("Christinabtob (neural premium voice)", Gender.Female, "be", "christinabtob_nt22k"),
                new Voice("Jeroen", Gender.Male, "be", "jeroen22k"),
                new Voice("Jeroen (neural voice)", Gender.Male, "be", "jeroen_nt22k"),
                new Voice("Sofie", Gender.Female, "be", "sofie22k"),
                new Voice("Sofie (neural voice)", Gender.Female, "be", "sofie_nt22k"),
                new Voice("Jasmijn", Gender.Female, "nl", "jasmijn22k"),
                new Voice("Jasmijn (neural voice)", Gender.Female, "nl", "jasmijn_nt22k"),
                new Voice("Tessabtob (premium voice)", Gender.Female, "nl", "tessabtob22k"),
                new Voice("Tessabtob (neural premium voice)", Gender.Female, "nl", "tessabtob_nt22k"),
                new Voice("Daan", Gender.Male, "nl", "daan22k"),
                new Voice("Daan (neural voice)", Gender.Male, "nl", "daan_nt22k"),
                new Voice("Femke", Gender.Female, "nl", "femke22k"),
                new Voice("Femke (neural voice)", Gender.Female, "nl", "femke_nt22k"),
                new Voice("Max", Gender.Male, "nl", "max22k"),
                new Voice("Max (neural voice)", Gender.Male, "nl", "max_nt22k"),
                new Voice("Tyler", Gender.Male, "en_au", "tyler22k"),
                new Voice("Tyler (neural voice)", Gender.Male, "en_au", "tyler_nt22k"),
                new Voice("Lisa", Gender.Female, "en_au", "lisa22k"),
                new Voice("Lisa (neural voice)", Gender.Female, "en_au", "lisa_nt22k"),
                new Voice("Deepa", Gender.Female, "en_in", "deepa22k"),
                new Voice("Deepa (neural voice)", Gender.Female, "en_in", "deepa_nt22k"),
                new Voice("Rhona", Gender.Female, "gd_GB", "rhona22k"),
                new Voice("Rhona (neural voice)", Gender.Female, "gd_GB", "rhona_nt22k"),
                new Voice("Rachel", Gender.Female, "en_gb", "rachel22k"),
                new Voice("Rachel (neural voice)", Gender.Female, "en_gb", "rachel_nt22k"),
                new Voice("RachelTransport (premium voice)", Gender.Female, "en_gb", "racheltransport22k"),
                new Voice("Sophiabtob (premium voice)", Gender.Female, "en_gb", "sophiabtob22k"),
                new Voice("Sophiabtob (neural premium voice)", Gender.Female, "en_gb", "sophiabtob_nt22k"),
                new Voice("Graham", Gender.Male, "en_gb", "graham22k"),
                new Voice("Lucy", Gender.Female, "en_gb", "lucy22k"),
                new Voice("Lucy (neural voice)", Gender.Female, "en_gb", "lucy_nt22k"),
                new Voice("Peter", Gender.Male, "en_gb", "peter22k"),
                new Voice("Peter (neural voice)", Gender.Male, "en_gb", "peter_nt22k"),
                new Voice("QueenElizabeth (her majesty)", Gender.Female, "en_gb", "queenelizabeth22k"),
                new Voice("QueenElizabeth (neural voice)", Gender.Female, "en_gb", "queenelizabeth_nt22k"),
                new Voice("Sharon", Gender.Female, "en_us", "sharon22k"),
                new Voice("Sharon (neural voice)", Gender.Female, "en_us", "sharon_nt22k"),
                new Voice("Lily (premium voice)", Gender.Female, "en_us", "lily22k"),
                new Voice("Lily (neural premium voice)", Gender.Female, "en_us", "lily_nt22k"),
                new Voice("Darius", Gender.Male, "en_us", "darius22k"),
                new Voice("Darius (neural voice)", Gender.Male, "en_us", "darius_nt22k"),
                new Voice("Tamira", Gender.Female, "en_us", "tamira22k"),
                new Voice("Tamira (neural voice)", Gender.Female, "en_us", "tamira_nt22k"),
                new Voice("Taylor", Gender.Female, "en_us", "taylor22k"),
                new Voice("Taylor (neural voice)", Gender.Female, "en_us", "taylor_nt22k"),
                new Voice("Karen", Gender.Female, "en_us", "karen22k"),
                new Voice("Karen (neural voice)", Gender.Female, "en_us", "karen_nt22k"),
                new Voice("Laura", Gender.Female, "en_us", "laura22k"),
                new Voice("Laura (neural voice)", Gender.Female, "en_us", "laura_nt22k"),
                new Voice("Micah", Gender.Male, "en_us", "micah22k"),
                new Voice("Rod", Gender.Male, "en_us", "rod22k"),
                new Voice("Rod (neural voice)", Gender.Male, "en_us", "rod_nt22k"),
                new Voice("Ryan", Gender.Male, "en_us", "ryan22k"),
                new Voice("Ryan (neural voice)", Gender.Male, "en_us", "ryan_nt22k"),
                new Voice("Saul", Gender.Male, "en_us", "saul22k"),
                new Voice("Saul (neural voice)", Gender.Male, "en_us", "saul_nt22k"),
                new Voice("Tracy", Gender.Female, "en_us", "tracy22k"),
                new Voice("Tracy (neural voice)", Gender.Female, "en_us", "tracy_nt22k"),
                new Voice("Will", Gender.Male, "en_us", "will22k"),
                new Voice("Will (neural voice)", Gender.Male, "en_us", "will_nt22k"),
                new Voice("Hanna", Gender.Female, "fo", "hanna22k"),
                new Voice("Hanna (neural voice)", Gender.Female, "fo", "hanna_nt22k"),
                new Voice("Hanus", Gender.Male, "fo", "hanus22k"),
                new Voice("Hanus (neural voice)", Gender.Male, "fo", "hanus_nt22k"),
                new Voice("Sanna", Gender.Female, "fi", "sanna22k"),
                new Voice("Sanna (neural voice)", Gender.Female, "fi", "sanna_nt22k"),
                new Voice("Manon-be", Gender.Female, "be", "manon-be22k"),
                new Voice("Alice-be", Gender.Female, "be", "alice-be22k"),
                new Voice("Anais-be", Gender.Female, "be", "anais-be22k"),
                new Voice("Antoine-be", Gender.Male, "be", "antoine-be22k"),
                new Voice("Bruno-be", Gender.Male, "be", "bruno-be22k"),
                new Voice("Claire-be", Gender.Female, "be", "claire-be22k"),
                new Voice("Julie-be", Gender.Female, "be", "julie-be22k"),
                new Voice("Margaux-be", Gender.Female, "be", "margaux-be22k"),
                new Voice("Louise", Gender.Female, "fr_ca", "louise22k"),
                new Voice("Louise (neural voice)", Gender.Female, "fr_ca", "louise_nt22k"),
                new Voice("Anthony", Gender.Male, "fr_ca", "anthony22k"),
                new Voice("Anthony (neural voice)", Gender.Male, "fr_ca", "anthony_nt22k"),
                new Voice("Manon", Gender.Female, "fr-fr", "manon22k"),
                new Voice("Manon (neural voice)", Gender.Female, "fr-fr", "manon_nt22k"),
                new Voice("Constance (premium voice)", Gender.Female, "fr-fr", "constance22k"),
                new Voice("Constance (neural premium voice)", Gender.Female, "fr-fr", "constance_nt22k"),
                new Voice("Alice", Gender.Female, "fr-fr", "alice22k"),
                new Voice("Alice (neural voice)", Gender.Female, "fr-fr", "alice_nt22k"),
                new Voice("Anais", Gender.Female, "fr-fr", "anais22k"),
                new Voice("Anais (neural voice)", Gender.Female, "fr-fr", "anais_nt22k"),
                new Voice("Anaisbtob (premium voice)", Gender.Female, "fr-fr", "anaisbtob22k"),
                new Voice("Anaisbtob (neural premium voice)", Gender.Female, "fr-fr", "anaisbtob_nt22k"),
                new Voice("Antoine", Gender.Male, "fr-fr", "antoine22k"),
                new Voice("Antoine (neural voice)", Gender.Male, "fr-fr", "antoine_nt22k"),
                new Voice("Bruno", Gender.Male, "fr-fr", "bruno22k"),
                new Voice("Bruno (neural voice)", Gender.Male, "fr-fr", "bruno_nt22k"),
                new Voice("Claire", Gender.Female, "fr-fr", "claire22k"),
                new Voice("Claire (neural voice)", Gender.Female, "fr-fr", "claire_nt22k"),
                new Voice("Julie", Gender.Female, "fr-fr", "julie22k"),
                new Voice("Julie (neural voice)", Gender.Female, "fr-fr", "julie_nt22k"),
                new Voice("Margaux", Gender.Female, "fr-fr", "margaux22k"),
                new Voice("Margaux (neural voice)", Gender.Female, "fr-fr", "margaux_nt22k"),
                new Voice("Claudia", Gender.Female, "de", "claudia22k"),
                new Voice("Claudia (neural voice)", Gender.Female, "de", "claudia_nt22k"),
                new Voice("Ankebtob (premium voice)", Gender.Female, "de", "ankebtob22k"),
                new Voice("Ankebtob (neural premium voice)", Gender.Female, "de", "ankebtob_nt22k"),
                new Voice("Andreas", Gender.Male, "de", "andreas22k"),
                new Voice("Andreas (neural voice)", Gender.Male, "de", "andreas_nt22k"),
                new Voice("Julia", Gender.Female, "de", "julia22k"),
                new Voice("Julia (neural voice)", Gender.Female, "de", "julia_nt22k"),
                new Voice("Klaus", Gender.Male, "de", "klaus22k"),
                new Voice("Klaus (neural voice)", Gender.Male, "de", "klaus_nt22k"),
                new Voice("Sarah", Gender.Female, "de", "sarah22k"),
                new Voice("Sarah (neural voice)", Gender.Female, "de", "sarah_nt22k"),
                new Voice("Dimitris", Gender.Male, "el_gr", "dimitris22k"),
                new Voice("Dimitris (neural voice)", Gender.Male, "el_gr", "dimitris_nt22k"),
                new Voice("Fabiana", Gender.Female, "it", "fabiana22k"),
                new Voice("Fabiana (neural voice)", Gender.Female, "it", "fabiana_nt22k"),
                new Voice("Barbarabtob (premium voice)", Gender.Female, "it", "barbarabtob22k"),
                new Voice("Barbarabtob (neural premium voice)", Gender.Female, "it", "barbarabtob_nt22k"),
                new Voice("Chiara", Gender.Female, "it", "chiara22k"),
                new Voice("Chiara (neural voice)", Gender.Female, "it", "chiara_nt22k"),
                new Voice("Vittorio", Gender.Male, "it", "vittorio22k"),
                new Voice("Vittorio (neural voice)", Gender.Male, "it", "vittorio_nt22k"),
                new Voice("Sakura", Gender.Female, "ja_jp", "sakura22k"),
                new Voice("Sakura (neural voice)", Gender.Female, "ja_jp", "sakura_nt22k"),
                new Voice("Minji", Gender.Female, "kr", "minji22k"),
                new Voice("Minji (neural voice)", Gender.Female, "kr", "minji_nt22k"),
                new Voice("Lulu", Gender.Female, "zh_cn", "lulu22k"),
                new Voice("Lulu (neural voice)", Gender.Female, "zh_cn", "lulu_nt22k"),
                new Voice("Bente", Gender.Female, "no", "bente22k"),
                new Voice("Bente (neural voice)", Gender.Female, "no", "bente_nt22k"),
                new Voice("Ida (premium voice)", Gender.Female, "no", "ida22k"),
                new Voice("Ida (neural premium voice)", Gender.Female, "no", "ida_nt22k"),
                new Voice("Kari", Gender.Female, "no", "kari22k"),
                new Voice("Kari (neural voice)", Gender.Female, "no", "kari_nt22k"),
                new Voice("Olav", Gender.Male, "no", "olav22k"),
                new Voice("Olav (neural voice)", Gender.Male, "no", "olav_nt22k"),
                new Voice("Ania", Gender.Female, "pl", "ania22k"),
                new Voice("Ania (neural voice)", Gender.Female, "pl", "ania_nt22k"),
                new Voice("Gosia (premium voice)", Gender.Female, "pl", "gosia22k"),
                new Voice("Gosia (neural premium voice)", Gender.Female, "pl", "gosia_nt22k"),
                new Voice("Piotr", Gender.Male, "pl", "piotr22k"),
                new Voice("Piotr (neural voice)", Gender.Male, "pl", "piotr_nt22k"),
                new Voice("Marcia", Gender.Female, "br", "marcia22k"),
                new Voice("Marcia (neural voice)", Gender.Female, "br", "marcia_nt22k"),
                new Voice("Gabriela (premium voice)", Gender.Female, "br", "gabriela22k"),
                new Voice("Gabriela (neural premium voice)", Gender.Female, "br", "gabriela_nt22k"),
                new Voice("Isabel", Gender.Female, "pt", "isabel22k"),
                new Voice("Isabel (neural voice)", Gender.Female, "pt", "isabel_nt22k"),
                new Voice("Alyona", Gender.Female, "ru", "alyona22k"),
                new Voice("Alyona (neural voice)", Gender.Female, "ru", "alyona_nt22k"),
                new Voice("Lena (premium voice)", Gender.Female, "ru", "lena22k"),
                new Voice("Lena (neural premium voice)", Gender.Female, "ru", "lena_nt22k"),
                new Voice("Biera", Gender.Female, "se", "biera_hmm_22k"),
                new Voice("Elle", Gender.Female, "se", "elle_hmm_22k"),
                new Voice("Ines", Gender.Female, "es", "ines22k"),
                new Voice("Ines (neural voice)", Gender.Female, "es", "ines_nt22k"),
                new Voice("Antonio", Gender.Male, "es", "antonio22k"),
                new Voice("Antonio (neural voice)", Gender.Male, "es", "antonio_nt22k"),
                new Voice("Anabtob (premium voice)", Gender.Female, "es", "anabtob22k"),
                new Voice("Anabtob (neural premium voice)", Gender.Female, "es", "anabtob_nt22k"),
                new Voice("Elenabtob (premium voice)", Gender.Female, "es", "elenabtob22k"),
                new Voice("Elenabtob (neural voice)", Gender.Female, "es", "elenabtob_nt22k"),
                new Voice("Maria", Gender.Female, "es", "maria22k"),
                new Voice("Maria (neural voice)", Gender.Female, "es", "maria_nt22k"),
                new Voice("Rodrigo", Gender.Male, "es_us", "rodrigo22k"),
                new Voice("Rodrigo (neural voice)", Gender.Male, "es_us", "rodrigo_nt22k"),
                new Voice("Rosa", Gender.Female, "es_us", "rosa22k"),
                new Voice("Rosa (neural voice)", Gender.Female, "es_us", "rosa_nt22k"),
                new Voice("Elin", Gender.Female, "se", "elin22k"),
                new Voice("Elin (neural voice)", Gender.Female, "se", "elin_nt22k"),
                new Voice("Emil", Gender.Male, "se", "emil22k"),
                new Voice("Emil (neural voice)", Gender.Male, "se", "emil_nt22k"),
                new Voice("Emma", Gender.Female, "se", "emma22k"),
                new Voice("Emma (neural voice)", Gender.Female, "se", "emma_nt22k"),
                new Voice("Erik", Gender.Male, "se", "erik22k"),
                new Voice("Erik (neural voice)", Gender.Male, "se", "erik_nt22k"),
                new Voice("Samuel", Gender.Male, "fi", "samuel22k"),
                new Voice("Samuel (neural voice)", Gender.Male, "fi", "samuel_nt22k"),
                new Voice("Kal", Gender.Male, "en_gb", "kal22k"),
                new Voice("Kal (neural voice)", Gender.Male, "en_gb", "kal_nt22k"),
                new Voice("Mia", Gender.Female, "sv_se", "mia22k"),
                new Voice("Mia (neural voice)", Gender.Female, "sv_se", "mia_nt22k"),
                new Voice("Ipek", Gender.Female, "tr", "ipek22k"),
                new Voice("Ipek (neural voice)", Gender.Female, "tr", "ipek_nt22k"),
                new Voice("Zeynep (premium voice)", Gender.Female, "tr", "zeynep22k"),
                new Voice("Zeynep (neural premium voice)", Gender.Female, "tr", "zeynep_nt22k"),
                new Voice("Nizareng", Gender.Male, "ar_sa", "nizareng22k"),
                new Voice("Nizareng (neural voice)", Gender.Male, "ar_sa", "nizareng_nt22k"),
                new Voice("Vidhi", Gender.Female, "ar_sa", "vidhi22k"),
                new Voice("Vidhi (neural voice)", Gender.Female, "ar_sa", "vidhi_nt22k")
            };
        }
    }
}