﻿using System;
using System.Collections.Generic;
using System.IO;
using CSCore.Codecs.MP3;
using CSCore.SoundOut;
using Newtonsoft.Json;
using RequestifyTF2.API;

namespace OofPlugin
{
    public class OofPlugin : IRequestifyPlugin
    {
       
        private readonly List<string> sounds = new List<string>();

        // I don't want to download this sounds every time.
        private readonly string oof =
            "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";

        private readonly string slowoff =
            "SUQzAwAAAAA3dkNPTU0AAAAhAAAAZW5nAGNvbnZlcnRlZCBieSBjb252ZXJ0Mm1wMy5uZXRUSVQyAAAABQAAAGRvd25UUEUxAAAABwAAAHNsb3dlZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAeQ36iWa4C1nHIgAADSAAAAEnzZ7iDWdPQAAANIAAAAQpBh6h4c5ULSkaGIsgIhFVIgA/ySqE9SsoMisuktuxMOEzVR4eC3cHYUGQkjwFcIyIgWUixAQQjQ+d5JREiCkpl0IyF2kMS0LnqLJfAIBKQOAvddStTKmLkLXeZc5Q/g0CiRcI1BFG9I8IEChYGCiZUbGOWkA4wLwyolA388P8xK0vmZyLYiYMEXJwt2MMqKKmMT0lbNUE50AsGLSG2KFHDGONhohkCGzIrMANpZlCrHFiYyqsy8gSIRR6QkjHSg60ggEIRTo0wyXopJaMnn2AuVCIxLVMUYlhEz0Ny5xehrCkILLuqAscMkEaSDgimiqij4MAIoq4aAxV4GiR+EsUMETDjJe1Axdz+RteLCoEQnlwnpQyXkJM3DZYX6aCRFV7LKW/AS4BwYgglLwLlb0vWwFEVkCSqJcOsrTLSkRpf9uCtqELP1pJ8CxEaJCoFm6PKgpd9KipAaiqwzbw4koQhSQChNd0uWJBJQ5adi9WJK4SsYCmcxAui9DNi7Txl3S5jSXWT/R9aCpSkGnyj2o7F77KFOpcm8+bJ1QJm9oABaXv6iEM4ZhOM9e5oL9vQ9wWEdIOEECg6uHRHV8GEo+FkknHqMc8usgMFA1bnnJJDIytYkVqokxIghInSEnEVDKE4+YotwLkGBCQGsO3BY61AONJB0k3mOrBrwUHBR0OqAJfymEWRYfZW19pWlYmOzWHR5DbpeJIIBGARNYNNAtmnwvwu2Xuf5HuHEeGGQ6/K7WXJyJwoI2csiaPelz/OTEWBzDgPe3NOsOU8EANEZP/+7JkWIj4j2e9Szh88AAADSAAAAEmhZ7vLeX1gAAANIAAAAStIthPRwGtM6WSdmSh57tZTvj5NNQiHEoMd+l24ZqyQk/S9OZcEJZR5MhI1tSHCqSDF0Rjo7E+4i3q5CT5Qs5zklXTxD3zxPYTtmBwlWuc87MhxpLzapNw4DnO2p9kiZk0jAFSgsHA4IBmIAguLSkTQRCYNADBwQAC5hx4PDghUzE2c1MpOn6TJx4xshMZBxAICzyZBDAgQCggZwYBQGARWZCkiMJJiI0SkOpFaaJ4KCBQIEDSDGzgdypSCoxiMsBFDq7C7LEwAgtYmVCTDEWKBlBxggDJo1MZaSBhwcmFAmtFqGsCgDKmJLXX2+DOWxNnRuaAXbEoFqFYAcpCzMEAAzkQAkcyp8o1mndAzkQ7ICAdlzBXcRoZ7GkrH5d9DJVUebZOPBqXNeVI0NSCgJOEKWRXRcAuVGXY7Fc2kuOYzCSF/CfZ12n8E+E8UJkqFWnWwqdDR1ORjkfFTaeVB3BnnezVZWQqRcXxjibpdeHS2p9BHkUKIQhOKVgXiCqtfhqg/SwKxCpGu0A6x1oUhcE6zraTn0kQC9BiQPF+BgVmUxqYLJIOWBgIFiQAAQGMJhQAiplgUHBgM5mRRYb6rxnRKDYMSwQoFXDCyxpUvkBMxAkKIxtpBihYsGABMRCwFIM8AGRyjwEJKOnVGjToLjyJsYxYFhQkRS1RyGAJnx4MRBzwHRxQ4NFjKAn9SCDCqZYAAIQRsoAKwK3x8/YrzEVqTCcLfAJ8nFOJGnQRSkHgLOp06zq5lYG5qa7IbHkJMizAMhZwjYtl8v5OHhuoBVL/+7JkXQz4iGe9i5p74AAADSAAAAEidZz8Lu3vgAAANIAAAAQ6LESTIq4zkgEKka2NvZYR0xWaDM0NtG1sPwpWiupGp+1odqMzyKhLLa+X5+p/tcl1fsDEo03h5CfwX66iqmi+/c29ngaouX7uItLl+i1qEz2TiFyrbNsBH2IAbLAAGBQXGJwzGAZCmdweGIoICoajIRGHAJmLhWGBQBGBgahcbzHcXTYuDTE0rj5V0SyxCGD0gDGgwIFDE8OCQoiGiiJqqfA5ngcDCgICQEYmbho4KBxeYeOiEfOPATOBAEApmoOZOpgEMFjUKg1OOh5IIg5yHikSVBgeAxuZKFlz2qiREwEWJEObQ0rHknqN9Cs/ZGtjS5J28dxbjYFPJ4IYvCsJQaZ432+YHl3rBKpy5lqXh4RCsbIGosHBOTLZy4d5CkX1wpkbMnTUUaVgNrp64u7p9qVj29Iq4Rh0M0y7ymY0768LUdjhSqllew1f4LlAXbjW0X3nfMs3jNj7Xd4+5ZX8aNFi1gbtFiws3iVexKDw4AwoChjGGZgESpuIIxi4B4XC9YMw9FIw4PgHDSPFcYQkmYRjocpXEY2HIbMhGZMDkEBiYwAYASpMGwhIifCgOGBJxhRiaGOj0UYOHmCi8sNWHwcOGFgytQCWDJW8/ElNDMTCSMmojTmhNIDUCQrNQADGNAxn4iEDzFzZTVlxmAcIQsODiZNSlWgWpUmtRnzsZxLC3Sx/ctYeoWzxKRra8ViFUASgcBVNmcP2opW3hav4b1LIDe5+5OyOirTsbqS6QY0tJAEraS+1RgQDtrQDAvuI0m2F++ENhiUGnHnIKkn/+7Jkcg74T2dAA7tM8AAADSAAAAEgiYkGLm0TyAAANIAAAAQaak20wkrCbMvEoWQawuZYTzwSba3pKwzZXBRS5dWCUjyW9HibpmDgWMglrANFZjRDmq02d2A5pMIiEpmEgkUMgwVLjRxYN4HAxwKTLqqN9+s4DAThaUM7ssyCRw4smUlMYhIICiZiMthY4Hh04EvJRAxoAMSEhCMAK9NYAgYijQYKrhgkyaWbGgARhJWNNZp4oYUIkUQg4UAQyBGIA5moIYCZmAgphSMCh4KCZccChZm4SFxchCQaDqVuaw92qV072MGx6pTLzeJgbSEY07nFZGvR6SYCdmmcuisUfOT/f5Xe1uEMrobvC7k7crzEzjGI+2DrcIw2ZuIDwvITA3EYKh+HDnulX5faX2ar4+qord2KhGWegwO1KhcfeowcizpKQjO0btRk2PbTqmAAAAAACjQjSsTREYFMHC4yKnzeAyMLABBUaBACE4kFjIxEIRyYIHRgkbm+TUYqyY1KTTIBMGhlWMyqklPkVo1A4LEkCRngjPiIghGncBlA00MEWVXMSZEBs6xIGkgENRmBT0iMI1tBvNjUIHjCtqAYIYuMCADX08i/jG2wYRGW1K+EU5ut9qrhMQK2CXUuSndandSJZ0nMO/+W+5+0gjQIOhapmozp4RFw+njQoOm47jBjFC8/xEf/3x093EnZfr1eyZk5s1DiMHmPte5z35jzy439mn4QAAeoYMgJoYgBAYTwZaT/S0NdCIGAIQAcdCRgNFmGkGdlFZisgGOgAe2FJw4lguCnEGMGG0WI5hkJGFAYGEYyeHQIgAIGTVMJEU9xodf/+7Jkkgb2s1NF05pccgAADSAAAAEdYYkVLm1zyAAANIAAAASgUCgoBhg2YKCgwDAJkdYKgVJMHEhgQMiDB4cR1GAp5WQDQoTGIWNAweKC9e6gDJQoFBB7AiTTAZxuc1Lad25rCWXYYe+flLTGMSh84cZ6l1fmGhQ1FM7n83nSfy28EHyRy8pHSXsu3u7wd1hD/tlnnDjaZwKy4f0kHMv+f/+OfqW93dyyI1/901pS82s07bb0nv+XscitxXel3l1S9aAAAAAABjUiOAdZhgAEGAxWZsCR11OEU1BIKEYDUtCwKMCDU28yAMMS6hs9fmkYwZMYhhgXGPhQqsRWjuBCSbqhjtBnSa4YBKyI0cRL3A0B6SaYKICuByqlDA8GJIgUYMELCTYERHjVEiQQqiqoZOqSGEWyzyfDTE25PELkv+7DFvk9B74WIcibov/RU0cD+BhRpsPZ23cbEqpY3Lh3g0opFTrLSaY8DaKZeNBgQhwAQ+HaOjfz/1/Hf/fV9W9zrmFIuHOemhVqufrrbw33TKiUxABQQBsOALhAD4cCOYPAQhhkgRmDjGCZQIRpg/A/FYAhgcgWmCGEOYYw1xhkHAmBOBKYOwEBkCC0GMmFOYdouRgsCemT+JmYDYBBgUYlBaMjD00gfTVMdBwyDlkYFEwODA8TTER+BoKBz/QbMLi4wmNjHAeOciYchBEfDJZCMMDoMHKoy9hg8MkABFQIHEkdJwNSZq0AmSyuoGPEMwGeSQAEwhMFBqYUaaJlVqkp4LhxK2QjkGfhwxGsvASjgmUKZxIbK4clkaTsXpKtiv823OBH0iZVHggPCITFJANnCUT/+7Jk2Ib2jVbHU5lcYAAADSAAAAEmUYEOz3MRSAAANIAAAARV74jEBQadJzUXVrJzVClZMcEiSJVSrqTW5I8O81hZ5rtzn95n3t/LfxzK1IL0zjupW/WN+TRZ4Y1PySG4VIWy9p9TlnV/fM8+75+s/ohheAr8siqQQAAAAAIxoBQAgOFACAkBcjQYGITploMlGG2FgPCyTCWYVCaTAaYoEKcUzkBhMCggGVrrGTRbGgAMGQh1mYZ6AIUTBwpsoOZTDhMyZ2NND2Iqxr0bcx8VBAWCncKB4CIREFGFGICzze6UwIbMtDwKBwoLBgGASKHSGDA1LgHDJjhyRp5lyIYcDoLjxIChICgJg4NyRxR3LGBADOZWTpaBI0OD+u0xqBG/60l9H5gW7k/l+z/8/TR5975PFWwrWWB5cjN7FsGcIu1oCQddBSK/KNiCWSQAqHvugMnWuL6k3f/////v/+tfl//ja5czv8v0lyv3OzS1Y1dlU9cnJPC3QqT+c/WQVJ12hUnWDnYEtA0A8qgKGBKBcCgqTBzDPMcAfI1x9HjliGAMUMM0wrQxTBgFoMAoCgxBRKjfecDMTMRoyMHkzpX48SFEyzRQzxH0xY/sFKeYKhIYDAERDYYlHIathUZPEkTBAAgOAoGAoQjBYZTEAVw5HkcDCMDTBMEjBslzQEFjh4CDFUGjB4HjDkazBQDkIDBIzzFcGC5hgiFIIAwwbAExVOYxXDwYH8y0EYSCYwWHAFAWYCBSYdjKHDww0sALHcYMCp4QeWBFJj2oIUKqgla01VUuiTBtsQNIIgYUnGpJ9kxpZ2pi3+46u1RkGCIMMVY7JA//+7Jk/Yb4f1lF093ZwgAADSAAAAEpSX0KD3ctyAAANIAAAASp32Uuty4VAMi/a0BqYRcBYM81TBTPMsAmjkiaxrshpBniC4jEEOoXVica3////+fP/VP////jzOLXtYWfme4ZXnrpH4kD8XYlZjD9y2BqtBK895b/9d/P7drTwcegElWQAAAAA4wHwJjAcAnEgWzBGBJMB8LwwJhpzVf9jM9giEwjwSjA2ApMJMOYEgqGCOBMaPbVxh6AaGA4CMYLgbw0cgYOYIBhEEbmL2TwGCjmKhAFgCFQYgeaMJRuYPqaKmZ0FQmYEKpg5XmHwYShIw4ADCQgIinAR5G0A40mGw0CkoFASYQCZADTQgoQtKBeTAdpxh0oGB9EZjTRnAA0INCFBxQzqIUPm5Gomw3WodCAkHGpsMJIEmXAE6ZwYPPRQGlyppIAKFZ8xKTQZUbHzPLJzb6wDsIVhwIvJBysCzTVAmgxIOAw9YGAjtpeL6TFGUCJJlFg6PDJRQAYYTCQsWIZQMDEQxIsOBJEudOf////////U/+f//8yyy3uNRXm6PLcDwDI1V4gq2OQbSR1VXOjj0hfixu71mb3bA3yNAHevysYOAoMC0BcwNAljBxGhNLjGU3FRWTD+B2MHYHwweQ1TBXBHMDYLczUnBTCnAaFQzMRS5NDgKAAhgwoz/ofDH4LiwFSWKtZg6IhhYOxi0Gr7l6UXUPTA4QBQZzBwBkywUFZgAApgaIgYKRmlD5gqDxgwBJgGDCWY8CYcGg0mINAcWBhS4Lh2YdhoIGaM6wHOEgccRhW+MymMU8MQEchmTXcfCocv2wNPaDk/hEZFTT/+7Jk94b5+VtES9zUQgAADSAAAAEkAWcUD3dNgAAANIAAAAREdHRLHHBi6tEZ20/Lkuyw/3utqzelgOgUnF6F1lsAke6VZGeB8Uyl1JezQFBDoQoKmhGiA6kEps5o0BGCZlUanCBjXCYAVREUs/////////X/9///+FnPefOfrnzmrT6TEmr3b0WbpUv526a9XnWXKsAAGVQB0wB8AQMA0AADAiwDIwGgC7MGbCYjI0kF4yN8GgMEoACjANgNQwIoE/MAvAtzAhgFYwdctcMFIAmjFMHjCUXzPAOTDgPTCCFDVGzTFcFjAkIVUEJpiACxh+S5sKCYkFytKVpAAAcNxiWc5h8EIQCIMC4RAiSDgYeiEYhdUZWA2FAZMHwFAwKoHmEpCGFAnmEQJAILQqCRgAIZgaChhvChvWPZkMC4cDoIAYt+NCcFwwBIEvI5SmD+VhoC4yjZggi5wuYEb4dgBcGMnWOMykJcKRvWxqnsX/t/pmtIlIusoLJcCo5NgOAIBTelnbaqHIlLoYlYsTIk7smKLp1hgE1ksyp85iIUBgYGJAAE+MpNHkTRVPo5qjTw1////////8Y/8e3cu6xfPPcM48oK0v955dF1A26NrUidBBygcYlVJqCeLe7LyN7lHB9ELQABALMgUyLAaSFuDAJB3MBYSIxR6sjMQFMMEUFMwLwDTByB8C4ExgahJmKGnyYA4JJggOL4HiKFQgZPFp+VHGCwMCAYvdKgeA4XC5lYlJWXGNOyXNMcDShfYuuj6YCERgALmqbuZBA6B6RC7EXHGMwgUwKCGTRBu5g0HGMVgbvKKF79Q6zMQgMVDICDGLT/+7Jk7wLqfFnEK/3TcgAADSAAAAEhaWUfLPuDAO0CVsT2DAiu89r7BLbgNfyEhugwHCNF/Cb23XLkJ5//h/xqzBS+lYGBPRDqsipQMDXupUfKecghby/IsFwEOAB1gQNm4AoKsohtTUMAAUEDrLgqKQlr29/////////P/1rmv+xHL+pTnzVum5LKtG/Mao61mblrayqlqWa7+pA4tILJuCWpcA7PlsZUKeAk4lL9PT9CVgeU/+fKZdfby+J3g/y+XeD8MNQ0b0fLvL9Z+XeJymXiABv7XKBDSIPrL1mAcAEYHICBghAIGEiAWY0gwRx1jhH7MJsY+4jZg+iCmDoUkIAdjCZA4NkKpwwjQcjCwDTF4ZjBUETB4VDHJRz2xvDFgdzCwDEl1PjwlGEIqGACQmBoHDQIjoAIagALDI8SjKQQDAcDR4CBCEBikKBhwLhz1XxkkUQQMBg2Bat5gWGo4LJgSQgVJkWB5uwNGEwUEoxnPg5tOMYGiQMyoUlClgmKPzVn0BwBMOs/8+YAGVAMHMGZOQHzCpwCND+aYr1qqe2kImGX///O/tYrrtEBJYemiEa5oGSAQkasibl4s9fDeqoryeotqVnVAwQxFWCLxsZwLoByMAgEOacRgBYO5GYKiyYRjyAODSd3LX///////dud/XbVzDKWxvuUqv4fTR2vD9SXFgBKKalsSu2sqxMWrli/90wAAgMHtAAFgI4BcKx2ZM////////9WxOrpKWNINe7I396al+tVN8UYtOgACACUCgFGAcAmYFIIRgJAfmBmEIYMgsZmk+imwUNqYLoOQhBzMG0PowBgIjCgAvNRc9//+7Jky4Lp9lnEg93TYCRgRqJh4gEnwZsbT3NNgMsB2MHMJAAxTgTTSIEMOHAyGHyI+mFFIbqo4CJYgHJf5uZETTABAM0q5w2oI3rMSqIgAbgAxhEBGIAKMAwdCQsdD4bbMDpUwOHCgOycswIwSZuD5kQCJYp9EArMVgwxCOToYZOmfUWEk6xyAEAERQiZOIREloaxCIaw7KXENFUaIAAhPgZ0mU+EO0kts9jX/+uf7rUb1IuJIlABfBE1SeIS5QAge0XqgW1IBCHFRKtYiNDopKEwt8WkApQRAoMAyx9xA9JA4kkIQ7Gr0jw////////3z/uSeUvFB16CGpb2wKxfsNYbFxnDPpxSaQDqRSu1KqIRralAhabiOVf/WPM7uevr752tQ54dgSV3Jjn1K5jDuGiRqGsaeJG0Ae/1/amvt/7E3Lb+5jTbtsYIW/1unU0m3LHJ9JxmT6UMvTVTYg3b1ZABNAAD0ihgAcVAiMAEBUQAZBYLUwbpsTMNEtHBIGgUMYRLGhlMARNOOJxNMQ5MIwjCgPhAJl7RCAxoWDDumRhZWDw4BhscJTRGt43lKoHPvAW2MjM0Q2slYOXmDkA9whM7UFoJoVgoFKpmckQkxrfTMBAMXyBLWceQAAUTVRyY2wIdFJC2y2oRKMWB2KZwpKtl7DERkIDFDGoP3nW/eP//9/6WWUD4KTL3KqIstPYynBRbhx2KaGFDEj1RhcDepWEUIy6hhIGAAJpCgcDpuPONDLEC5bW7dr///////////tx6YvWNUf/SWM8LcxYh+tZaK/DT3/uxS3GJp+Z2L0n2y0kwCAAAAAG3QCUfJYNMiM//+7JkiQJoHllJS93ZwCMAVyplIQEq5ZEUrn+EwHgBHSmkjAT//////+j7L//TUuz/Zr2OsSuj2aIABDBuYnGZhAoGczOZKSRuvZmJzKIZqN4XmYMYA4GBqAZRggoSuYDwBXmAhA3RgSRlYYCyB7GKVeaMQJg0hmmwKYUWp9KtGPBeAgWGAuJmBBYYOM5rGVFkUgS0pEK1NDG41MCXgFNAFBYz4ITKZnMmE4/iQDb1ZM6ocxAGVbwErjCBhMJAcxMkghWjRzMJLQxKMwD0zh58M3QkwEIzIwbFRKFQuAgkPFwWOpgMAQ5Ysg4IiECP0CAQyx6Qg6mLjoYDEoQVC28OIRwHqvj///e0D3um7aqIsahgymARMXdAAHBxbMICd9JhAigww2PAwQjAfMQggxMQhUBFBFAKJDGgZSNQoNjDwQMCBwvEWA2YFNZg4GgqBmABMTD9X1B3//////////dG3ea7avS7/p8O7lUSkL6VpAqm1FQRu79xOVQakvESgBuhB3813//n/vX/qr/3cZTkDhY3GjiY4ex7//////9KCCKfMUa1V0f7Ef2f//ZUQAAADKuMAHAATATgEgwK8BTMCOASDBVQTMxYgNJNotBpzB0gTowHgEGMCjDcTAcwKcwNoBLMYRDWzEuAKEw7HU1FNIxZIkHEGMhkBGXCD2AICkwTqCBcNzCUdjGJgzCUBS7AIBwOAJa5CbZjUHph8Cimw8QhlEHAAGk01EU0sCU0fFouuWwMKBlAIPmTgABZOzCMOzDURjEoBTFYMzKg8TIk7zhcpjDwajD0GgCE4OAUGieYIAEYBheKBaBgTYjEAugChgf/+7JkYoZrFWVFM/3TcBgAN2pgQQEj7ZEgz28tyNICGMGsJAC7hUogrABE0Bn0K5zpLkUUUmZT3LP//8//i7XoPHBJjhRpqBiTQLDqqh3IAop3GPNuYwCnaAHRkyQReNZNMCMIpqjByBZ8yhleA6BJRJhxpoyBoqJlV5tpxnRIs2IgkC5/////////q/vjPIKv2qKl/d7cJqtVgmKK9lT5RNqyNadr3VnDWcoKlWqsoPFM////+fvPX/lljzHc1W+nUFgAAAAAEqQgbYSKr///////////7f7PRABZAAMmADgFAcDUYCQCJgugemNg6geYoFphGAiGAiCQCRpTBvAJAoYpgPKwmG+GuACk4UXNlDjDjAqjA5SSIoEkoofHQAOEDKogaAlCBkKbNQiI5Ei0zwHKoEYcEmFqxlBeZUtnSpZ8x0NFbsAwgSWMhGDCAUx8gBwgY6LoGhhWZcfGFlZwamlSOhNwUCV7g4CFiqjyqpHpzgpBw1CXYSYALxJKNDJctAiPf/////99d25OI+jSzkjWUdKCkO9L2WsLfKgJTBGAMOAZIHDOCZAZa8xMwsgHrr1SPEY5bQtEehIWVX4/dPz////////9f/y+5Rymitf/Lt3Kl3AMqn4JnadmrP5ivL4JYRdKAGWz9j9//4c/9////f127Wg9Nv0Aao3BYcFVlaJ/+5edtZr7gV6/ErFyvhoUHu7Swl6+4FRQe74lU/8rXjuJZpnnSsC57opKjMuwTAls6IQJzAMmyO30IMxeAQwJCYwZWkyPBswxG80SPE7HE814COZMzPgIDC6AQz9FMUEggGUZzVaWzAzsPFr2xpb/+7JkIo730FjIg93ZoDmhBREACAgchWEoL25NyAAANIAAAATtoUCYAAoYiePMxhIURMpoAeeUnm8IquFNhoPTEMMJzNUoyUEMbAyoiiQMAjAAohlLqdmaILEoG9rSLaSokBNit4MscUQgaH8IgpKEECIoIjg3Tqefzv//////1XPwbg+IMASEBFgZirlRWR9zT/rxgt2ygSBXQXaKh6zFzCIqnyhXLwNNgcQizCjLQV4k1Ylz/////////1//z7WfP//3n9z5/C9Q2so1Myy9UqWqkfpgv/qsA3GhRxqoqxz+AmvHyBFu0GU//9HApEBEhhIKhkJiqzIaCQFrY8VMt/2hL1kQWJAIkP+136mu6ke0eNal0hAEIgBjAEAGAwCJhOs1HIOHWQgaGAaAGYE4f4QHmSAPmDgQAYxIEhmgkKF4KMxIqUXMeVTDhUeF2+lCsTShRFVzCFtybkCEoqZeWDQ2BhQw4QCAQWHxF9GOFJWUyxKd/iqBAw3LAmNIRMABUNFitK8yxoM2Cx4kQZhhRpn1Kz9PnvjLC1BjYU00USwXyDviMBhEsTf/0RmDQyG2JUGpmhFRlyeK1xek2XxRSBBd4ccDjAWcRIc0G1xCcLegxiCQCWCPhMQA4F4QIsof//pLdNvpMtNKU0jY8UTpUNnUWVkCWowCAAAAAABcZksUXTG9jOARrebhcYoa5x81iemD2BQYCIG5geiXmDqAUCAITAkLyMRcAYxUeDu8x4GGg5F8y48D0MSJ4tFUAIkEA4tIiJzUGYHlSOwXWzBTEwsEBAiYuKLgMECDbbcQHQYxLxQaVvFQskExCiBhUSERkQv/+7JkPgb5EGVJa17ZMgAADSAAAAEmvZUczf9kyAAANIAAAAQTIBkASY3FG9EACBSAFXXTOi9AyAuBKsWQrTL8zi/U9ZSiCvlXqhjmR7/5//vv//Vz9j7vMqSNJgREJgjnT28oigpRp1PWv6AjEhEZBy4ya4cGjgCXcVsMDA2MEgW2oCJ2MObKu//////////40FuCYLgeIUN/ffp4Glj6Qy+T/oMLwlberahtq1xJGA2aweCg2o1bPusN7y5u/urh/9sWY7bqd3aXgA8y8KGl0ycJElwAoRyDcYVKDZm2Wga4GCRzADQG8wGcKdMAYATBkA5MAwERDB/QFkx7SM+wTgXUlBQIPgZWM0fTJydr0RBQsTBZImGGgDetAKwG0WBRJMEe4lomKihlyESBpCenpQxidIZuCJCmChqe4KDAIJGWzxlgsDDc2cFHC8xFIBPIZcYmziRCOs4VTQ0ThEYrAtPYIQJLgiJ1DiYQAodCgaDVy+LYwcJuPjOc738P32X04iBMKUeCEbRQLBgWYIEkAw/VHjhQjQwusxABfkaMTChUzNAGScWfjAgIyMGT+RkQlmSDSDxgAyNBZlwA4xQCwTv//////////6G1BmcqgN0L+f9g2Fu5DNJArZEdxwAbWNMRfiVOes6IqyVkusJD+/w1/eb+5/91/eSj8+7vS4AAAAwCAKi4hCAPmALADhgOIEmYEcBLGEBlC5ptYQkaUkuYak6ZXNqZ5DYh+QPUeLmKYdiIYBg4YmA0WYBgCloDOhDC6RQDNYRxROAwErZABVAnGfUcBDBQ02iQMuBUaAgeGAMxMcNPlDGVYLAztlyVLAr/+7BkOYL4u1jIM/3ZwAAADSAAAAEjCYsgr26TwAAANIAAAASBGDg5mgETXI8oGcGRqImYybmDqgHBwUqpRpqNZU2VtJAdRmBa6la7kcH1UBAgK/Dhp4p7OGPB0P9i+fP/ufakOTSPMYkjMyUAWwHAQ8TCMAVZV3egMrAEd3JbotNJwyIrQ0CHshEExULZ0mPwETL3GBBoRQTR9WmY3///////////8z7Vl1bDD/xv1L+FuhdKJPJH6C9jCnJnIbvN7U9w6+ImPcAIY4ACKgGBACZgEAfGA4BuYLQqRiZ+RnMOmgYRYgpglg7mKsC+Bi7TAdA0KoapmGh4GEqB4YHQT5gwgAGAmAuAgATApBMMAoSskAgR8IAAB4A8sygqEOcjQRMUo0OQ8QmK9hqI2NBhhBMNBxgQ+YKUHktRsgeYeHLDOMtxASZQnGMDJeA1dNBScBjAxAHMkRjSRpMYiCWGN3YMvIoAoOlSliTqqKPyswBAiECiSbCZKf8y+dqUYc/7vdXKPJA6nzTOkSaURoFb0WbcsuwCPAiOr7v2TB6ewVCjNTQFIQFBWGhxKIQELHggUhQWAUCKgDSUP+O03b//0tlGqbXeT5kZuVzExFAjtJgyLRZNhuFQnY9HH7f/0zFaAEAAEhQcqlGVOedBgHhDmDyJAZElrJ3/JYGG8EuKgqGI0GMYqgKJgggVGBgJCZFQkhjA2Y4MGdGZhgomAY2Uhf+AASnKFQEOHBoCWuAhKyzNerdBGGIADFWE1kEFh0wcJQdMLGDBDk0KdAUOYAKJARZqpaAAlRMFmAioGpDLBwwsBBw4YQMhGOj2XbfahLtF4P/7smRIgvhPWUizPtjAAAANIAAAAR8xZScvby1AAAA0gAAABIpP6amyhi7qJEhYFd+63qhinaoVmV4d5//U1+n7etN+IVV+KNK22UmiELdWtazfRsqhrQ3jUwVVDk8EJ7Jy6LsF/Enx4IEAKAhNajuhAU0VSdT//////////8cr+et0dD3mP56rfX11tFVpyjryiP3rUY/KTXL/29lAAEAeXdcAwGAAgMBcEBmGECAGYyglJ/jBmGKEDEYJQUhgOCHGBUBOCgBzAeBCMkwKc0gQMxZTJxoAh60CACPAry9BCCody/6FDZiYQlqTtuGSoDDIoFL8xwGTVCwYVQoCC6aBpzCEZwsOsiUNZuoABIBYYWEH9z8AFiA50CDmc0qWIS94ZhqT/SLb2v01CAG5Q2xOQbYfJU6Ltl89f/3Md6tOgrLB1Rrr9M4jlZJVz72HY9BDcWz2VaZeHMAIweXW0iEvhvSIVniFbqQIjjRLez5/////////7sa7zf543/3ze9ZfOXH3XnYpYj2Zoo7GKm5HlR/OpqP1AJR4dAHMAoAYwKwQSAG4wgxCTISmWP5BGMxrguDCkDGMR0NoxKwSzA8ArMCUQYyAxJw4hmBAuYMKpVBwyADFY3OEqwmAa5WTtUQnpplAbl7OWPLuGAIPBYwwIxaAiQCCoXDgWYCDBjsEGXYQZtCwcHxYFGWHEwDZYAzQGTPxILsgL8CHCLA/l0EilkGw2TAqzPLLNsmZ6w9niAmGX3UfpFMKJ+5ZHIhY1/1+ZTDzq3pSrNkjjq3qOx5q0Cp5c7fuQ8ylizYGHuUYYYX+lzEVjO2mYPEtUUrL8uyHBf/7smRuDvgEWMiL3MtQAAANIAAAASDJYyAPc01AAAA0gAAABARa5//////////vv/cy39zv95+tb+zjGoZns9zd2zeqa+xr/oMAEAAwAABQCBUDQOzBCCEMBcXUwRutjZNX5MLEQwwggIjFzB7Mb0BMeCQMCcK8y4RIDKopMOqQyCSDFInYgBRueMLJdBNJdyjo8BnFEhKx4cBD5pisqAQVHYQYWCIQBioBgIITBIxVVMcYgyoDBwCjJFKhPRdAMOBxIKMhhIHrzSBiEKDSoabMmKjNRuSCrA35cyw5LkNf2FgkdXMm3LGHpljgeWtYcHP/+rT3XwaksIn6UAIaSuUtTAjanhwAuLPtutmzlSTO3qdkRhkIkuEeRIEOkZQEDBANAolDV3ggbWean//////////u3d/njvlzn/z/y/8uTkeoMbFWvjfqcsU9z/gJgAAAEAYAYuK3ISAlMEUBIwYAaTFZecPW0bM3OOjDZnMvuM1KNGciMfnmlwY2EAjIZjQimCg4QAswKDzX4bHgQ4ETtTML4LFQipmZPIqshWZYmZHoPcwwQCAbLAsUEb0iGD/0aJlyyAIXmLNAEIvcwaUxQowo4HOxCOTWKgIvCvt2m6K3qHxiK6jT1L5irstTlbVY+40OwXIohzv/+rGEklDzvSsyVqXRNoUdtp3Wtb/5VKXniE80wIEtWHTat6OBIBYOwBnoYEf1CAOBQHC6Tn/////////vDufbn8z5///5a7nUr4v3YkEQq19Tur1wh/2gCAEcDIEiIB4eAsAwH5g+ARGSSUmfPYiBivhMmBmDuY8jZgQtCATmQSiamjpgkPGFB//7smSSAveTWEmz3NHAAAANIAAAAR8hZSbvcwnAAAA0gAAABOYvEBgEBmBgQOD81UXkeVriwFGgij6XGL49hhTwwAy2awphEwhhaTdFhEMgcMKaAEzysQcrS0CVa7lblBzAB0DVJMk6SQhDPhjwNUuMrqN8Svf5xotqzD6mCeL7vFQNhl6SC2Hwn5PEKL/+5RffcV+aqtL6uss9PWG4eiUgq7ucfCSxqHRkM4NLawAOPEPVCgmpOK0gOivhXI1lmcWvd/////////9zVfG1T65Vw//52fzv2KV5phZkekL9XvkkzQWnZ+zb262KsAAAAAOf0LAMFMY4xQzm2MQt0U6iRUCmzMXMTbOU4oqKAg0xpPJqjHxozQfMEQQYKp1BQQNAV1/DIGhg9w0Bl4URqjVGOPgIgNFMy4dFh5kyOCuQYKFQuN6KTFRVCVTpLo7jQEMgy8zBxVVhiA2Y2CAZBWlPL7uMtfeuwaHJnWcEqnfyLsctvjA614NllWQOnj//cp883ufaCIOj7lteXhLtupD9rDlifKwG9QoTWRqbLnYCnIuctU/kcbAiPGigOLRvXD+Xf/////////7tfHfdf/P/9V6PuFBd1atTEXgHP8pH2RRcSf6mQCUpQBFgAcVAQMAMBUGgdGEhXWcOo1xktHmUwiZgbZsIFhUBGd6SZBFJmQIauPmkhQoHDAObu/lVEdJCEvUUAUNGAhDgtQgJZpVAQACgo/MsS2TpALCxgSSzHIoxpmNHAF0OeyUZA1gFpI8GJAxhhyYIbmbAZa0HJEOIE1NmWUaZrB7VBS9ohQBeZr7q2FH2PoSGjNmttRbhz/1jJ//7smTDhvdRWEpLPtkAAAANIAAAAR4tYSavc2aAAAA0gAAABI5k+T6vQ8jpK7bRofJhjra6w5Uelnmm+JAZWdfqwwEA4kJDxUEWwNFbGJAy20VlesWZPT8//////////1zv9//7//+Ov5X3ZrUvz0k3rdq7lZBj/tpgAAAAAliRgIgNiwA4sDcYHwFBhbiXmO/zuY9KgBh+KZlMYxl0gJsQSYQU5mdR4ZSZkuNBmkcBm0WpjGARhMEhpAOBiaFpjxCamADgaEEwqMB0UBgkeAAsFEwiBCAAAZupQbmGmCCBhYqIB8xIOCQU+IoNOSTFB4xMXEg0YEgSJihSEGBgoeEN4EIRaEMMLjMSU0QfGBIdCzCwMuW0pN9EtkCwNapLh0qEAIrekHJyATQiBwmwNAkyBUKY87r6kFtcTuuuOm8wxcosECQijsUEzK18I0l/qlmo3dXgGMVlsYMBAQIAjRoEExmpEFwVh5iAgDQQv2MgYKFFcgaEHS5gQsD91j////////+qeWWKCfzzzsbv8zyiuG3YgmKOsr6v7K4BnZukmWaN2rUX2aTqAJAMBgCQGBQMCMDELAimFQOscyBppmaJ4mQYQ4Kg3GGSFqYVwLJgsgZGIwQoYm4fpgWCTGIAA+JBtnCqoFxT+6ASuTBA0BQAMHRogMHLTQBlrZECCMGFgUw0fApsZG2GnkQNFxEPggzLdnhihtfkZEnGfgxmQmDgwKA48AGMiY0IhwwZIAGDHJmGIYaCmpmgYtEIsPAyNYVDH7FgZrTtMEl1lrYWQciTtaiJKerwRJsza6+DUWayf/rxxWleboQ2jPDRcFjbwOUUPP/7smT9B/l9WUdL3dnAAAANIAAAASS5ZR6vby+AAAA0gAAABKoL6VvkC1Idl74osCV2LVgI/DRFiYgBobiIgFBGOAX8Ho30HtRgwxiyVIOUAwlFR9/////////VWlzuUeF21T4Yau4QP/YezgWoxGHoPhyPyavIJhqPZyv/SwM1AACSyBgZgLAoI4wPgKiwEyFU7jZJwvPvUM8xzzHTBgBGGA+zC5AmMK0B8xcSSjHyCcMG0eQwHQNTAqBKP/AzdCAyCjM/LTBiA4MtHgcyAFMaDDH0gvgTCqSicJkxMawCmJwJggEAD8xI9CpOYeTnIOBnriacWGREhlBuUeDJlhQMalqmAYQ0ZVQYXIa+gf8MpoEhCqeTxXKkyg+jhC3HT8ilO2hZ4ww152bvoOCR5ogAGiSZ7MnlRCpN64z5y2KOE1pTCH2eEoWrAZWPXO7w0PpkU4apHQJhIc9dGQCpYZEDQkdDjjhTUFbBEbYmPIxQEHCVKh9GvoociELB9Pl/////////8q36C/Zu87S3d7vO5rbk5vbArXm4uxD1LAmT5PRG4ZkMW/oQDAkNTAHAvMH4HswWwZDDWB3MhECo7W18z0BIyMRo9wwbQ6jB2HLMCwPMxKwHTBpKlMGchoxHCEjJZGrMEYRI42SDMOGMH3IDSoweAjORSJDiLGsBAcxOKTCAffslBg0RCIrmJyKZaGgOJwhL5jIVmGwABjmDXqYbF4sSDHYfMPAsaNhiQHjAMMKg9EsCBsRB41UPTGsVBoGER5bcgghg3ShoQLAIUpetJW20GXQsgVEgVaxoOJykpMIInLQubI3jAXs58qtEw6KSnf/7smT5jvlRWUcT29PAAAANIAAAASWZZRwvcy9AAAA0gAAABDWmsvim2n6pejuRRzLwqXLUVkdB+FZHhEspU8YqaMADQ4wIdM6IhcGAgEeudSgI/BqJntEUYmYFWquPP/////////Pd+5P37vOUfan0U3+UquUUubrQwLKbtias0DrPTyEGP9oAAJAQAACBHMDsJQwIwOjAcBGMclyE742YjeTHMEfvmOCOGGBYmVR2mLhJGmwAmY9imVRpG7I6miYAmQpomc6YgFKyJBzDR0xtnMHPwqCGHgRgpoPHrVy/ZWFCyQBSkzdlFgwlPTLgAysqWYCQ0ONxkGEJeYaIBQJDoJCcChIEghhgSYmjGcgJukSDrURiJM1GEiTsgYkLPtjTXXM+St9mnUfAQKi80NRmJqoCQqW6RFTUVvcVukJlmMFs/ZMw1WRlyUcBoapPtmIQUoEmGshZw75d14F4w0PB4kQtFXskqzYmIkjzFB0mD1DnSBwOogkqEDxCQg4za8TGphQXvO3////////+rX27l+p/6qc3cnY93CvJLNRZHNx+1O0EXeDT42n/f6KYahAAAHq+wMCOYAQMZgDgVmB0AwYJa55jiptGr0M8YthAxgEBSAJ4ptmoAqZJeRoqPC1fP/hIy+xjlzY0pzMYOgUXFtTAygwwLd5hpb8MDZ4VC29EhcRhwszKAhQjGRBB8mHDNiUMA2xGEDRbJGEHEHUAS7gYAIIDGxsLQwJAV3l2i5TzrXSScqXQTLobn7bsO4yqMtMlqnS1FpwhImzEKbLmNJQt5Lo8/cDbdx02oKysWaVDjqzSvqBwI+2ycVWEz8PtOf/7smT1hsk+WUeT3dnAAAANIAAAASGNZSmvc2iBXZ/QSASJ0XwIhpxnD9q7mxEWBFykQdUKwQFAX77////////+tck8FT0d5lxyebjlt2ZmzNwFE42jm3kgeOJS2Vr+WVZaPA7RC120cIiYWreAKLfi6SNyTYUZf+iv////8rsqBTDC3gxrzEZyHRXZVspBIa9nRdZP32OytcFDAz1VgyoWokLRlVgyMLEf///P93////7hIyISsqzSsurTIsqzSsujIyJKwAAAAAOEIAxgGATmCeDIQgMgAIIwH1izPSQAMgAe0zxgzBxGMqnAyGLDNoZMYn00a4DIDSOZIAwIgD1EzXqDyt0tGggQ2ATUsMKFCo5YWKFgiycACRQUNKUuCE2QBw4WnIYUaTBxAMa8DA6nKAm3D6wSZQ6FN+CODJEIJWxGlRRVFwNNdpYlKsKOXwEya3DMTljCF9P67S82UOr3PP5dUc2Q14fnJh5YJeVP1+ndhqTOy5MifB1WmL9sSFxIjII+FwCeE7EW26wBOmfRKfAeAIYz/MP/////////9arZ5UGrt/95W5dh/LneN1zuVctV7lyzQz8d/694gAAEY5nXGEBYSs///////0Uw+XHOJ/+J8njQs4+oB9Pr1SdXDOH2AgAHDAFAGMAoAowTALQUA8YGIWBisG2mv4DeZmpeZvMWGMiiYKLxigZGZhUY8KJie0mzG4bRVI4DDSxYBRnM8BBhgklLRyUvHA7JUk5YlSPBI6KCmQawohXEbC1QwpEYvWSrCiq+1yFZ8/TqbJljAprAFOgwYJEEwKKlFGoFb6YjtLQX77xwqxArtP2vBf/7smTXDkfFWUrL3NGwKMA2hmDBAR4VZSxvcycA1YIaSawwAOTzylkzXp3DtTUtkk3PR+ndSgfukia2YW2y+6WLxls6t8YY6701SSXTIqEVHXC9T8QVA9INFytXjMFCSAC1zf/////////zv5axr/n2xUzv4/+/q6iF/d7We3suSOPwuCP9s6gAqlPQUP3DAolAQJCSdMs///+v1NrFWGzO0WYtC9TVWUs1KYtAHS1Ta37N6mUdjehe96l6/VWAAAAcnUYCwCxQJsYFQBxgYiiGI8WEa/TG5kxDGmQOGqYQ4DRrItGOhYZ/PZiM2G0lMbvQhi9rmCgYZSmBkYaGBTCnuGHRxGJEhqkJGS0xESb0RDBIUuYgNmLDiEKQjTdhy7A8PMaHUmMqjJCAKKKpEsxLYcZsk+8IiVnVeGAKkwceBpoLBI5QK02nUUlcqr0kVcTtVO2nTqaIPE6ZPho8HSjVD732mp3mxzEN3WLQEkCyF12KFQC1NklRkyLLPI2z2UQ6waA3mVgHCqroMp1EoBUdRWiTASQAt0Qg+5d1////////967auWbUzfsfekdDqtvG1q9L3SosdzWNBLd00lnpL/0rSEACUBOfhDMcwWBdGkNSMq////PUJ/Uqj32UfqoI13tFE/wpQR1PJBSS1lisUejqetkAAFoAklDCsBAMDAA8cEwMzFQAzHEGzRKMbPgSdMADdMJR5FAIMXCMGgOMD46MRBONDBPDknMH0LMJghMkRAY0aUOFgI67HhYcPAAdpSsY6eVuAhdNcBLyEeX1MWpL9gQSKHmYBckHPFCwSGFkLsNsrcjMk0Y1sajGFVgGHv/7smTahmg1WUoz3NIwMUBm1nYGASANZSkvd0cAdAFdtbSIBDRolAVLT/v1E37ThpevZGl6ucxN417oYtLKD79rzaPMyvnK7iSWHq7RYTCoJgSPMvpUmG+iiiKx5qNIIm0SbgClg5WhusSFQBaBC+WNtA7TYyVjLyMSHaOo8SLmX////////7/f9p/1fz3hZr3ru/vaxlr78+/T4zUL3II7Rx67p0VjQAJBJKYlLMmACKgEGVo////////d//9wz/t/d/uVgBAAAAAC0wgMy/AxckwokwIASDONMyMmwMY00w4TKVByMBQREyMNBQeba9iQwZ/Jmhkhvyoeu3nxFAjHDsCoKABgIcOBBMjjQa2hepKFTBCcoKFQEdFi/dcQCIJDASClgRIgJs4JF1EgABpAMegdWWXl6k/TKxoLMRgZex4SD1Uoq/k3J30Zw0FwpVH5ewe3Rxwvy15YNVBtVBmq9l3IImH9qs0wglvX4lje9ZdSLDthQYY+wyjldMrC1psUjcR16SIppiIUjkTfJKeKvgz+qrhTpPNt7HP//////////3LN0FZslmtnbmpFIaXsoqyujbEymH+6eG/Xb6anXxvwXe2rpUhRSVPn/gOviKJ2w8lQuYqLjVW2FfT/X/V81k/VdTc7ur3VUspOuWKUsc4Y5YJJSRFGtWvivxETSxjWtGq93ERPItbWx0YAhMRsFomD7MG8BQ2YTFjILZcNQgrQ1ZQzTBGChMIsENBQwxgqAEAsYOAXRggBOmD2OyYiIABsokc+VHCRqLhrQCMJBrAuaMCQkIMWWhASIwcDCIodmCmjpmFihMCCViYUImPkZv/7smTXBug0WkrTXtigQGCmQHdMAiJ9ZSIPbw+AigHbybYEDHxSYaMmAM5hwKFAYwcIKE5aaakbEYWIjMwltMErTCWwUAyh/Tsai09Mh9nlL3IEkbXHWdIE+kWFIPsLnTbYkaNozI4rJi7FaKXURENsilr1tIRIXStNVjTRw8PpaYjHl4MggdnSe5Mkm4wN1y7auwwSI4gmAzD3US2iiIrHmJFlktBauQ+ZBLR6///////7v/nzuX83rHeuXKmdz8e2Pp307hyp3Cxcv3eVP2eoqzcOk5QPAMJK50R3///////if9qyfP+J/1DUs+qJ2N9X+pWAAAAAA8KgRGCKCGYWwDRgDgIioSRpklwGiUt8Y9BJBkzhtGDgF4aJFgsqzVojMQBY1O4zCZHM90MwMjDKAYMcI02CHjCYPBTNBoWTjyBbiSCZxMSEQuVGAPAE0j4CkwNUAQSYAsZUWYYgHGgoqIjZpSJoBJbKKopLoSEHTJpoZitwypGliZyRUZgpgTKHwa8oS47fssdFHBoLTW7sIWytQxYpR6Boi5cdxbHHWkPUyd4CAFYe4dE0sDq2P8wUUCBUEmolzMuKh1UsZih61l3GoFYRDBAIYdaqVri3mQLiW2XZSeU8xtXzPKnP///////+/yl7V+fvPvS8/KgvT9v5dqU0rwt9ILHx7mU3HqOZg6+r9AvIljgAcAAAAAgQFN0Q0SPRoCM/////8Rf//Dv////nfxFbt4iAcKgVGBoB0YNgSJgmABmEEE0a45fxhWGpGI4D8YpoHhgkiQGDkCIYToERhOAigUBERmXmNgOaYroBhjfAdGhEoJmzZSRAMf/7smS/hvi3WUnL3NIwIWBW7T0hASMxYyRPbw9AAAA0gAAABCEghLTFjYvKDg0eIGY8KA1dQYXFUeMSBgEViMFCGoAoAcWmHBYsfmHjgJATKCAHJd1mD1ooCwUSA5oQgaXDjxMbuNfAwm1ZKqi3SQoTWKvLNPG0qQJRLephYrWSjByWSAXvMOOxfrcYsjjkrWu9MZkEfIKpnuMltIQ4ToJpq0Dz9QEWDvYTTiioVSKBIriEBJIHZFjo4MqKoJGyktUVAJYL5QMjct1////re+/hly5vtTmst/ew52zau/hS0c1MPTqxnnyhiD4X7z5Ao/1HDD2hUHEDBsYiiIHLGYSBGZtYcddwcfrdsaXjycEHMY1jEBjJMPxyMex4AQTmTD7gAwDTs4jjolTIshDAYYzFERwCBhplkkZrBkywXKBSbpjCZgEDIBjJkk5vIDopoYmBGGJFEzUCHjDghFUMisA1sBeGWJ7DoljocmViN5UMh2FHIZFBxsLAGKtze1VZ5R0LeYm3rEloMDL1MLgBAetgiWGRHEIRS56HebbF6G+Kwswr92EqU3HOS9KDbaCEGw1BIoGYACHCGBN4piMj24pyIcF+MOKB6siHhb0KzkrVPKgZ0tRPQgEkoIoEuwNKZ2vh//3//Lffz3y538/sZ37/eY3cb3O8vcuX3g3y1d/CvQcuWf9QzA8B9FQSTAuAeMEwBIwlDRDcBnNMhAA4xZ2wDfJgzEtBwNNgEAQxgJMEAqYMrAa6ZIbzkwa4HMZOAYYYA0IwgMLAJDqq1gH2BRoOCDzZlojHqMCgYyacLxwMvAQAYQAJwDb5lkwMTGxMKKBQaf/7smS+Dvh1WMiDudQgAAANIAAAASOVZSAvd0cAAAA0gAAABMRSccej0rcCAYqLRyMKENo6NLbCh8FREEJlgSZifCe0BPI49pW1cCvVpKZiQRPRqi5gqOHjJmBaHZk7RHoT4yWxEy7CyFxJ4oIk/kohEWEiyaqIsnFjoAILArClQGpc+4XLXkzYLcFSalCRZeYoZmZkjAJnLIxkTDS1hEUHQhMcHQCssNZ3O/9///nO/++V7/LPb1JrKpf3Nf/95b7WkTE5jeExu/EI9RTVPv+hpaMVAAAAlMCQwCgQGIIbmBIPmW85HfCJnQZund2cmEoYmDAwjQ1EIFmFoMGJgJDqKkJ1GVY7mEIsQ0YZiOYqAQLBaQAcKAAKgMPAcOCriZOnepGgAQIo0DB3GBQZZ0KRp9GKotREFXgjaNASGHLUFft5UJRb01iBQl21VkDHMl7k5yx2JiAIRF4xEGKxJw25GAA45b60zdsFCp7cupHhbBFmdvvATQiUiJOWplKm9SqX+n8+K1KItzaoGLOhect9nrDj0Ai9qWAn5NjACjnAXRoArk1Knv/52mXlGpJGhWYGCxhVGRTM3LhsdErEsNmWbIpCZmw6FQkUjW//rzvgiKmIAAK0BoGR8GEYkaJA2J1Mm1/////5cp9ej1F9S30kC6PLqDBceJyg18mIBOQWU8oXgMCAN+IBOQXAAAAbTAoAYMC4KcwUQHAACWYIxSRgLOJGLQK+YWpGBqNCgAcGXB40QMShkwSmOB6ZOPhzcOAgUGGwiHG4LgVQdTICWCKvwI2yx20304GzoCzLECUhoEXUPRMJxmuy5F7F4BnJlOQJWP/7smTPhmfwYcqbuWzyOSC1tiUpEiDFkyuvcwcI8QNZQd9sQPHFh2UvSangUYQYSg2Fvm8kr+SXFxafkJoHifyhetYFgzP13F0cWsUb0zOcE3WnNGlzTI1DjJktlPO88kURbEcYBUXlqMErLVNleV3G5QlyZmJmZAq5elSMu0rHAiA10Ub2wqxa59r////////+Y37MkhbR7Ukjk5VeaU1bmOdvldYBuUCfPyWpx5J2O7e7fd9/////////Dv583VLCTTwKDjXsTslrj+SAjPBY5NWEmM8LYNfcTQEYyYeMhBwcMF2y4ZMCrHJfp///V/6/1bf6/iv2v9ff/29ehQDMCEBcZAIBoGZgIAGmAQF8ZbpHpofD7mFeY6ZOOAYADEIrMEhAyiKBqNGXBwO7ox8+zDItMRk0oE4YchIdFUEETPOXuHRQ4B+V+Im0gAHBwwhFL6jhBa4UsSLBsCWJdZiQYQQnBhyz0MHVTpL7gAEKEEEIs6DRBJJqK+n/sytf74vpck1iDHng5pKowxKNhhUqZCz1sqo79TNzVOtMSlLvSdMtULywG7LmAwUmFSAY0iKsEWpUfhxlr/zKj1V0zLBLBhMbk6yHjvOGgsqk0WNuTIP//////////1v98uSzte5ZtTt3t7D7P9g2nkO+UPdz1By2n/0sUC5iPmHHMMICaAI8BlOmjG7MHABgroAiceNA5xDh9BtLZgIPf////+9ltF///bHX7UkqN/+b9XY/vADhgUAomAqAEYHIFAQAmYnpSZilRRmC8FAYP5cxvRthczmPC+muY2E5hU1GbWqY4mpnpqGFQoYLJJQMQuDgwAEBJP/7smS6DufFWEoL3MnEOSDGgXv7EB9pYyhvcycAvQOcjdwkjI4PNmMDEUkE8RginUJJDwLeRQJSla6DQw4PEhRooMeoCiw4DxQI2zZSthMvLoECAksYYBcckFUoaivOMSqy7kMMynMolOqbqVQE1MegioOJtqXUtMq79WrSnT5JK0y/37R5gR/XGYI0IQPNNTWTceN40tk/+qcthgZQ941U2uF7yImPWl5QG8bioluu2XLfOf/////////beGept0tVO0WM/y1vvLX6gZo9XPfy/CSUN3ds19XSAwyRADphIahxbxhssXhjEvR753pYDg1rLuKna+BBO7///////////I/7P2TjWZusszrVABAB+ChAEQEg4ijCoTzEZOTqRRDiFsjCNQTSEWOGHoHBAEgITzGAGwuHwsoACSIxKC0GgyGA4BgJKwCR9RCKAixTKZzDcHw45KAEDREvOqDRoSX9DgFlEaFyKwuSiQITcYtRRZnaWyBo61QCKJsNWYZG98iLxN0gTGA6GAoTB8WLt3EwuKegiCpRzdrG3IF4SSB2VNTUbn3AexqKoo8yl6l7wUwFjb9yiWZtcg14lbSEbyvrNRZTKpJoMXdmVryv/+v//8f/bJhyWUwX1AJ+GmlGhh+Oa210QlSLZLDlK9Uyu4Ol5RNi3H3//////f/GM/M8815sAAWR0EqQyx1zvm5MHgUweqODABYFaEOFFQr//////7k+lae9Ke7/+n/T3dKfSAAEmFWGaYIQP5gwggmBeDcYQwcRm0zRGD8IEZeBHR+wTigbAA0MFDQzcajbavNbpA0/UzOcDMllc1B00kkGABo8lf/7smSzDOeuZUubuHzwLeC3U3NpEyFdYyRPc0bA9wOZgf0wUKWqBXcMfDJZCoSQiIWyuJkAY1DqfEYAxpoVcjjVDRPkoQAoMAi5ecgHkB9F4WNl9qdMhCWDBRhICHVsCXbNFjsU7GGDQ+wxWjbeum6peG0scLFpSABbcnHgaIJYfcVpxHQcVRHWEVdZSaBgKFlQA0EuUZIU/qAhwh4EX1LVAgQyYmEsKbgjSh40cWJFQ697puAvZBx7WNzCPCabUGb4Y//8///X87jj2m5udm5F/N41K8aq5arZ26S7BEnpMaakw1ftY2zX/SEZEwUkEtNP9FXDUdxcgxPMK9Agg7swKky1CRbOxYfnvCVpF+z/Z9+zv9n+zvd2P7uzp8j1a7H6XD9n69+mn/rVAACzBECZMHMFAt2YQIIhhxEaGWizCYSBrpi0gWlHjMGlAw0RDA4IMNlcx0VjMQYMkQwzazgugCbQFDpigpYFBrNB3ZaxYKXJdpoPu1siNGZhohjAtGMog1tPszRXBQklyXrBWgXMcAoDTJqLAlQcgdMd1QJ90VoSwCYsU7mtHgxqOKi0oV43Gla8Yw9AKiNgaHCI+/PbS97TXXnQksidyZbZIp5EpmnsNCB0lnnarACUymKDz8Jh23gafFqgsQOBqFJ/SplSkWvNhgR/mgxSNb1z///5+v1/P+r9Wxqdwo/7XqTPZzWr/NyKCtV+Vt1crczaxvd+vaTLECIAACcAAAAKcMFGc217zOGVTe0Zz5SBQKxn9pt2nNII///////2/7f/077er/Iy36gOMEAOIlBfMJMFAwRApRox41wB1zHjA3MS4YcwOP/7sGSkDqfXWcoT3MmwL+C3LXO5AR5xYyhPbwcA0QNahe5kQtDBMLIJlyCSJBlESFCQUeTm0k0SGFlMMIgCDwITSTpLtGALCSZaxk19QYCEEWxepLCCTA0OEAtiymPkphmCiaYQ8ELEdBI5mDtEAwYwXInTtERgkTaTnZdeGX+attx2cRdazwjKjC5mpVOxh+n7glz7klbFmkpA6mTLk/X5kBYTtAoeEytpCRgDWpmlCjvAxAuCVgo7NqFXnQZ7DKUUPNSXxDbasNhDZXIpHywz//7+//f7//5MauzuF/B15ujjHI5Wu7u3/u0k1eu36C3ardwr7Mf8nKJeYJwDxhjnpmhx4Wc0YexyIJGdQKewAC3ASBfxc8MZ///////q/dFtOvbmW17fr9ztczu+lQAAAJTANBmMBwAwaFLMC4FMwSRwzKFTGMjAH0wfxTB0AwwDgCjAgA1ZYY0NmCoxq5kfboGVCJhJ4GQbXUIEDS7DZR4nFgNZdVZqpY8+6yQuDkQqSAipBYKAIo1lIOeQToI3rLIoBlAH7Zy6MKfQWBwUfA8zQUJwl2RG7Jw/GY1eVNh5ivFvB8AQUeCMFVdM1Nb0JLALsdI9C2duEqWBLDYCLczCJcABlOG4FoahHGYUmGi40Mnw0iXq8w3NgGvIdKwrEU4w95//////z+5+VwrDsrm92p8t9XL533q+8w2Xkacvp47bG9//9f/6/+Me+Ye/isXCwIAAUSSmMEmfqmRo+oYqoORzhoOLJWutRXKoc////+xxUV/+rqH09/1NQ1VfVsr+lVC/WyjKGBSD8YBQNJgtg6hwNxh5CqmfXCiZSnoc//uyZKGOp6pmSxvbevA14Lc3a9oBH1VbJA93JUECg1lFz+gISnsaRA8YEDkZJAiYNgkY6h0SCEYiAwcNGAYTE8Ybg0TI8jgAgCJgEFrVmGyUWyHAV3M7L7N0W0BqBDKUMJNGsKA3BJIyEChZiLNRYERAhZRhg6AXER+V1DiMiHM9GQjRvi9TUWerDSC+2NfUoU9k2jfyRTROwVYkiJQBLUeVE0duTzWbREHgtNMABIsQpHmk4jMjBMGQCMMZYXvDj3BDACIFl6QT6IXwSvlzZMkuFwl4uyVQYw6Y8MtNhLeQNMVX+y/X7//5+vv///j3DH/ry/fb+sN4b3/3Kvfuf9/C4j+jplAmzxefMgZjLKIoYEuIOmELgOZgdABkf0+cgwak2YkeWoZXSKar//////+2t/269Kp/ftxPr6lB9UDsW3J1l0itSgCMJEVkKAGmD8EWYFIGJgdKHGWcnIYuZ/xhrkHmdBiATYLQACCsiZJhQVGfSIbrsZgE/mAwuJR5SgtksYSXqiNSdSDFBs6tYUErAteMefGCJihBIjTeNWNERslSFt2mAkAFxQ6BYiYIYPBR4KyxOGBF5IOHRJAJeo0utUK2oOgeq8TW4qp7FN7BxxgGqJLZCF+A4QutY7G2qOphG06MVKVUhIG1mOQe55edxVAgcNbLVd0fGPGxZf7SEFY+0SlRdh1+lyvQkVAiwKnlly6BVF3UcWXuRV3vX///v/33v/9bt6Ra+hdz+1LNv7P3e/lM459sZ0YskR/o6JUBgAAEZ6fQS9TagrOXzYPThY5BfFKztbVKMQFQKn///////9Hv/x8U2f3sYtj28jiJ//uyZJWOp9BVyQvc0cQxYMa2c28RIH1XIA9zRwDwgxjB/2gA5gyC4mBeBOYVwQIOECMPKG41/RoDHiOGMVYLM0WPzDp2NSGczKNjLoABqOMLu85f/AVFASHRKdCAFgwHJhmHAAk0acWCmxhQqTKxHYegw4cwCQCkTQiRVCQkTIGjFBAwkpYXCCgcRkUb2qCFYZgWVRLmqx1y2aAk5gMoEPvGkYEiVTQuou1LWjU4ghp7WJwwId8lSiEKlgYMYsVDJWdoieMtgZfc0qgy8IZJ9KpSllBZ138iY+XnSTBAwAmWdCR9fxMtQDRZEV9yUK87m2wsOTCRAaysKttUDOFqtza9aUOfPH////+/+7HP/uf713eEC0H3O773/7/0N/fbF3ouBCn/aiRMG5D7jCN1FU11wuAgbUNbDVUoTDwROtlccq7evvytLPSvOOv+nf/vXEOxP7jjlDl2XM/3OvX9u352pv21ACACAD8YQBQYghJFyYQzA7XjixtTDVQjIgtDG8BQuGBiICgODJgQ8ExioDwskphkCxdkoDdSh85GogX0KALWY0KMzsWU+pQglHmF6lzLDKztsjuPAhTgTkZdpXyDK2Zvu2QpTtBQAKmXiyRwopjUf50LUhzgGNQPEYpZUbh9WeOw9TXYRhflWo5EXclMSmX5aNlVfyHNPyLOibH4KU9ST0D1INhcbxTuhy1IH6uhARhAg2QhMAulH///1/nXuHSSRHIIBMUmCoax7Plx4RDxs8EQfhGcO8gzcgFWK0Suf//47/bzLX3S4DmB+ggZgt6TQeZgxp4anqcApQ4JXsLm5Ud////V+z/q9366B2LV//uyZIcI5ztly7u4XPA4YLZRf5kAH51jJE37QwEAg1iB7WBAr0WjK7KDShlbGeoou5HdX/+8AAONvTTgyQ0diMfJTBQcIMjJBowziWjFqDqMDwDodCWMDwGBp4cECYHIDgEHuNxLNFXMYbPaQIlYNIMOHgQXPGdJCUFxGhtej6yQgEacsNDkvSE0UDEqioRBoVqa02eqHIvrgLZBAYGDVh4LlClCjpQaQRPIpmpgxZ6ZiDXFb5iEIlrSIcl64E4FJocSIUt1k6hD+QWrRZYPKJAxmMu6zx2VxtOXfKZQwEkANGLigo4lKGF0CoBQHMTa1RyZV8IjDQkYUy5MxSUKcIhtZaN7tsBe3f///////rv/+u/fvxu230ep6kvtW7HI9Y5g9Vi1ytQ9rXpZ9+bf/1CcmYuBoptBRDmt0HSED/AuiNbiOI9NHBlDx1toDAww7p//tjm0GGo6/a5Sl+i2LonHahQX7Wf+qta7btfzClL//6kAAACMwTAHjA9AMCoLxgAAYGCQugYnRVJwZtHYFoYsFoMRBhwEhUFJ0hgHMO8IzYHTAoCWSA258ODmSqESwFG41KPDL0WETRT0EAoHEAszwNNVOFjlLm6BDzSUjnZjT7A54mdMA9Qd4ZpZcGCTipWpLUaNNP/fiMPMBi8VmoCjLV25RVVzDBYJNB1mxsreNT1DAVaBZomEbjB1VzmWupYa+pcSjDoCAwFMoEUmmUJxqAZK011FGpzLByElxU7XXXW+DQSoO09ZtC6y+Jb/P/////X////N09NHr8N0D4Z6i9nKd+vYr24fnYDykM3fePVnf3h3/LAMSACa3aG/hZ8K//uyZIAH979YyZvcyUBBoLXhb1gAHVFjKK9zBUAAADSAAAAEINYAb5fBS9ejlw/SA6Gnf/qDv/5U6JQ0oGjv8GoNPEp3UDXyuIpaCp37vyMRQVBaDQNA0JQVBV3h1AHA/GBiAkBAADAuAwMDxToyUBADo58NxE4y0MCU2GBgQX6BwTHQ0Y5pRwhHGLQUDAGJGIWBo0AHuSJEFjOdLlmsAv+oXTiIA9NFFiYjDTKLzqBSYjDHRXyyhBUEnC2SotWJ94asKmXWv5MZe60Hahy5En5bFBECV5Lae5KqHWLECkwkiFMovQUrm+0HcVTIjz0wzKHvaU/NxxGqMoSotlFnVbpTlAl7Rx29J/X55yEtXzaw8zkPA5rTUmrdDAjPpP//////+v///+fZuTExg9squV5PLsKP5LYysQDuzftyW/EaPv8oHf+wEQCMEQKQwnQCzBBBLEQD5gaQlGDmHgbdfxwAMBmwMlMQaN6c5iEGGORaYnoBzAImFBCMBMDIouWBg8zcaWEVBgvp0tCVE8SLJgEmKSCHiNIWTV6w4yVyy4QUGAo7K6LOozA0URXj4BhqhD0VdodBV1Drdy9A8AnVBrE5yaXsnu7szLHrtQOggfFOIhiXwgOKwHEYi6TUJU5bdYjPMFRaiTYF9qmkc6XHWkMHL0EZAMGZOY4ajpEEIAZHDz7LKXQlwhqmgpIqGXF5t/LRA4ptHIcaC4bna5/////5fn+9c/7epj7tPun3apf793OxZw7QfhzccycA3f+KFwJHgNzCJAMDA0zARBZMA+KAxrxaTSi0MpEMMtJhFJAaFmBwmCg+ZTGQyeD+hZLxiETi//uyZJWO98hWyIvcyVAAAA0gAAABHpFjIk9zJQAAADSAAAAEWTzAwqNjUBVqC4bJg4RXiPMaMY4BAF2QwweSgF5wMImEOKPmsOJKqYl/pWZTpk8BYcHbq9f5QNW96CIFVVEpbVZmE7GY4po1KpRw9C1frzYWoyDQCgQdLUYdqMsGe2kcJu10kDZSkRTMafxMa9XLovcKjK4TFMVhYEIOQ7wAjNTulTuJGoQRHoIosmG3i+GirfLJKQbd44FVRsZ//////4/r958/6LC5e7DvZPdyy+1rPD5+t8rwu1rFHYzu8qv/6kFFAIwCwuDBxBZMBsAkwAwMTAypUM3MHkAIg1KUQFUTAKuCL+JAgUHJiMZGaEOemJQCGxhYRISk0hIR7g6csQFvkekJFOhslMhEHBAZI75oHL7KOGcYYCzrF4EEKQbTUCaXZnFnaqZwptgq+mwCS+sOLGHmkFVYWJMPlTst3XG5jyxHFYdg6OSb6WYIBRpFDZe1d+VLExojGWfx59XwGlZSxp9FbnhfQZYS0UKUMStEcpAKKBI2qIJ+4Ii3VyJltqBhHih8urC2EtFULLDbatszm7Dr2///////ruP/v+fTa+puVVKaz9Xlj8627n/e/Ld6U3Ef/Ww+AAD///y////////B+clyjZSWNoE5Zt69AqTiAqTGROToF5RbCghCQNhhdgLh4ybYBPdt+4gB0CAERoI4mAdMAMDYKMoGNiAMFAAzBzAzDgcTAhBOGgvwaAYQiJjQYaLVn7B6zEOpEArWLhNcTVQaQicZVmS/YSjynW6IqKoVwJABfNWcUAEmWKtndBf6mzqiETcMWAoj//uyZMYK569WSAvcyUA0bPXCACn2HEljKO9t68Dts5pEAT/aH4LeB0DbE0LsgkC2LaOYFSnorA3pNWsh7oIDsL1DUuYOIJ5F7WlJIVxACb7c1Kcx5soX5fCfixIMDIjwKBxq85IxT7S7Dgb6ngFFY/or4hpN0KQaGNSVx////////TR6xvO6Iyrl6WDCgMPgV0dLbOzZWW16kn1qySL+h74HBFCIP9Xp6f///////////4RRtky+DbFrVivb00aZIwCMi0SPWLegyDkvbk4FQAcFgJwoSSIeShlLoQhwo5IwVwYAgXISBRMD8NAwHMZDDdDgMCHswWWTJQFDAIEasVH79GeDMag2Z1oOkwzMDgoDJmA4gUvdf4ZECs2LhkVoiPTiHSEpAUcZjyhbIg5Uw0gaqDiIgQjRYgKS3LTI9ArcIaNsyFrTEYsAIzJMBYNEF5U44dp2SP0rdJYvC5e4KhAcCnbGkbhGIkhBS+Lr4K+e3Jh+mXkIhEepy47aNnSykZgEqBKKhASyALMWoUpSDdBobwrYssRlfigCnbZlz2VivVF3GQig9b7NsJDr//+f/6/XN/vPf1P/Pkoysf3f3/3/2knQuBBwv/5VU8AAYf/////8/yy/H0////8FaDQIvK4yq5MCdm2MorMTL8O8BCLRZplOqjaA19sQiHVT7m0lwwYiAtVH9N9cYjBeAuMIkAosADmA+FoYeOChnMB8GSYkmUAymDQaiRIGToIFAWGBwVGFANGH8smUgSjgFGDAClagkLEUUi3Zf8/qEQy50sVgCgkGUgREsJ+AyIDwGVHwHkAbijQsZag6xGVQICkQvLfD//uyZMmO52NSR4PcyUA+DNcCADj2niFbHi93BQDls1zMAL/Y62Gq3iwXWXkqdHqfUvR8bpjqA1VW5Oe4NpxVeSJo6NDUVkBg4bduiaI0x/4EZZbHjJTEX0RZevp8VxUxJRXSAVGhCkK9VaPzWuy1dtQoYxdfWeKab0va2l1dT0JvNxaw9a4mCzs5j///P/Wua5r8N9+3j212XY3v/V3v4f97+5fr9ffYKf7+NSPwP//r87l/rz/715////8iRxaCmj3JwVIt9aDmP84no6Sxh1Hk4KQgYQM4l52toDJAALRll8enarIBgAAAEZgagQGCiBcEAXmBcCgYsLUhqWA+CUKMxE0Ai0wSfAEpjBoMGBEMig4YvzMYHJiwREsSiYpiEL8IFpZk3gud+lEFessVXawOONlU+YyTINzwIZH4iEgRbE6SRM0BQAV4CMiut5h6Oj6S5KJnK2W5PJJJyHazxQ3RwVD0ZglY0GLVYs+40acmJBLGOSGBLS5JfDRFJBaeWDemWVFrt4tkeKt8taw8upKZG0JozQGWOnS7axBsXea1Asca/CFGHph6B4l/P/f//77+ub//v6jO6sjk8A0Lz5cxoeTufNT1TDHWOEuztVu3tu+3i1QmAAAFA//////7f30b6f////YwSYC6syuV3EhmbVIKR0RSQUKGF2mDl1wsuUuEoNF39mH+tatMiZNcdphz9XeCAIHAkI+YKIJxhhBlmo+zacYAvJoGVQVJcwPBAyLGgwECQAieBRgMOi6NF6yP0kMGFMIIBQMqJn1DCIqLMG1ZEx1DeH1ahoUpoYQsF3IJpSMKgTDCkfTHmBawvckG//uyZMaK54hYyLvcwUA+bObjALj2H6FhGi93RMDusBlAEFX4NLLZgorOmFMIITGlF4OagHQQtPZWgCUuxBwYaCNrCJ6Ut3cmtLVrt3SFSsdtrqCiOoGIMiao5CSLJWJNLWHbnRNlKExgBrmKggNEhwQoJh5N4iAgIUOoFVjMDZIlvDw4AYeu2embDE3cfR4cnWlQoBWUulzYFTE1P9//7+X/z9Y1vx337m6ueVBcpt6+vY/f/Z7nrvcpm7rLttr/01WC/y//1///Xrq9fv9dXt/Xr//r///6iaTD0wMGFkDHAHAxyIQMlIECoEAWEAGARKBgMEAwAkPHCYujEurrAISCHMHkDUlBiMCkZExBNQQYOGYwCxqM4mEC4aAVIKMoCJBgkeGiTwZIkZRlQgbgQDGKIFRoIfsuioILiFpV7qZN3T2MgBEg+rCWVchIOmIccAjODF4DLpsBITUzVeAk4RMg5IUAW8nuWlQWgwmFFiBgNuysK8brhStp7Ub8jhTS3iWLDifSXqaAlayF6nCYW88OqXS1KpLKB1cEIj8rDOwv2GklHeTcKBGgqmU4H3nzUxdNVBPtl7D7uEIaU70ZeSEzSZC8kg0GsGB1b9r/////z5/d//393dZz2GXHyxy1dvd3/53ccsv1MbvXSl/+vY4AAD9D//9NeqaP6da6LbX8s+n///+E1SJOogQIBCDg0oudWJkBJSiBNHpcVyRrhc2gB4QDmAgnTB3A8MB4DcwVwxDUmTaMtMHY3YRCH8wZIKEYxwBMDCgEAGSpp6ZOGRJgACFwIPgXZVpkaaa0g1qlidD80i/IUKNP6Rmz8q5ISgdy//uyZLoG55BXRwvcyUQyDLbzAEn2XR1bIO9vBQD0s5vMA7/Y3Cm0RT5kgwO60BBMnKieztOlQ9WRSLvMveNy1dQNIrchr0Nq/KYKjsHtOVQlSXbDlTt2Xw+3Gpy5jsAbU+xl6FXQp6YIp5h6pxWSH4imWy08AlqwT8xJb0MXZfSRqq2PCExbBymsI/WZM9E3f5/////7/98/9drxm1AM9ZbHAam9p/e1YrSYdxq5RLC/brU1PZPBKr6kxSouBQP////////p/////54KFqTwvoGoSMuZ/ljHyMw5CAznIwNozzIHqHwoYoNhsATAghUBKwWYxwRgMdRue4QAQgSAECT8JBVmE6AuVgOjQVBpgl4GHMBMaOMiSiBSAmWxIYAAS7xhOMYy/ohg6ptIPPX3Z9EdtkmrSuYIZUwNeiPZGyDWOszQkq4WSx53V5SRhL9PsyAtLE0e2VN1cdpdiedAvqMCSvfa+9b6zscpq8tpKzOWwNNiksRaoovM1GhShp8niLfUCMkBtbpMmpz8Mv6zptoWSncoGtvStjmbQpu7aemhpJ2VTMM9ghsTsQ9Yhnf87//////+//9WdTWUtvW4BlSg1uDLUEyDdrKXfyvhaos6aU17HZ+lr2qv6M7vonAJG/////////MTOMv732vDIL5Y4Q7zbCOneSAMgDkXsNWrSHwS22JSX00hC28f4uhzHMlicFCdYUFaLs4IAAgQAAAACI3UI6qgsCjnvDembBMKoHMwCfIR0y5FOXETCA0ycQEBYdSyH86Q0/GDjBKSDo4oABQ0RiKKAkCmCA6GZMFJkQO08u4NCxoYQIAcWAC9oWAw//uyZLyA9zdYSWvbwTI6jOcwAA+uH81bHa17YgDas52AAD64cymCgaLKcpAFwSn0hUQgbmmBAIVAGMlp28SPXc09MUrAC+46MP7B16moX5ahRXHMapAQwAMyXoLAKqKNTS0OLK3agiDWNPy2Ft0EbTCIDkMPQa4ynbPWsp0QROIYkQGYSIRpsqjEfalHopI2EXW8bFc02C48bwOvDNl+scr2tf//+v/W///vZXKl77UMPcq29JMK8tv0mqWpflv9l30udp5wt9T+9aP////////lrlT6reMffqtwXVy+KaOwp00m8vx2qeISBlOZvQxVKFrYTlfq9Iq1AKZxP0/DReWVMDkDswkQBTAcAHMHkV887W+jFZAkNoTTuxw7IhNiFTOpzXFDQcjG8T+mA4AYZcvw6wQEBwELGgChgO9KQBoREBNBHlMEyQwwBg30sqAR4OyswSA4Q8SSAaCpiYwgwNRx/goIEh4GKllwAcCoYlJFQQNHWGJFA4ChzBIwHKH5kMUjrNGrPk6EpYFEwoHaMhQHFxgK3ib0CxN0mo0jBmOv4p8cFqVjQaPUj6jwBgKDboBA1uzEAscKxBuBbuovoks/a8vVgUeUzlruu3LYWxOKTESSaX1IFPYUOPN7///98zxvd/+f/3/+tunyucBUYAksAsXOK/uu6P///////89DoBN1owS3MBTFQpy3ncbjgtsbeaZjKfJBGE71NKdZplRQ+ZzuJ8Po62FAl9NvbckTJEAgLTBTAEMG8DAxVA0z14C0MYQH8wiVjUIwNUl0xWdjA4KMaBEx2uDnQRDEmrkRwSE4AiKwii6CwIPGYKGNhIgh//uyZLiOd7hOxYPb0RA4zOdAAA+uHnk/Fi9zRMD3s12gIDK5AF5VFSIiZISaIwbHIAgjSFhwAaJgpEwAxFHVEpeqUDSSIUmCXxMoHFEhexJJoQcfSQLgJfgAWIyIsQlNtlU2xCt8NMqfhmIOEUKgoQCX2UHHZb5izM1/RlF2dlrElgCQCydgMFvQulfCh66h4vAb2gEYXoCMbSyqDTgZ2yp/pErG0mec9wZucXzan4DY+sG4jz2JZr/w/////985+8/3dnt7g2xGs7mOdiNJi6kIeQZ/uuDAUclP///+ZmZmZmZmZmaaUCepJAdqxIKA7lcl+WhOJZmfJj85HkwWjIG1B2TKUIKTdeiXPEcSDkRzdgPBqoSAAAA6AYOjCEMgCMJj10Rl1LZhQLyFxNHnGiQoOgYoMZKyEIO3hDLhpAWZSJkD2clh0EJcMRBAok5GlMZfJOgxZUsBu26O0m+Oud5Zz7v6Wt012UjgYddkkBGSgqwIqFYRocTX8omMLel/M3p7OSLtaIy50Y3VgVKCMPDHaNikRc63EZO+EwwdjMXb5/Z5obpQhy1dR2bKo2ClyIyvN+Gbt1i+bkSijnpqvTwxbeaOupPzq+c6b//n////93//9rLcF0n2oOrKepbcCyfCEdi9i7lhdqZf+dXfJXwPbLkVOaMpABuAXMyX////5mZmZmZmZmZ5DL4eiS6RDGMmkoTj88Kg0kQrhaIeSQysDQsk8ZGRAJokmh0SU6suD0NLJAB0ojjBCCPMGcGYwGgpzDlgIOtMf4w3Q8jQR4N8mM4IoAESjEAfFjUZUOplmRHOg+AiaYQJgFOhEODBwWU+//uyZK8CdxhYx7u7wTBAzMdwTAyuYFFbEg9zJcDnM15hQCa6MBYZFYcZxgYkREQoQzQ/MFAAwAXxZI4CjJTMCIyTxyIFNAcYIHFQACgzx90+gIQjUocEZpWA+QUGAKBgBu2yFNIxiTSTMsVuPU5IyxRl1yiTyVVKoo0hSAoQuCo0JFFymtF/4wi1GklJOtN0GujI7N2WQpOtcyh6v0dyIxNxmJcFJIGLl7Coe8iMaf5QO9C7V5R3Jsd2qzCIwAn8jlDsgSm+Db36z///+/u7zL+fvu72tVt18K+HdXt4a3zPfMdd1TTn313Rc6YBgBqAAtGRSRdH////////////3IETqIQAoFQaNK22GVEwIHRWqMihYktkC9I46BojA4WPl0Cb6gKbMDkKMwOgFgYAcYjTQx1yl+GHaEyY6Whm0ZmvigYXAAMEoUHJl86AAInHgGGHYzkO0uyYagohEQGKAkBhwRBswoXyQEihTtlkyVYx5yNIz0CIBOYyzzNiDqzEIUHGQAsTWXyIxR1BZBe0uyTDg7UtMJhCWRiAoJS4AUBNgoWHW/D7nS9UkYjLO4guYqgr3Q8a+Vslw3VeKIl4myRKdXdJmWw8XuL6seX+siMEQKeqwqzVFJK2YcSIgzbKWsOFw+hg5JQNEH4euMyBsHvlYnFaE3S5N+Qpv2KSj/8v////1vvN/y7zHX9u3pd2Z/D7288//X8/7+6X/r+nrfapRkDgrgGgyKv////////DWX7PD7Brwnz5FkqpOzvlrNWs5UZBUi4VcN8j9vmdzWIzUsOylWWh2xMjYxx3j45BYQEGBgBoYFoJpgag/GMxAgbT//uyZFRBR2Rvd24AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHNsb3dlZAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABjb252ZXJ0ZWQgYnkgY29udmVydDJtcDMubmV0AAD/";

        private readonly string minecraftoof =
           "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";

        private Config config = new Config {Name = string.Empty};

        public string Command => string.Empty;

        public string Help => "Oof!";

        public string Author => "Weespin";

        public string Name => "OOf!";
        public string Desc => "Play off sounds on kill";

        public void OnLoad()
        {
            Events.PlayerKill.OnPlayerKill += PlayerKill_OnPlayerKill;
            if (Directory.Exists("./oof/"))
            {
                if (File.Exists("./oof/conf.json"))
                {
                    config = JsonConvert.DeserializeObject<Config>(File.ReadAllText("./oof/conf.json"));
                    if (config.MinecraftOof)
                    {
                        sounds.Add(minecraftoof);
                    }

                    if (config.Oof)
                    {
                        sounds.Add(oof);
                    }

                    if (config.SlowOof)
                    {
                        sounds.Add(slowoff);
                    }
                }
                else
                {
                    File.WriteAllText("./oof/conf.json", JsonConvert.SerializeObject(new Config()));
                    Logger.Write(
                        Logger.Status.Info,
                        $"PLEASE EDIT {AppDomain.CurrentDomain.BaseDirectory}/oof/conf.json before using this plugin!");
                }
            }
            else
            {
                Directory.CreateDirectory("./oof/");
                File.WriteAllText("./oof/conf.json", JsonConvert.SerializeObject(new Config()));
                Logger.Write(
                    Logger.Status.Info,
                    $"PLEASE EDIT {AppDomain.CurrentDomain.BaseDirectory}/oof/conf.json before using this plugin!");
            }
        }

        private void PlayerKill_OnPlayerKill(Events.PlayerKillArgs e)
        {
            if (config.Name != string.Empty)
            {
                if (e.Killer == config.Name)
                {
                    Stream s = new MemoryStream(Convert.FromBase64String(sounds[new Random().Next(0, sounds.Count)]));
                    if (Instance.SoundOutExtra.PlaybackState == PlaybackState.Playing)
                    {
                        Instance.SoundOutExtra.Stop();
                    }

                    Instance.SoundOutExtra.Initialize(new DmoMp3Decoder(s));
                    Instance.SoundOutExtra.Play();
                }
            }
        }

        private class Config
        {
            public bool MinecraftOof { get; set; }

            public string Name { get; set; }

            public bool Oof { get; set; }

            public bool SlowOof { get; set; }
        }
    }
}