﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CSCore.Codecs.MP3;
using CSCore.SoundOut;
using RequestifyTF2.API;

namespace ChatFunCommands
{
    public class ChatFunPlugin : IRequestifyPlugin
    {
        private const string BruhSound =
           "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";

        private const string MisSound =
            "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";
        public string Author => "Weespin";
        public string Name => "FunnyChatCommands";
        public string Desc => "Some cancer";
        public void OnLoad()
        {
            Events.PlayerChat.OnPlayerChat += OnUndef;
        }

        private void OnUndef(Events.PlayerChatArgs e)
        {
           
            if (e.Chat.ToLower().Contains("bruh"))
            {
                Stream s = new MemoryStream(Convert.FromBase64String(BruhSound));
                Instance.QueueForeGround.Enqueue(new DmoMp3Decoder(s));
            }
            else if (e.Chat.ToLower().Contains("mis"))
            {
                Stream s = new MemoryStream(Convert.FromBase64String(MisSound));
                Instance.QueueForeGround.Enqueue(new DmoMp3Decoder(s));
            }
        }
    }
}
