import Vue from "vue";

import "normalize.css/normalize.css"; // A modern alternative to CSS resets

import ElementUI from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
import locale from "element-ui/lib/locale/lang/en"; // lang i18n

import "@/styles/index.scss"; // global css
import App from "./App";
import store from "./store";
import router from "./router";

import "@/icons"; // icon
import "@/permission"; // permission control
import '@@/utils/directive'
import {loadExtension} from '@@/extension/extension-loader'
loadExtension()

/**
 * 如果环境为development开启moke production
 */
// if (process.env.NODE_ENV === "development") {
//   const { mockXHR } = require("../mock");
//   mockXHR();
// }

// set ElementUI lang to EN
// Vue.use(ElementUI, { locale })
// 如果想要中文版 element-ui，按如下方式声明
Vue.use(ElementUI);

Vue.config.productionTip = false;
Vue.prototype.$EventBus = new Vue();

new Vue({
  el: "#app",
  router,
  store,
  render: (h) => h(App),
});
