/*
 *     Webcodesk
 *     Copyright (C) 2019  Oleksandr (Alex) Pustovalov
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

import path from 'path-browserify';
import template from 'lodash/template';
import { repairPath } from '../../utils/fileUtils';
import { checkFileExists } from '../utils';
import { format } from '../../utils/textUtils';

const templateContent = `
/**
 * This function is generated by Webcodesk. Replace this comment with a valuable description.
 * Don't forget to describe outputs and their compatibility with other functions or components.
 */
export const sampleFunction = (options, {stateByDispatch, history}) => dispatch => {
  // do something here with options;
  const { text, extraOptions } = options;
  // and pass them forward to the dispatcher
  const dispatchOptions = {
    text,
    extraOptions: {
      extraFlag: extraOptions.extraFlag,
    }
  };
  dispatch({optionsFromInput: dispatchOptions});
};
`;

// const templateContentProps = `
// import PropTypes from 'prop-types';
//
// export const SampleFunctionTypes = {
//   /**
//    * The first function argument.
//    */
//   argument: PropTypes.shape({
//     // text value
//     text: PropTypes.string,
//     // extra specific logic options for some processing
//     extraOptions: PropTypes.shape({
//       extraFlag: PropTypes.bool,
//     }),
//   }),
//   /**
//    * The function dispatch
//    */
//   dispatch: PropTypes.shape({
//     optionsFromInput: PropTypes.shape({
//       // text value
//       text: PropTypes.string,
//       // extra options after some processing
//       extraOptions: PropTypes.shape({
//         extraFlag: PropTypes.bool,
//       }),
//     }),
//   }),
// };
// `;

// const templateContentReadme = `
// ## Description
//
// It's a template for a new list of the reusable functions.
//
// ### __sampleFunction__
//
// Tell here what this function is for and how to use it.
// `;

export async function createFiles (fileName, dirName, destDirPath, fileExtension) {
  const fileObjects = [];
  let fileExists;
  const functionsFilePath = repairPath(path.join(destDirPath, dirName, `${fileName}.funcs${fileExtension}`));
  fileExists = await checkFileExists(functionsFilePath);
  if (fileExists) {
    throw Error(`The file with the "${fileName}.funcs${fileExtension}" name already exists.`);
  }
  // const functionsPropsFilePath = repairPath(path.join(destDirPath, dirName, `${fileName}.props${fileExtension}`));
  // fileExists = await checkFileExists(functionsPropsFilePath);
  // if (fileExists) {
  //   throw Error(`The file with the "${fileName}.props${fileExtension}" name already exists.`);
  // }
  // const functionsReadmeFilePath = repairPath(path.join(destDirPath, dirName, `${fileName}.md`));
  // fileExists = await checkFileExists(functionsReadmeFilePath);
  // if (fileExists) {
  //   throw Error(`The file with the "${fileName}.md" name already exists.`);
  // }
  fileObjects.push({
    filePath: functionsFilePath,
    fileData: format(template(templateContent)({fileName}))
  });
  // fileObjects.push({
  //   filePath: functionsPropsFilePath,
  //   fileData: format(template(templateContentProps)({fileName}))
  // });
  // fileObjects.push({
  //   filePath: functionsReadmeFilePath,
  //   fileData: template(templateContentReadme)({fileName})
  // });
  return fileObjects;
}
