//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

package cohere

import "fmt"

type cohereUrlBuilder struct {
	origin   string
	pathMask string
}

func newCohereUrlBuilder() *cohereUrlBuilder {
	return &cohereUrlBuilder{
		origin:   "https://api.cohere.ai",
		pathMask: "/v2/embed",
	}
}

func (c *cohereUrlBuilder) url(baseURL string) string {
	if baseURL != "" {
		return fmt.Sprintf("%s%s", baseURL, c.pathMask)
	}
	return fmt.Sprintf("%s%s", c.origin, c.pathMask)
}
