#!/usr/bin/env bash

set -euo pipefail
# Search for all tracked non-test .go files in the Git repository
all_files=$(git ls-files | grep -E '\.go$' | grep -vE '_test\.go$')

# Get all files with 'go ' in them, ignoring lines that start with a comment
files=$(grep -E -l '^[[:space:]]*[^/]*go ' ${all_files})

found_error=false


# check for permitted ussage (generated files and a few more things)
for file in $files; do
    # wrapper
    if [ "$file" == "entities/errors/go_wrapper.go" ]; then
        continue
    fi

    # autogenerated
    if [ "$file" == "adapters/handlers/rest/server.go" ]; then
        continue
    fi

    # test file
    if [ "$file" == "test/helper/sample-schema/books/books.go" ]; then
        continue
    fi

    # race happens when replacing the direct goroutine with a wrapper. Not important enough to investigate as nobody is
    # using classification.
    if [ "$file" == "usecases/classification/classifier_run.go" ]; then
        continue
    fi

    echo "Error: $file uses direct goroutines. Please use entities/errors/go_wrapper.go instead."
    found_error=true
done


if [ "$found_error" = true ]; then
    exit 1
fi
